/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.JSType;
import com.clumd.projects.javajson.core.Json;
import com.clumd.projects.javajson.core.JsonTape;
import com.clumd.projects.javajson.exceptions.json.JsonParseException;

final class JSBoolean
extends Json {
    private boolean myValue;

    JSBoolean(JsonTape parsingTape) throws JsonParseException {
        super(parsingTape);
        this.jsType = JSType.BOOLEAN;
        if (parsingTape.checkNextFragment("true") || parsingTape.checkNextFragment("True") || parsingTape.checkNextFragment("TRUE")) {
            this.myValue = true;
        } else if (parsingTape.checkNextFragment("false") || parsingTape.checkNextFragment("False") || parsingTape.checkNextFragment("FALSE")) {
            this.myValue = false;
        } else {
            parsingTape.createParseError("true / false");
        }
    }

    @Override
    public Boolean getValue() {
        return this.myValue;
    }

    @Override
    public String asString(int depth) {
        return String.valueOf(this.myValue);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof Boolean) {
            return this.myValue == (Boolean)other;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return ((JSBoolean)other).myValue == this.myValue;
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.myValue);
    }
}

