/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.JSString;
import com.clumd.projects.javajson.core.JSType;
import com.clumd.projects.javajson.core.Json;
import com.clumd.projects.javajson.core.JsonKey;
import com.clumd.projects.javajson.core.JsonTape;
import com.clumd.projects.javajson.exceptions.json.JsonParseException;
import com.clumd.projects.javajson.exceptions.json.KeyNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

final class JSObject
extends Json {
    private final HashMap<String, com.clumd.projects.javajson.api.Json> json;

    JSObject(JsonTape parsingTape) throws JsonParseException {
        super(parsingTape);
        this.jsType = JSType.OBJECT;
        parsingTape.consumeOne();
        parsingTape.consumeWhiteSpace();
        char checkingChar = parsingTape.checkCurrentChar();
        this.json = new HashMap();
        if (checkingChar == '}') {
            parsingTape.consumeOne();
            return;
        }
        if (checkingChar != '\"' && checkingChar != '\'') {
            throw (JsonParseException)parsingTape.createParseError("\"", "Missing Key at start of Object.");
        }
        boolean moreChildren = true;
        block6: while (moreChildren) {
            String key;
            try {
                key = ((JSString)parsingTape.parseNextElement()).getValue();
            }
            catch (ClassCastException e) {
                throw (JsonParseException)parsingTape.createParseErrorFromOffset(-1, "\"", "Invalid type for object key.");
            }
            assert (key != null);
            this.validateObjectKey(key, parsingTape);
            parsingTape.consumeWhiteSpace();
            if (parsingTape.consumeOne() != ':') {
                throw (JsonParseException)parsingTape.createParseErrorFromOffset(-1, ":", "Invalid Key:Value separator. Must use a colon(:).");
            }
            Json nextChild = parsingTape.parseNextElement();
            this.json.put(key, nextChild);
            parsingTape.consumeWhiteSpace();
            checkingChar = parsingTape.consumeOne();
            switch (checkingChar) {
                case '}': {
                    moreChildren = false;
                    continue block6;
                }
                case ',': {
                    parsingTape.consumeWhiteSpace();
                    if (parsingTape.checkCurrentChar() != '}') continue block6;
                    throw (JsonParseException)parsingTape.createParseError("{ / [ / \" / <number> / <boolean> ", "Comma suggests more object elements, but object terminates.");
                }
            }
            throw (JsonParseException)parsingTape.createParseErrorFromOffset(-1, ", / }", "Invalid object child delimiter.");
        }
    }

    private void validateObjectKey(String key, JsonTape parsingTape) {
        if (key.equals("")) {
            throw (JsonParseException)parsingTape.createParseError("<Valid Key>", "Illegal Object Key (Empty).");
        }
        if (this.json.containsKey(key)) {
            throw (JsonParseException)parsingTape.createParseError("<Unique Key>", "Illegal Object key (Duplicate): " + key);
        }
    }

    @Override
    public com.clumd.projects.javajson.api.Json getValue() {
        return this;
    }

    @Override
    public boolean contains(String keys) {
        try {
            this.getAnyAt(keys);
            return true;
        }
        catch (KeyNotFoundException e) {
            return false;
        }
    }

    @Override
    protected com.clumd.projects.javajson.api.Json getInternal(JsonKey keySequence) throws KeyNotFoundException {
        String nextKey = keySequence.getNextKey();
        if (nextKey.equals("")) {
            return this;
        }
        if (!nextKey.startsWith("{") && !nextKey.startsWith("<")) {
            throw keySequence.createKeyDifferentTypeException();
        }
        Json childElement = (Json)this.json.get(nextKey.substring(1));
        if (childElement == null) {
            throw keySequence.createKeyNotFoundException();
        }
        return childElement.getInternal(keySequence);
    }

    @Override
    public List<String> getKeys() {
        return new ArrayList<String>(this.json.keySet());
    }

    @Override
    public List<com.clumd.projects.javajson.api.Json> getValues() {
        return new ArrayList<com.clumd.projects.javajson.api.Json>(this.json.values());
    }

    @Override
    public String asString(int depth) {
        StringBuilder ret = new StringBuilder("{");
        if (this.json.size() == 0) {
            return ret.append('}').toString();
        }
        if (depth == 0) {
            this.getKeysAsCompressedForString(ret);
            return ret.append('}').toString();
        }
        for (String key : this.json.keySet()) {
            ret.append("\"").append(key.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"")).append("\"").append(":").append(this.json.get(key).asString(depth - 1)).append(",");
        }
        if (ret.charAt(ret.length() - 1) == ',') {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.append("}").toString();
    }

    private void getKeysAsCompressedForString(StringBuilder stringBuilder) {
        stringBuilder.append('<');
        String[] keys = new String[this.json.size()];
        this.json.keySet().toArray(keys);
        for (int i = 0; i < keys.length - 1; ++i) {
            stringBuilder.append(keys[i]).append(',');
        }
        stringBuilder.append(keys[keys.length - 1]).append(">");
    }

    @Override
    protected void asPrettyString(StringBuilder indent, String tabSize, StringBuilder result, int depth) {
        if (this.json.isEmpty()) {
            result.append("{}");
            return;
        }
        indent.append(tabSize);
        result.append('{').append('\n').append((CharSequence)indent);
        if (depth == 0) {
            this.getKeysAsCompressedForString(result);
        } else {
            this.json.forEach((key, value) -> {
                result.append('\"').append(key.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"")).append("\": ");
                ((Json)value).asPrettyString(indent, tabSize, result, depth - 1);
                result.append(",\n").append((CharSequence)indent);
            });
            result.delete(result.length() - 2 - indent.length(), result.length() - 1);
        }
        indent.delete(0, tabSize.length());
        result.append("\n").append((CharSequence)indent).append('}');
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        JSObject o = (JSObject)other;
        if (this.getKeys().size() != o.getKeys().size()) {
            return false;
        }
        for (String key : this.getKeys()) {
            if (!o.json.containsKey(key)) {
                return false;
            }
            if (this.json.get(key).equals(o.json.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.json.hashCode();
    }
}

