/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.Tape;
import com.clumd.projects.javajson.exceptions.json.JsonKeyException;
import com.clumd.projects.javajson.exceptions.json.KeyInvalidException;
import java.util.ArrayList;
import java.util.List;

class KeyTape
extends Tape<String, JsonKeyException> {
    private static final String VALID_KEY_ACCESSOR = "[ / <Object Key>";
    private int elementsInKeyWithSpaces = 0;
    private int elementsParsed = 0;

    public KeyTape(String fullInput) {
        super(fullInput);
    }

    public List<String> parseAllElements() throws JsonKeyException {
        if (this.fullInput.endsWith(".")) {
            throw (JsonKeyException)this.createParseErrorFromOffset(this.fullInput.length() - 1, "<object ref> / <end of key>", "Trailing dot separator in key suggests more elements, but end of string was found.");
        }
        ArrayList<String> allElements = new ArrayList<String>();
        while (this.currentIndex < this.fullInput.length()) {
            allElements.add(this.parseNextElement());
        }
        allElements.add("");
        return allElements;
    }

    @Override
    public String parseNextElement() {
        String nextElement;
        if (this.elementsParsed++ > 0 && this.elementsInKeyWithSpaces > 0) {
            throw (JsonKeyException)this.createParseErrorFromOffset(-1, "<valid key segment>", "Spaces are invalid in dot separated keys. Use obj[\"key\"] notation if key contains spaces.");
        }
        this.consumeWhiteSpace();
        block1 : switch (this.checkCurrentChar()) {
            case '[': {
                ++this.currentIndex;
                try {
                    this.consumeWhiteSpace();
                    switch (this.checkCurrentChar()) {
                        case '\"': 
                        case '\'': 
                        case '`': {
                            nextElement = this.parseObjectAccess(true);
                            break block1;
                        }
                    }
                    nextElement = this.parseArrayAccess();
                    break;
                }
                catch (IndexOutOfBoundsException e) {
                    throw (JsonKeyException)this.createParseErrorFromOffset(-1, "<key reference>", "Reached end of key before resolving all parts. Are you missing a delimiter?");
                }
            }
            case '.': {
                throw (JsonKeyException)this.createParseError(VALID_KEY_ACCESSOR, "Bad use of '.' separator in key");
            }
            default: {
                nextElement = this.parseObjectAccess(false);
            }
        }
        return nextElement;
    }

    @Override
    protected JsonKeyException newTypedException(String message) {
        return new KeyInvalidException(message);
    }

    private String parseArrayAccess() {
        int startingIndex = this.getCurrentIndex();
        try {
            while (this.checkCurrentChar() != ']') {
                ++this.currentIndex;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw (JsonKeyException)this.createParseErrorFromOffset(startingIndex - this.getCurrentIndex(), "<positive integer>", "Failed to parse array accessor in key. Reached end of key before delimiter ']' was found.");
        }
        return this.validateDeclaredArrayIndex(startingIndex);
    }

    protected String validateDeclaredArrayIndex(int startingIndex) {
        int arrayIndex;
        try {
            arrayIndex = Integer.parseInt(this.requestRegion(startingIndex, this.getCurrentIndex()));
        }
        catch (NumberFormatException e) {
            throw (JsonKeyException)this.createParseErrorFromOffset(startingIndex - this.getCurrentIndex(), "<positive integer>", "Failed to parse array accessor in key. Element was not a valid integer.");
        }
        if (arrayIndex < 0) {
            throw (JsonKeyException)this.createParseErrorFromOffset(startingIndex - this.getCurrentIndex(), "<positive integer>", "Array accessor in key was negative integer. Must be positive.");
        }
        this.consumeOne();
        if (this.currentIndex < this.fullInput.length()) {
            this.validateTrailingArrayElements();
        }
        return "[" + String.valueOf(arrayIndex);
    }

    private String parseObjectAccess(boolean enteredAdvancedObjectAccessSafely) {
        String keyRegion;
        int endOfAdvancedObjectAccess;
        int startIndex = this.getCurrentIndex();
        switch (this.checkCurrentChar()) {
            case '\'': {
                endOfAdvancedObjectAccess = this.consumeUntilMatchEndOfAdvancedObjectAccess(enteredAdvancedObjectAccessSafely, "'");
                break;
            }
            case '\"': {
                endOfAdvancedObjectAccess = this.consumeUntilMatchEndOfAdvancedObjectAccess(enteredAdvancedObjectAccessSafely, "\"");
                break;
            }
            case '`': {
                endOfAdvancedObjectAccess = this.consumeUntilMatchEndOfAdvancedObjectAccess(enteredAdvancedObjectAccessSafely, "`");
                break;
            }
            default: {
                try {
                    while (true) {
                        switch (this.checkCurrentChar()) {
                            case '.': {
                                String nextKey = "{" + this.requestRegion(startIndex, this.currentIndex++);
                                if (this.currentIndex >= this.fullInput.length()) {
                                    throw (JsonKeyException)this.createParseErrorFromOffset(-1, "<object ref> / <end of key>", "Trailing dot separator in key suggests more elements, but end of string was found.");
                                }
                                return nextKey;
                            }
                            case '[': {
                                return "{" + this.requestRegion(startIndex, this.currentIndex);
                            }
                            case ' ': {
                                ++this.elementsInKeyWithSpaces;
                            }
                        }
                        ++this.currentIndex;
                    }
                }
                catch (StringIndexOutOfBoundsException e) {
                    return "{" + this.requestRegion(startIndex, this.currentIndex);
                }
            }
        }
        boolean SKIP_KEY_START = true;
        if (this.currentIndex < this.fullInput.length() && this.consumeTrailingDotDelimiter()) {
            ++endOfAdvancedObjectAccess;
        }
        if ((keyRegion = this.requestRegion(startIndex + 1, this.getCurrentIndex() - endOfAdvancedObjectAccess)).length() == 0) {
            throw (JsonKeyException)this.createParseError("<Valid JSON Object Key>", "You cannot address a JSON object with an empty key.");
        }
        return "<" + keyRegion;
    }

    private int consumeUntilMatchEndOfAdvancedObjectAccess(boolean enteredAdvancedObjectAccessSafely, String delimiter) {
        if (!enteredAdvancedObjectAccessSafely) {
            throw (JsonKeyException)this.createParseErrorFromOffset(0, "<valid object key>", "Complex keys require square bracket delimiters in addition. (e.g. [`key`])");
        }
        boolean consuming = true;
        int closingQuote = 0;
        while (consuming) {
            while (!this.checkNextFragment(delimiter)) {
                ++this.currentIndex;
            }
            closingQuote = this.currentIndex - 1;
            this.consumeWhiteSpace();
            if (!this.checkNextFragment("]")) continue;
            consuming = false;
        }
        return this.currentIndex - closingQuote;
    }

    protected void validateTrailingArrayElements() {
        this.consumeWhiteSpace();
        switch (this.checkCurrentChar()) {
            case '.': {
                this.consumeTrailingDotDelimiter();
                break;
            }
            case '[': {
                break;
            }
            default: {
                throw (JsonKeyException)this.createParseError("[ / .", "Invalid continuation from array key");
            }
        }
    }

    private boolean consumeTrailingDotDelimiter() {
        if (this.checkCurrentChar() == '.') {
            this.consumeOne();
            return true;
        }
        return false;
    }
}

