/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.api;

import com.clumd.projects.javajson.api.Json;
import com.clumd.projects.javajson.api.JsonParser;
import com.clumd.projects.javajson.api.JsonSchemaEnforceable;
import com.clumd.projects.javajson.core.JSType;
import com.clumd.projects.javajson.exceptions.SchemaException;
import com.clumd.projects.javajson.exceptions.json.KeyDifferentTypeException;
import com.clumd.projects.javajson.exceptions.json.KeyNotFoundException;
import com.clumd.projects.javajson.exceptions.schema.InvalidSchemaException;
import com.clumd.projects.javajson.exceptions.schema.SchemaViolationException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JsonSchemaEnforcer
implements JsonSchemaEnforceable {
    public static boolean validateStrict(Json objectToValidate, Json againstSchema) {
        return new JsonSchemaEnforcer().validateWithOutReasoning(objectToValidate, againstSchema);
    }

    public static boolean validate(Json objectToValidate, Json againstSchema) {
        return new JsonSchemaEnforcer().validateWithReasoning(objectToValidate, againstSchema);
    }

    @Override
    public boolean validateWithReasoning(Json objectToValidate, Json againstSchema) throws SchemaException {
        return new JsonSchemaEnforcer().instanceValidate(objectToValidate, againstSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean instanceValidate(Json objectToValidate, Json schema) throws SchemaException {
        if (schema == null) {
            throw new SchemaException("You cannot validate against a null schema.");
        }
        if (objectToValidate == null) {
            throw new SchemaException("A null object cannot be validated against a schema.");
        }
        if (schema.getDataType() != JSType.OBJECT) {
            throw new SchemaException("JSON Schemas MUST be a valid JSON Object with defined mandatory keys and structure. You provided a " + schema.getDataType() + ".");
        }
        Set<String> subSchemaReferencesSeen = Stream.of("").collect(Collectors.toSet());
        try {
            boolean bl = new JsonSchemaEnforcerPart(objectToValidate, schema, schema, "", subSchemaReferencesSeen).enforce();
            return bl;
        }
        finally {
            System.gc();
        }
    }

    private void validateAllOf(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        this.validateArrayBasedConditional(partStructure, () -> {
            for (String arrayIndex : partStructure.schema.getKeys()) {
                this.subEnforce(currentPart, partStructure.schema.getAnyAt("[" + arrayIndex + "]"), partStructure.canonicalPath + ".allOf[" + arrayIndex + "]");
            }
            return null;
        });
    }

    private void validateAnyOf(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        this.validateArrayBasedConditional(partStructure, () -> {
            for (String arrayIndex : partStructure.schema.getKeys()) {
                try {
                    this.subEnforce(currentPart, partStructure.schema.getAnyAt("[" + arrayIndex + "]"), partStructure.canonicalPath + ".anyOf[" + arrayIndex + "]");
                    return null;
                }
                catch (SchemaException schemaException) {
                }
            }
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "A provided JSON value failed to match any of the sub-schemas provided.");
        });
    }

    private void validateOneOf(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        this.validateArrayBasedConditional(partStructure, () -> {
            long schemasMatched = 0L;
            for (String arrayIndex : partStructure.schema.getKeys()) {
                try {
                    this.subEnforce(currentPart, partStructure.schema.getAnyAt("[" + arrayIndex + "]"), partStructure.canonicalPath + ".oneOf[" + arrayIndex + "]");
                }
                catch (SchemaException e) {
                    --schemasMatched;
                }
                if (++schemasMatched <= 1L) continue;
                throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Json validated against more than one sub-schema.");
            }
            if (schemasMatched != 1L) {
                throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "A provided JSON value failed to match any of the sub-schemas provided.");
            }
            return null;
        });
    }

    private void validateNot(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        try {
            this.subEnforce(currentPart, partStructure.schema, partStructure.canonicalPath + ".not");
        }
        catch (SchemaException e) {
            return;
        }
        throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Json successfully validated against the sub-schema, but a failure was required.");
    }

    private void validateIf(JsonSchemaEnforcerPart currentPart) {
        boolean validatedAgainstIf = false;
        try {
            this.subEnforce(currentPart, currentPart.resolvableConstraints.get((Object)"if").schema, currentPart.resolvableConstraints.get((Object)"if").canonicalPath + ".if");
            validatedAgainstIf = true;
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
        if (validatedAgainstIf && currentPart.resolvableConstraints.containsKey("then")) {
            this.subEnforce(currentPart, currentPart.resolvableConstraints.get((Object)"then").schema, currentPart.resolvableConstraints.get((Object)"then").canonicalPath + ".then");
        } else if (!validatedAgainstIf && currentPart.resolvableConstraints.containsKey("else")) {
            this.subEnforce(currentPart, currentPart.resolvableConstraints.get((Object)"else").schema, currentPart.resolvableConstraints.get((Object)"else").canonicalPath + ".else");
        }
    }

    private void validateType(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        switch (partStructure.schema.getDataType()) {
            case STRING: {
                this.validateType(currentPart, partStructure, Collections.singletonList(partStructure.schema.getString().toUpperCase()));
                break;
            }
            case ARRAY: {
                HashSet<String> distinctTypes = new HashSet<String>(10);
                for (Json distinctType : partStructure.schema.getArray()) {
                    try {
                        distinctTypes.add(distinctType.getString().toUpperCase());
                    }
                    catch (KeyDifferentTypeException e) {
                        throw this.valueUnexpected(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "All values in the (type) property MUST be a valid, distinct STRING.", e);
                    }
                }
                if (distinctTypes.size() == 0) {
                    throw this.valueUnexpected(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "You must provide at least one valid data type restriction.");
                }
                this.validateType(currentPart, partStructure, new ArrayList<String>(distinctTypes));
                break;
            }
            default: {
                throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Expected one of " + Arrays.asList("STRING", "ARRAY") + ", got " + partStructure.schema.getDataType() + ".");
            }
        }
    }

    private void validateType(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure, List<String> allowedTypes) {
        JSType currentDataType = currentPart.OBJECT_TO_VALIDATE.getDataType();
        Iterator<String> iterator = allowedTypes.iterator();
        block20: while (iterator.hasNext()) {
            String allowedType;
            switch (allowedType = iterator.next()) {
                case "ARRAY": 
                case "LIST": {
                    if (currentDataType != JSType.ARRAY) continue block20;
                    return;
                }
                case "BOOLEAN": {
                    if (currentDataType != JSType.BOOLEAN) continue block20;
                    return;
                }
                case "LONG": 
                case "INTEGER": {
                    if (currentDataType != JSType.LONG) continue block20;
                    return;
                }
                case "DOUBLE": {
                    if (currentDataType != JSType.DOUBLE) continue block20;
                    return;
                }
                case "NUMBER": {
                    if (currentDataType != JSType.DOUBLE && currentDataType != JSType.LONG) continue block20;
                    return;
                }
                case "STRING": {
                    if (currentDataType != JSType.STRING) continue block20;
                    return;
                }
                case "OBJECT": {
                    if (currentDataType != JSType.OBJECT) continue block20;
                    return;
                }
            }
            throw this.valueUnexpected(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Unrecognised/Unsupported type provided (" + allowedType + ").");
        }
        throw this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Expected one of " + allowedTypes + ", got " + currentDataType + ".");
    }

    private void validateEnum(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        this.tryForSchema(partStructure, () -> {
            for (Json instance : partStructure.schema.getArray()) {
                if (!currentPart.OBJECT_TO_VALIDATE.equals(instance)) continue;
                return null;
            }
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Object did not match any options provided by the enum.");
        });
    }

    private void validateMultipleOf(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        BigDecimal numberFromSchema = this.getNumberAsBigDecimal(currentPart, partStructure.propertyName, true);
        if (numberFromSchema.equals(BigDecimal.ZERO)) {
            throw this.valueUnexpected(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "You cannot use a multiple of 0.");
        }
        if (this.getNumberAsBigDecimal(currentPart, partStructure.propertyName, false).remainder(numberFromSchema).compareTo(BigDecimal.ZERO) != 0) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Value was not a multiple of schema value.");
        }
    }

    private void validateMaximum(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        if (this.compareNumbers(currentPart, partStructure.propertyName) > 0) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Value was greater than the upper bound.");
        }
    }

    private void validateExclusiveMaximum(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        if (this.compareNumbers(currentPart, partStructure.propertyName) >= 0) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Value was greater than or equal to the upper bound.");
        }
    }

    private void validateMinimum(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        if (this.compareNumbers(currentPart, partStructure.propertyName) < 0) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Value was lower than the lower bound.");
        }
    }

    private void validateExclusiveMinimum(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        if (this.compareNumbers(currentPart, partStructure.propertyName) <= 0) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Value was lower than or equal to the lower bound.");
        }
    }

    private void validateProperties(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        Set<String> keysToValidate = this.getKeysRelevantToConstraint(currentPart, partStructure, KeysRelevantTo.PROPERTIES);
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.OBJECT) {
            return;
        }
        for (String key : keysToValidate) {
            if (!currentPart.OBJECT_TO_VALIDATE.contains(key)) continue;
            String keyInSchema = key.contains(" ") || key.contains("\\") ? "[`" + key + "`]" : "." + key;
            try {
                this.subEnforce(currentPart, currentPart.OBJECT_TO_VALIDATE.getAnyAt(key), partStructure.schema.getJSONObjectAt(key), partStructure.canonicalPath + ".properties" + keyInSchema);
            }
            catch (KeyDifferentTypeException e) {
                throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName + keyInSchema, e);
            }
        }
    }

    private void validateRequired(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        ArrayList<String> requiredKeys = new ArrayList<String>();
        try {
            List<Json> keysAsJson = partStructure.schema.getArray();
            if (keysAsJson.size() == 0) {
                throw this.valueUnexpected(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Must provide at least one required property.");
            }
            for (Json key : keysAsJson) {
                requiredKeys.add(key.getString());
            }
        }
        catch (KeyDifferentTypeException e) {
            throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Required constraint must be a non-empty array of strings representing property names.", e);
        }
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.OBJECT) {
            throw this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Required constraint can only be applied to Object properties.");
        }
        for (String requiredKey : requiredKeys) {
            if (currentPart.OBJECT_TO_VALIDATE.contains(requiredKey)) continue;
            throw this.missingProperty(partStructure.canonicalPath, partStructure.propertyName, "Property (" + requiredKey + ") is mandatory, but couldn't be found.");
        }
    }

    private void validateMinProperties(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        long minProperties = this.getNonNegativeInteger(currentPart, partStructure.propertyName);
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.OBJECT) {
            throw this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "This constraint can only be used against an object.");
        }
        if ((long)currentPart.OBJECT_TO_VALIDATE.getKeys().size() < minProperties) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Object doesn't have enough properties to pass the constraint.");
        }
    }

    private void validateMaxProperties(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        long maxProperties = this.getNonNegativeInteger(currentPart, partStructure.propertyName);
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.OBJECT) {
            throw this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "This constraint can only be used against an object.");
        }
        if ((long)currentPart.OBJECT_TO_VALIDATE.getKeys().size() > maxProperties) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Object has more properties than the constraint allows.");
        }
    }

    private void validatePropertyNames(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        Json subSchema = this.getNextSchemaAsObject(partStructure);
        for (String key : currentPart.OBJECT_TO_VALIDATE.getKeys()) {
            this.subEnforce(currentPart, JsonParser.parse("\"" + key.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + "\""), subSchema, partStructure.canonicalPath + ".propertyNames");
        }
    }

    private void validatePatternProperties(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        Json propertiesObject = this.getNextSchemaAsObject(partStructure);
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.OBJECT) {
            return;
        }
        for (String regexKey : propertiesObject.getKeys()) {
            Pattern regexPattern = this.getRegexPattern(partStructure, regexKey);
            for (String objectKey : currentPart.OBJECT_TO_VALIDATE.getKeys()) {
                if (!regexPattern.matcher(objectKey).find()) continue;
                String keyInSchema = "[`" + regexKey + "`]";
                try {
                    this.subEnforce(currentPart, currentPart.OBJECT_TO_VALIDATE.getAnyAt(objectKey), partStructure.schema.getJSONObjectAt(keyInSchema), partStructure.canonicalPath + ".patternProperties" + keyInSchema);
                }
                catch (KeyDifferentTypeException e) {
                    throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName + keyInSchema, e);
                }
            }
        }
    }

    private void validateDependentRequired(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        Json dependentDefinitions = this.getNextSchemaAsObject(partStructure);
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.OBJECT) {
            return;
        }
        for (String key : dependentDefinitions.getKeys()) {
            List<Json> dependentDefinition;
            String keyInSchema = key.contains(" ") || key.contains("\\") ? "[`" + key + "`]" : "." + key;
            try {
                dependentDefinition = partStructure.schema.getArrayAt(key);
            }
            catch (KeyDifferentTypeException e) {
                throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName + keyInSchema, "Dependents can only be specified in an ARRAY.", e);
            }
            if (!currentPart.OBJECT_TO_VALIDATE.contains(key)) continue;
            try {
                for (int index = 0; index < dependentDefinition.size(); ++index) {
                    if (currentPart.OBJECT_TO_VALIDATE.contains(dependentDefinition.get(index).getString())) continue;
                    throw this.missingProperty(partStructure.canonicalPath, partStructure.propertyName + keyInSchema + "[" + index + "]", "Missing dependent property (" + dependentDefinition.get(index).getString() + ") required because property (" + key + ") present.");
                }
            }
            catch (KeyDifferentTypeException e) {
                throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName + keyInSchema, "Constraint must be the keys of dependent properties.", e);
            }
        }
    }

    private void validateAdditionalProperties(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        JSType schemaType = partStructure.schema.getDataType();
        if (schemaType != JSType.BOOLEAN && schemaType != JSType.OBJECT) {
            throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Expected one of " + Arrays.asList("BOOLEAN", "ARRAY") + ", got " + schemaType + ".");
        }
        Set<String> otherwiseCheckedKeys = this.getKeysRelevantToConstraint(currentPart, null, KeysRelevantTo.ADDITIONAL_PROPERTIES);
        if (schemaType == JSType.BOOLEAN) {
            if (!partStructure.schema.getBoolean()) {
                ArrayList<String> disallowedKeys = new ArrayList<String>();
                for (String key : currentPart.OBJECT_TO_VALIDATE.getKeys()) {
                    if (otherwiseCheckedKeys.contains(key)) continue;
                    disallowedKeys.add(key);
                }
                if (disallowedKeys.size() > 0) {
                    throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Additional Properties prohibited, but found " + disallowedKeys);
                }
            }
        } else {
            for (String key : currentPart.OBJECT_TO_VALIDATE.getKeys()) {
                if (otherwiseCheckedKeys.contains(key)) continue;
                try {
                    this.subEnforce(currentPart, currentPart.OBJECT_TO_VALIDATE.getAnyAt(key), partStructure.schema, partStructure.canonicalPath + ".additionalProperties");
                }
                catch (SchemaException e) {
                    throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Additional property (" + key + ") did not validate against schema.");
                }
            }
        }
    }

    private long validateContains(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        Json subSchema = this.getNextSchemaAsObject(partStructure);
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.ARRAY) {
            throw this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "This constraint can only be used against an array.");
        }
        long timesMatched = 0L;
        for (Json element : currentPart.OBJECT_TO_VALIDATE.getArray()) {
            try {
                this.subEnforce(currentPart, element, subSchema, partStructure.canonicalPath + ".contains");
                ++timesMatched;
            }
            catch (SchemaException schemaException) {}
        }
        if (timesMatched == 0L) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Found no match against the contains property in the value array.");
        }
        return timesMatched;
    }

    private void validateItems(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        JSType schemaType = partStructure.schema.getDataType();
        if (schemaType != JSType.OBJECT && schemaType != JSType.ARRAY) {
            throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Expected one of " + Arrays.asList("OBJECT", "ARRAY") + ", got " + schemaType + ".");
        }
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.ARRAY) {
            throw this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "This constraint can only be used against an array.");
        }
        if (schemaType == JSType.OBJECT) {
            for (Json element : currentPart.OBJECT_TO_VALIDATE.getArray()) {
                try {
                    this.subEnforce(currentPart, element, partStructure.schema.getJSONObject(), partStructure.canonicalPath + ".items");
                }
                catch (SchemaException e) {
                    throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "An element in the value array did not match against the constraint.");
                }
            }
        } else {
            for (String index : this.getKeysRelevantToConstraint(currentPart, partStructure, KeysRelevantTo.ITEMS)) {
                String key = "[" + index + "]";
                try {
                    partStructure.schema.getJSONObjectAt(key);
                }
                catch (KeyDifferentTypeException e) {
                    throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName + key, e);
                }
                try {
                    this.subEnforce(currentPart, currentPart.OBJECT_TO_VALIDATE.getAnyAt("[" + index + "]"), partStructure.schema.getJSONObjectAt(key), partStructure.canonicalPath + ".items" + key);
                }
                catch (SchemaException e) {
                    throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName + key, "Element in value array did not match against matching index in sub-schema.");
                }
            }
        }
    }

    private void validateUniqueItems(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        boolean shouldValidate = this.tryForSchema(partStructure, partStructure.schema::getBoolean);
        this.tryForObject(partStructure, currentPart.OBJECT_TO_VALIDATE::getArray);
        if (shouldValidate) {
            for (int outer = 0; outer < currentPart.OBJECT_TO_VALIDATE.getArray().size(); ++outer) {
                Json outerObject = currentPart.OBJECT_TO_VALIDATE.getAnyAt("[" + outer + "]");
                for (int inner = outer + 1; inner < currentPart.OBJECT_TO_VALIDATE.getArray().size(); ++inner) {
                    if (!outerObject.equals(currentPart.OBJECT_TO_VALIDATE.getAnyAt("[" + inner + "]"))) continue;
                    throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Index [" + outer + "] in value to verify was not unique.");
                }
            }
        }
    }

    private void validateMinItems(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        long minProperties = this.getNonNegativeInteger(currentPart, partStructure.propertyName);
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.ARRAY) {
            throw this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "This constraint can only be used against an array.");
        }
        if ((long)currentPart.OBJECT_TO_VALIDATE.getArray().size() < minProperties) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Array doesn't have enough elements to pass the constraint.");
        }
    }

    private void validateMaxItems(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        long maxProperties = this.getNonNegativeInteger(currentPart, partStructure.propertyName);
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.ARRAY) {
            throw this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "This constraint can only be used against an array.");
        }
        if ((long)currentPart.OBJECT_TO_VALIDATE.getArray().size() > maxProperties) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Array has more elements than the constraint allows.");
        }
    }

    private void validateAdditionalItems(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        if (currentPart.resolvableConstraints.containsKey("items") && currentPart.resolvableConstraints.get((Object)"items").schema.getDataType() != JSType.ARRAY) {
            return;
        }
        if (currentPart.OBJECT_TO_VALIDATE.getDataType() != JSType.ARRAY) {
            throw this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "This constraint can only be used against an array.");
        }
        Set<String> keysToCheck = currentPart.resolvableConstraints.containsKey("items") ? this.getKeysRelevantToConstraint(currentPart, currentPart.resolvableConstraints.get("items"), KeysRelevantTo.ADDITIONAL_ITEMS) : new HashSet<String>(currentPart.OBJECT_TO_VALIDATE.getKeys());
        for (String string : keysToCheck) {
            String string2 = "[" + string + "]";
            try {
                this.subEnforce(currentPart, currentPart.OBJECT_TO_VALIDATE.getAnyAt(string2), partStructure.schema, partStructure.canonicalPath + ".additionalItems");
            }
            catch (SchemaException e) {
                throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Element " + string2 + " in value array did not satisfy.");
            }
        }
    }

    private void validateMinContains(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        if (this.countContains(currentPart, partStructure) < this.tryForSchema(currentPart.resolvableConstraints.get("contains"), partStructure.schema::getLong)) {
            throw this.missingProperty(partStructure.canonicalPath, partStructure.propertyName, "Minimum quantity of matches against the contains constraint not satisfied.");
        }
    }

    private void validateMaxContains(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        if (this.countContains(currentPart, partStructure) > this.tryForSchema(currentPart.resolvableConstraints.get("contains"), partStructure.schema::getLong)) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Maximum quantity of matches against the contains constraint was exceeded.");
        }
    }

    private void validatePattern(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        Pattern verifiedPattern;
        try {
            verifiedPattern = Pattern.compile(partStructure.schema.getString());
        }
        catch (KeyDifferentTypeException e) {
            throw this.valueDifferentType(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, e);
        }
        catch (Exception e) {
            throw this.valueUnexpected(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Pattern provided was not a valid regex pattern.", e);
        }
        String objectToConstrain = this.tryForObject(partStructure, currentPart.OBJECT_TO_VALIDATE::getString);
        if (!verifiedPattern.matcher(objectToConstrain).find()) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Value did not match the provided pattern.");
        }
    }

    private void validateMinLength(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        long minLength = this.getNonNegativeInteger(currentPart, partStructure.propertyName);
        String objectToConstrain = this.tryForObject(partStructure, currentPart.OBJECT_TO_VALIDATE::getString);
        if ((long)objectToConstrain.length() < minLength) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "String length was shorter than the minimum bound.");
        }
    }

    private void validateMaxLength(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        long maxLength = this.getNonNegativeInteger(currentPart, partStructure.propertyName);
        String objectToConstrain = this.tryForObject(partStructure, currentPart.OBJECT_TO_VALIDATE::getString);
        if ((long)objectToConstrain.length() > maxLength) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "String length was longer than the maximum bound.");
        }
    }

    private void validateFormat(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        String formatToVerify = this.tryForSchema(partStructure, partStructure.schema::getString);
        String objectToConstrain = this.tryForObject(partStructure, currentPart.OBJECT_TO_VALIDATE::getString);
        boolean matched = false;
        try {
            switch (formatToVerify) {
                case "date": {
                    matched = objectToConstrain.matches("^(?:(?:(?:[1-9]\\d)(?:0[48]|[2468][048]|[13579][26])|(?:(?:[2468][048]|[13579][26])00))([/\\-.])(?:0?2\\1(?:29)))|(?:(?:[0-9]\\d{3})([/\\-.])(?:(?:(?:0?[13578]|1[02])\\2(?:31))|(?:(?:0?[13-9]|1[0-2])\\2(?:29|30))|(?:(?:0?[1-9])|(?:1[0-2]))\\2(?:0?[1-9]|1\\d|2[0-8])))$");
                    break;
                }
                case "time": {
                    matched = objectToConstrain.matches("^((([0]?[1-9]|1[0-2])[:.][0-5][0-9]([:.][0-5][0-9])?(\\.[0-9]{1,10}[zZ])?([ ])?[aApP][mM])|(([0]?[0-9]|1[0-9]|2[0-3])[:.][0-5][0-9]([:.][0-5][0-9])?(\\.[0-9]{1,10}[zZ])?))$");
                    break;
                }
                case "date-time": 
                case "datetime": {
                    matched = objectToConstrain.matches("^(?:[+-]?\\d{4}(?!\\d{2}\\b))(?:(-?)(?:(?:0[1-9]|1[0-2])(?:\\1(?:[12]\\d|0[1-9]|3[01]))?|W(?:[0-4]\\d|5[0-2])(?:-?[1-7])?|(?:00[1-9]|0[1-9]\\d|[12]\\d{2}|3(?:[0-5]\\d|6[1-6])))(?:[Tt\\s](?:(?:(?:[01]\\d|2[0-3])(?:(:?)[0-5]\\d)?|24:?00)(?:[.,]\\d+(?!:))?)?(?:\\2[0-5]\\d(?:[.,]\\d+)?)?(?:[zZ]|(?:[+-])(?:[01]\\d|2[0-3]):?(?:[0-5]\\d)?)?)?)?$");
                    break;
                }
                case "duration": {
                    matched = objectToConstrain.matches("^(-?)P(?=\\d|T\\d)(?:(\\d+)Y)?(?:(\\d+)M)?(?:(\\d+)([DW]))?(?:T(?:(\\d+)H)?(?:(\\d+)M)?(?:(\\d+(?:\\.\\d+)?)S)?(?<!T))?$");
                    break;
                }
                case "regex": {
                    Pattern.compile(objectToConstrain);
                    matched = true;
                    break;
                }
                case "email": {
                    matched = objectToConstrain.matches("^((([!#$%&'*+\\-/=?^_`{|}~\\w])|([!#$%&'*+\\-/=?^_`{|}~\\w]([!#$%&'*+\\-/=?^_`{|}~\\w]|((?<!\\.)\\.(?!\\.)))*[!#$%&'*+\\-/=?^_`{|}~\\w]))[@]\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*)$");
                    break;
                }
                case "phone": 
                case "phone-number": {
                    matched = objectToConstrain.matches("^(?:\\([+]?\\d{1,3}\\)|[+]?\\d{1,3})?(?:[ -]?(\\(\\d{1,5}\\)|\\d{1,5}))?(?:([ -]?\\d{1,15})|([ -]?\\d{1,4}){1,3})(?:[ ]ext\\.?[ ]?(?:(\\d{1,5})|([ .]\\d{1,2}){1,5}))?$");
                    break;
                }
                case "version": 
                case "sem-ver": 
                case "semVer": {
                    matched = objectToConstrain.matches("^(?:[vV](?:ersion)?(?:[: /-])?)?(?<major>[0-9]+)(?<minor>[.][0-9]+)?(?<patch>[.][0-9]+)?(?:-(?<prerelease>[0-9a-zA-Z-]+(?:\\.(?:[0-9a-zA-Z-]+))*)(?<![-.]))?(?:\\+(?<metadata>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*)(?<![-.]))?$");
                    break;
                }
                case "hostname": {
                    matched = objectToConstrain.matches("^(?![-.])+(?:[a-zA-Z\\d-%]{0,63})(((?<!\\.)\\.(?!\\.))(?:[a-zA-Z\\d-%]{0,63}))*(?<![-.])$");
                    break;
                }
                case "ipv4": 
                case "ip": {
                    matched = objectToConstrain.matches("^(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])){3}$");
                    break;
                }
                case "ipv6": {
                    matched = objectToConstrain.matches("^(?:(?:(?:[0-9A-Fa-f]{1,4}:){7}(?:[0-9A-Fa-f]{1,4}|:))|(?:(?:[0-9A-Fa-f]{1,4}:){6}(?::[0-9A-Fa-f]{1,4}|(?:(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])){3})|:))|(?:(?:[0-9A-Fa-f]{1,4}:){5}(?:(?:(?::[0-9A-Fa-f]{1,4}){1,2})|(?::(?:(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])){3}))|:))|(?:(?:[0-9A-Fa-f]{1,4}:){4}(?:(?:(?::[0-9A-Fa-f]{1,4}){1,3})|(?:(?::[0-9A-Fa-f]{1,4})?:(?:(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])){3}))|:))|(?:(?:[0-9A-Fa-f]{1,4}:){3}(?:(?:(?::[0-9A-Fa-f]{1,4}){1,4})|(?:(?::[0-9A-Fa-f]{1,4}){0,2}:(?:(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])){3}))|:))|(?:(?:[0-9A-Fa-f]{1,4}:){2}(?:(?:(?::[0-9A-Fa-f]{1,4}){1,5})|(?:(?::[0-9A-Fa-f]{1,4}){0,3}:(?:(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])){3}))|:))|(?:(?:[0-9A-Fa-f]{1,4}:)(?:(?:(?::[0-9A-Fa-f]{1,4}){1,6})|(?:(?::[0-9A-Fa-f]{1,4}){0,4}:(?:(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])){3}))|:))|(?::(?:(?:(?::[0-9A-Fa-f]{1,4}){1,7})|(?:(?::[0-9A-Fa-f]{1,4}){0,5}:(?:(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])){3}))|:)))(?:(%.+)|(/[0-9]{1,2}))?$");
                    break;
                }
                case "mac": {
                    matched = objectToConstrain.matches("^(?:[0-9A-Fa-f]{2}([:-]?)[0-9A-Fa-f]{2})(?:(?:\\1|\\.)(?:[0-9A-Fa-f]{2}([:-]?)[0-9A-Fa-f]{2})){2}$");
                    break;
                }
                case "uri": 
                case "url": {
                    matched = objectToConstrain.matches("^(?:(?:[a-zA-Z][a-zA-Z\\d]*):)(?://(?:(?:[a-zA-Z\\d-._~!$&'()*+,;=%]*)(?::(?:[a-zA-Z\\d-._~!$&'()*+,;=:%]*))?@)?(?:(?:[a-zA-Z\\d-.%]+)|(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|(?:\\[(?:[a-fA-F\\d.:]+)]))?(?::(?:\\d*))?(?:(?:/[a-zA-Z\\d-._~!$&'()*+,;=:@%]*)*)|([/]?(?:[a-zA-Z\\d-._~!$&'()*+,;=:@%]+(?:/[a-zA-Z\\d-._~!$&'()*+,;=:@%]*)*)))?(?:\\?(?:[a-zA-Z\\d-._~!$&'()*+,;=:@%/?]*))?(?:#(?:[a-zA-Z\\d-._~!$&'()*+,;=:@%/?]*))?$");
                    break;
                }
                case "uri-reference": 
                case "url-reference": {
                    matched = objectToConstrain.matches("^(?:(?:[a-zA-Z][a-zA-Z\\d]*):)?(?://(?:(?:[a-zA-Z\\d-._~!$&'()*+,;=%]*)(?::(?:[a-zA-Z\\d-._~!$&'()*+,;=:%]*))?@)?(?:(?:[a-zA-Z\\d-.%]+)|(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|(?:\\[(?:[a-fA-F\\d.:]+)]))?(?::(?:\\d*))?(?:(?:/[a-zA-Z\\d-._~!$&'()*+,;=:@%]*)*)|([/]?(?:[a-zA-Z\\d-._~!$&'()*+,;=:@%]+(?:/[a-zA-Z\\d-._~!$&'()*+,;=:@%]*)*)))?(?:\\?(?:[a-zA-Z\\d-._~!$&'()*+,;=:@%/?]*))?(?:#(?:[a-zA-Z\\d-._~!$&'()*+,;=:@%/?]*))?$");
                    break;
                }
                case "uuid": {
                    matched = objectToConstrain.matches("^([0-9A-Fa-f]{8}(?:-[0-9A-Fa-f]{4}){3}-[0-9A-Fa-f]{12})$");
                    break;
                }
                default: {
                    throw this.valueUnexpected(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Unrecognised/Unsupported format provided (" + formatToVerify + ").");
                }
            }
        }
        catch (InvalidSchemaException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!matched) {
            throw this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, partStructure.canonicalPath, partStructure.propertyName, "Value failed to match against the format (" + formatToVerify + ") constraint.");
        }
    }

    private int compareNumbers(JsonSchemaEnforcerPart currentPart, String propertyKey) {
        return this.getNumberAsBigDecimal(currentPart, propertyKey, false).compareTo(this.getNumberAsBigDecimal(currentPart, propertyKey, true));
    }

    private BigDecimal getNumberAsBigDecimal(JsonSchemaEnforcerPart currentPart, String propertyKey, boolean isForSchema) {
        RefResolvedSchemaPart resolvableConstraint = currentPart.resolvableConstraints.get(propertyKey);
        Json constraint = isForSchema ? resolvableConstraint.schema : currentPart.OBJECT_TO_VALIDATE;
        JSType constraintType = constraint.getDataType();
        if (constraintType != JSType.DOUBLE && constraintType != JSType.LONG) {
            throw isForSchema ? this.valueDifferentType(SourceOfProblem.SCHEMA, resolvableConstraint.canonicalPath, propertyKey, "Expected NUMBER, got " + constraintType + ".") : this.valueDifferentType(SourceOfProblem.OBJECT_TO_VALIDATE, resolvableConstraint.canonicalPath, propertyKey, "Value to verify must be a number.");
        }
        return constraintType == JSType.LONG ? BigDecimal.valueOf(constraint.getLong()) : BigDecimal.valueOf(constraint.getDouble());
    }

    private long getNonNegativeInteger(JsonSchemaEnforcerPart currentPart, String propertyKey) {
        RefResolvedSchemaPart resolvableConstraint = currentPart.resolvableConstraints.get(propertyKey);
        try {
            long value = resolvableConstraint.schema.getLong();
            if (value < 0L) {
                throw this.valueUnexpected(SourceOfProblem.SCHEMA, resolvableConstraint.canonicalPath, propertyKey, "Value must be >= 0.");
            }
            return value;
        }
        catch (KeyDifferentTypeException e) {
            throw this.valueDifferentType(SourceOfProblem.SCHEMA, resolvableConstraint.canonicalPath, propertyKey, "Constraint must provide a non-negative integer.", e);
        }
    }

    private String convert$RefToJsonKey(String canonicalPathing, String reference) {
        String resolvedRef = reference;
        if (resolvedRef.equals("")) {
            return resolvedRef;
        }
        if (resolvedRef.startsWith("#/")) {
            resolvedRef = this.convert$RefPathToJsonKeyEncoding(resolvedRef.substring(2));
        } else if (resolvedRef.startsWith("#") || resolvedRef.startsWith("/")) {
            resolvedRef = this.convert$RefPathToJsonKeyEncoding(resolvedRef.substring(1));
        } else {
            throw this.valueUnexpected(SourceOfProblem.SCHEMA, canonicalPathing, "$ref", "Relative sub-schema keys are not supported in this implementation.");
        }
        return resolvedRef;
    }

    private String convert$RefPathToJsonKeyEncoding(String refPath) {
        String[] steps;
        StringBuilder resolvedPath = new StringBuilder();
        for (String step : steps = refPath.split("/")) {
            step = step.replaceAll("~0", "~").replaceAll("~1", "/");
            try {
                int arrayRef = Integer.parseInt(step);
                resolvedPath.append("[").append(arrayRef).append("]");
            }
            catch (NumberFormatException e) {
                if (step.contains(" ") || step.contains("\\")) {
                    resolvedPath.append("[`").append(step).append("`]");
                    continue;
                }
                resolvedPath.append(".").append(step);
            }
        }
        if (resolvedPath.length() > 0 && resolvedPath.charAt(0) == '.') {
            resolvedPath.deleteCharAt(0);
        }
        return resolvedPath.toString();
    }

    private void subEnforce(JsonSchemaEnforcerPart currentPart, Json updatedObjectToValidate, Json updatedSubSchema, String updatedPathInSchema) throws SchemaException {
        new JsonSchemaEnforcerPart(updatedObjectToValidate, currentPart.SCHEMA_REFERENCE, updatedSubSchema, updatedPathInSchema, currentPart.SCHEMA_REFERENCES_SEEN).enforce();
    }

    private void subEnforce(JsonSchemaEnforcerPart currentPart, Json updatedSubSchema, String updatedPathInSchema) throws SchemaException {
        this.subEnforce(currentPart, currentPart.OBJECT_TO_VALIDATE, updatedSubSchema, updatedPathInSchema);
    }

    private Json getNextSchemaAsObject(RefResolvedSchemaPart partStructure) {
        return this.tryForSchema(partStructure, partStructure.schema::getJSONObject);
    }

    private void validateArrayBasedConditional(RefResolvedSchemaPart partStructure, Lambda<Void> worker) {
        this.tryForSchema(partStructure, () -> {
            if (partStructure.schema.getArray().size() == 0) {
                throw this.valueUnexpected(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Array must contain at least 1 sub-schema.");
            }
            worker.doWork();
            return null;
        });
    }

    private <E> E tryForSchema(RefResolvedSchemaPart partStructure, Lambda<E> worker) {
        return this.unwrapIJsonType(partStructure, worker, SourceOfProblem.SCHEMA);
    }

    private <E> E tryForObject(RefResolvedSchemaPart partStructure, Lambda<E> worker) {
        return this.unwrapIJsonType(partStructure, worker, SourceOfProblem.OBJECT_TO_VALIDATE);
    }

    private <E> E unwrapIJsonType(RefResolvedSchemaPart partStructure, Lambda<E> worker, SourceOfProblem sourceOfProblem) {
        E returnValue;
        try {
            returnValue = worker.doWork();
        }
        catch (KeyDifferentTypeException e) {
            throw this.valueDifferentType(sourceOfProblem, partStructure.canonicalPath, partStructure.propertyName, e);
        }
        return returnValue;
    }

    private Set<String> getKeysRelevantToConstraint(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure, KeysRelevantTo constraint) {
        HashSet<String> keysForConstraint = new HashSet<String>();
        switch (constraint) {
            case PROPERTIES: {
                keysForConstraint.addAll(this.getNextSchemaAsObject(partStructure).getKeys());
                break;
            }
            case PATTERN_PROPERTIES: {
                for (String regexKey : this.getNextSchemaAsObject(partStructure).getKeys()) {
                    Pattern regexPattern = this.getRegexPattern(partStructure, regexKey);
                    for (String objectKey : currentPart.OBJECT_TO_VALIDATE.getKeys()) {
                        if (!regexPattern.matcher(objectKey).find()) continue;
                        keysForConstraint.add(objectKey);
                    }
                }
                break;
            }
            case ADDITIONAL_PROPERTIES: {
                if (currentPart.resolvableConstraints.containsKey("properties")) {
                    keysForConstraint.addAll(this.getKeysRelevantToConstraint(currentPart, currentPart.resolvableConstraints.get("properties"), KeysRelevantTo.PROPERTIES));
                }
                if (!currentPart.resolvableConstraints.containsKey("patternProperties")) break;
                keysForConstraint.addAll(this.getKeysRelevantToConstraint(currentPart, currentPart.resolvableConstraints.get("patternProperties"), KeysRelevantTo.PATTERN_PROPERTIES));
                break;
            }
            case ITEMS: {
                keysForConstraint.addAll(currentPart.OBJECT_TO_VALIDATE.getArray().size() < partStructure.schema.getArray().size() ? currentPart.OBJECT_TO_VALIDATE.getKeys() : partStructure.schema.getKeys());
                break;
            }
            case ADDITIONAL_ITEMS: {
                boolean objectIsBigger;
                boolean bl = objectIsBigger = currentPart.OBJECT_TO_VALIDATE.getArray().size() > partStructure.schema.getArray().size();
                if (!objectIsBigger) break;
                keysForConstraint.addAll(currentPart.OBJECT_TO_VALIDATE.getKeys());
                keysForConstraint.removeAll(partStructure.schema.getKeys());
            }
        }
        return keysForConstraint;
    }

    private long countContains(JsonSchemaEnforcerPart currentPart, RefResolvedSchemaPart partStructure) {
        if (!currentPart.resolvableConstraints.containsKey("contains")) {
            throw this.missingProperty(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, partStructure.propertyName + " requires the (contains) constraint to run.", null);
        }
        return this.validateContains(currentPart, currentPart.resolvableConstraints.get("contains"));
    }

    private Pattern getRegexPattern(RefResolvedSchemaPart partStructure, String regexKey) {
        try {
            return Pattern.compile(regexKey);
        }
        catch (Exception e) {
            throw this.valueUnexpected(SourceOfProblem.SCHEMA, partStructure.canonicalPath, partStructure.propertyName, "Key in patternProperties (" + regexKey + ") was not a valid regex.", e);
        }
    }

    private SchemaException missingProperty(String parentOfMissingProperty, String propertyName, String reason) {
        return this.missingProperty(SourceOfProblem.OBJECT_TO_VALIDATE, parentOfMissingProperty, propertyName, reason, null);
    }

    private SchemaException missingProperty(SourceOfProblem source, String parentOfMissingProperty, String propertyName, String reason, Throwable cause) {
        Object message = "Invalid.";
        switch (source) {
            case SCHEMA: {
                message = "Missing property in schema at: " + this.schemaErrorKeyChain(propertyName, parentOfMissingProperty);
                break;
            }
            case OBJECT_TO_VALIDATE: {
                message = "Missing property.\nSchema constraint violated: " + this.schemaErrorKeyChain(propertyName, parentOfMissingProperty);
            }
        }
        return this.enhanceErrorMessageReasoning(source, (String)message, reason, cause);
    }

    private SchemaException valueDifferentType(SourceOfProblem source, String parentOfMissingProperty, String propertyName, String reason) {
        return this.valueDifferentType(source, parentOfMissingProperty, propertyName, reason, null);
    }

    private SchemaException valueDifferentType(SourceOfProblem source, String parentOfMissingProperty, String propertyName, KeyDifferentTypeException cause) {
        return this.valueDifferentType(source, parentOfMissingProperty, propertyName, "", cause);
    }

    private SchemaException valueDifferentType(SourceOfProblem source, String parentOfMissingProperty, String propertyName, String reason, KeyDifferentTypeException cause) {
        Object message = "Invalid.";
        switch (source) {
            case SCHEMA: {
                message = "Wrong type for schema property: " + this.schemaErrorKeyChain(propertyName, parentOfMissingProperty);
                break;
            }
            case OBJECT_TO_VALIDATE: {
                message = "Mismatched data type.\nSchema constraint violated: " + this.schemaErrorKeyChain(propertyName, parentOfMissingProperty);
            }
        }
        return this.enhanceErrorMessageReasoning(source, (String)message, reason, cause);
    }

    private SchemaException valueUnexpected(SourceOfProblem source, String parentOfMissingProperty, String propertyName, String reason) {
        return this.valueUnexpected(source, parentOfMissingProperty, propertyName, reason, null);
    }

    private SchemaException valueUnexpected(SourceOfProblem source, String parentOfMissingProperty, String propertyName, String reason, Throwable cause) {
        Object message = "Invalid.";
        switch (source) {
            case SCHEMA: {
                message = "Unexpected value for schema property: " + this.schemaErrorKeyChain(propertyName, parentOfMissingProperty);
                break;
            }
            case OBJECT_TO_VALIDATE: {
                message = "Unexpected value.\nSchema constraint violated: " + this.schemaErrorKeyChain(propertyName, parentOfMissingProperty);
            }
        }
        return this.enhanceErrorMessageReasoning(source, (String)message, reason, cause);
    }

    private SchemaException enhanceErrorMessageReasoning(SourceOfProblem source, String message, String reason, Throwable cause) {
        message = (String)message + (String)(reason.equals("") ? "" : "\n" + reason);
        message = (String)message + this.getErrorCauseMessage(cause);
        return cause == null ? this.doThrow(source, (String)message) : this.doThrow(source, (String)message, cause);
    }

    private SchemaException doThrow(SourceOfProblem source, String message) {
        if (source == SourceOfProblem.SCHEMA) {
            return new InvalidSchemaException(message);
        }
        return new SchemaViolationException(message);
    }

    private SchemaException doThrow(SourceOfProblem source, String message, Throwable cause) {
        if (source == SourceOfProblem.SCHEMA) {
            return new InvalidSchemaException(message, cause);
        }
        return new SchemaViolationException(message, cause);
    }

    private String getErrorCauseMessage(Throwable cause) {
        if (cause != null) {
            String[] causeMessage;
            if (cause instanceof KeyDifferentTypeException && (causeMessage = cause.getMessage().split("\\. ")).length >= 2) {
                return "\n" + causeMessage[1];
            }
            return "\n(" + cause.getMessage().split("\\r?\\n")[0] + ")";
        }
        return "";
    }

    private String schemaErrorKeyChain(String propertyName, String path) {
        return (path.equals("") ? "<base element>" : path) + "." + propertyName;
    }

    private final class JsonSchemaEnforcerPart {
        private final Json SCHEMA_REFERENCE;
        private final Json OBJECT_TO_VALIDATE;
        private final Set<String> SCHEMA_REFERENCES_SEEN;
        private final HashMap<String, RefResolvedSchemaPart> resolvableConstraints = new HashMap();

        private JsonSchemaEnforcerPart(Json objectToValidate, Json fullSchema, Json currentSchemaFragment, String schemaKeySoFar, Set<String> schemaReferencesSeen) {
            this.OBJECT_TO_VALIDATE = objectToValidate;
            this.SCHEMA_REFERENCE = fullSchema;
            this.SCHEMA_REFERENCES_SEEN = schemaReferencesSeen;
            this.pullUp$RefsToTopLevel(new RefResolvedSchemaPart(schemaKeySoFar, currentSchemaFragment));
        }

        private void pullUp$RefsToTopLevel(RefResolvedSchemaPart pathing) {
            List<String> subSchemaKeys = pathing.schema.getKeys();
            if (subSchemaKeys.remove("$ref")) {
                try {
                    String referencedSubSchema = JsonSchemaEnforcer.this.convert$RefToJsonKey(pathing.canonicalPath, pathing.schema.getStringAt("$ref"));
                    if (this.SCHEMA_REFERENCES_SEEN.contains(referencedSubSchema)) {
                        throw JsonSchemaEnforcer.this.valueUnexpected(SourceOfProblem.SCHEMA, pathing.canonicalPath, "$ref", "Schema Reference has a cyclic dependency.");
                    }
                    this.SCHEMA_REFERENCES_SEEN.add(referencedSubSchema);
                    this.pullUp$RefsToTopLevel(new RefResolvedSchemaPart(pathing.canonicalPath + ".$ref", this.SCHEMA_REFERENCE.getJSONObjectAt(referencedSubSchema)));
                }
                catch (KeyNotFoundException e) {
                    throw JsonSchemaEnforcer.this.missingProperty(SourceOfProblem.SCHEMA, pathing.canonicalPath, "$ref", "", e);
                }
                catch (KeyDifferentTypeException e) {
                    throw JsonSchemaEnforcer.this.valueDifferentType(SourceOfProblem.SCHEMA, pathing.canonicalPath, "$ref", "$ref must link to a valid sub-schema object.", e);
                }
            }
            for (String realKey : subSchemaKeys) {
                String canonicalKey = realKey.contains(" ") || realKey.contains("\\") ? "[`" + realKey + "`]" : realKey;
                this.resolvableConstraints.put(realKey, new RefResolvedSchemaPart(pathing.canonicalPath, canonicalKey, pathing.schema.getAnyAt(realKey)));
            }
        }

        private boolean enforce() throws SchemaException {
            for (Map.Entry<String, RefResolvedSchemaPart> constraint : this.resolvableConstraints.entrySet()) {
                switch (constraint.getKey()) {
                    case "type": {
                        JsonSchemaEnforcer.this.validateType(this, constraint.getValue());
                        break;
                    }
                    case "enum": {
                        JsonSchemaEnforcer.this.validateEnum(this, constraint.getValue());
                        break;
                    }
                    case "const": {
                        if (this.OBJECT_TO_VALIDATE.equals(this.resolvableConstraints.get((Object)"const").schema)) break;
                        throw JsonSchemaEnforcer.this.valueUnexpected(SourceOfProblem.OBJECT_TO_VALIDATE, this.resolvableConstraints.get((Object)"const").canonicalPath, "const", "Value MUST match the schema's constant.");
                    }
                    case "allOf": {
                        JsonSchemaEnforcer.this.validateAllOf(this, constraint.getValue());
                        break;
                    }
                    case "anyOf": {
                        JsonSchemaEnforcer.this.validateAnyOf(this, constraint.getValue());
                        break;
                    }
                    case "oneOf": {
                        JsonSchemaEnforcer.this.validateOneOf(this, constraint.getValue());
                        break;
                    }
                    case "not": {
                        JsonSchemaEnforcer.this.validateNot(this, constraint.getValue());
                        break;
                    }
                    case "if": {
                        JsonSchemaEnforcer.this.validateIf(this);
                        break;
                    }
                    case "multipleOf": {
                        JsonSchemaEnforcer.this.validateMultipleOf(this, constraint.getValue());
                        break;
                    }
                    case "maximum": {
                        JsonSchemaEnforcer.this.validateMaximum(this, constraint.getValue());
                        break;
                    }
                    case "exclusiveMaximum": {
                        JsonSchemaEnforcer.this.validateExclusiveMaximum(this, constraint.getValue());
                        break;
                    }
                    case "minimum": {
                        JsonSchemaEnforcer.this.validateMinimum(this, constraint.getValue());
                        break;
                    }
                    case "exclusiveMinimum": {
                        JsonSchemaEnforcer.this.validateExclusiveMinimum(this, constraint.getValue());
                        break;
                    }
                    case "maxLength": {
                        JsonSchemaEnforcer.this.validateMaxLength(this, constraint.getValue());
                        break;
                    }
                    case "minLength": {
                        JsonSchemaEnforcer.this.validateMinLength(this, constraint.getValue());
                        break;
                    }
                    case "pattern": {
                        JsonSchemaEnforcer.this.validatePattern(this, constraint.getValue());
                        break;
                    }
                    case "format": {
                        JsonSchemaEnforcer.this.validateFormat(this, constraint.getValue());
                        break;
                    }
                    case "maxItems": {
                        JsonSchemaEnforcer.this.validateMaxItems(this, constraint.getValue());
                        break;
                    }
                    case "minItems": {
                        JsonSchemaEnforcer.this.validateMinItems(this, constraint.getValue());
                        break;
                    }
                    case "uniqueItems": {
                        JsonSchemaEnforcer.this.validateUniqueItems(this, constraint.getValue());
                        break;
                    }
                    case "maxContains": {
                        JsonSchemaEnforcer.this.validateMaxContains(this, constraint.getValue());
                        break;
                    }
                    case "minContains": {
                        JsonSchemaEnforcer.this.validateMinContains(this, constraint.getValue());
                        break;
                    }
                    case "items": {
                        JsonSchemaEnforcer.this.validateItems(this, constraint.getValue());
                        break;
                    }
                    case "additionalItems": {
                        JsonSchemaEnforcer.this.validateAdditionalItems(this, constraint.getValue());
                        break;
                    }
                    case "contains": {
                        JsonSchemaEnforcer.this.validateContains(this, constraint.getValue());
                        break;
                    }
                    case "unevaluatedItems": {
                        throw JsonSchemaEnforcer.this.doThrow(SourceOfProblem.SCHEMA, "unevaluatedItems constraint is not supported by this schema enforcer.\nConsider re-designing your schema to avoid it.");
                    }
                    case "maxProperties": {
                        JsonSchemaEnforcer.this.validateMaxProperties(this, constraint.getValue());
                        break;
                    }
                    case "minProperties": {
                        JsonSchemaEnforcer.this.validateMinProperties(this, constraint.getValue());
                        break;
                    }
                    case "required": {
                        JsonSchemaEnforcer.this.validateRequired(this, constraint.getValue());
                        break;
                    }
                    case "dependentRequired": {
                        JsonSchemaEnforcer.this.validateDependentRequired(this, constraint.getValue());
                        break;
                    }
                    case "properties": {
                        JsonSchemaEnforcer.this.validateProperties(this, constraint.getValue());
                        break;
                    }
                    case "patternProperties": {
                        JsonSchemaEnforcer.this.validatePatternProperties(this, constraint.getValue());
                        break;
                    }
                    case "additionalProperties": {
                        JsonSchemaEnforcer.this.validateAdditionalProperties(this, constraint.getValue());
                        break;
                    }
                    case "propertyNames": {
                        JsonSchemaEnforcer.this.validatePropertyNames(this, constraint.getValue());
                        break;
                    }
                    case "unevaluatedProperties": {
                        throw JsonSchemaEnforcer.this.doThrow(SourceOfProblem.SCHEMA, "unevaluatedProperties constraint is not supported by this schema enforcer.\nConsider re-designing your schema to avoid it.");
                    }
                }
            }
            return true;
        }
    }

    private static final class RefResolvedSchemaPart {
        private final String canonicalPath;
        private final String propertyName;
        private final Json schema;

        private RefResolvedSchemaPart(String canonicalPath, String propertyName, Json schema) {
            this.canonicalPath = canonicalPath.startsWith(".") ? canonicalPath.substring(1) : canonicalPath;
            this.propertyName = propertyName;
            this.schema = schema;
        }

        private RefResolvedSchemaPart(String canonicalPath, Json schema) {
            this(canonicalPath, null, schema);
        }
    }

    private static interface Lambda<E> {
        public E doWork();
    }

    private static enum SourceOfProblem {
        SCHEMA,
        OBJECT_TO_VALIDATE;

    }

    private static enum KeysRelevantTo {
        PROPERTIES,
        PATTERN_PROPERTIES,
        ADDITIONAL_PROPERTIES,
        ITEMS,
        ADDITIONAL_ITEMS;

    }
}

