/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.api.Json;
import com.clumd.projects.javajson.api.JsonBuilder;
import com.clumd.projects.javajson.api.JsonGenerator;
import com.clumd.projects.javajson.api.JsonParser;
import com.clumd.projects.javajson.core.JSType;
import com.clumd.projects.javajson.core.JsonKey;
import com.clumd.projects.javajson.exceptions.BuildException;
import com.clumd.projects.javajson.exceptions.json.KeyDifferentTypeException;
import com.clumd.projects.javajson.exceptions.json.KeyInvalidException;
import com.clumd.projects.javajson.exceptions.json.KeyNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class BasicJsonBuilder
implements JsonBuilder,
JsonGenerator {
    private final HashMap<String, Boolean> booleans = new HashMap();
    private final HashMap<String, String> strings = new HashMap();
    private final HashMap<String, Double> doubles = new HashMap();
    private final HashMap<String, Long> longs = new HashMap();
    private final HashMap<String, BasicJsonBuilder> objects = new HashMap();
    private final ArrayList<Object> array = new ArrayList();
    private JSType type = JSType.OBJECT;

    public BasicJsonBuilder() {
    }

    private BasicJsonBuilder(JSType objectType) {
        this.type = objectType;
    }

    public static BasicJsonBuilder getBuilder() {
        return new BasicJsonBuilder();
    }

    @Override
    public BasicJsonBuilder builder() {
        return new BasicJsonBuilder();
    }

    @Override
    public Json build() throws BuildException {
        return this.convertToJSON();
    }

    @Override
    public Json convertToJSON() throws BuildException {
        return JsonParser.parse(this.toString());
    }

    @Override
    public JsonBuilder addBoolean(String path, boolean value) throws BuildException {
        NewValueIdentifier valueIdentifier = new NewValueIdentifier(path, value);
        BasicJsonBuilder finalObjectInKeyChain = this.findObject(valueIdentifier);
        if (finalObjectInKeyChain != null) {
            finalObjectInKeyChain.booleans.put(valueIdentifier.finalKey.substring(1), value);
        }
        return this;
    }

    @Override
    public JsonBuilder addLong(String path, long value) throws BuildException {
        NewValueIdentifier valueIdentifier = new NewValueIdentifier(path, value);
        BasicJsonBuilder finalObjectInKeyChain = this.findObject(valueIdentifier);
        if (finalObjectInKeyChain != null) {
            finalObjectInKeyChain.longs.put(valueIdentifier.finalKey.substring(1), value);
        }
        return this;
    }

    @Override
    public JsonBuilder addDouble(String path, double value) throws BuildException {
        NewValueIdentifier valueIdentifier = new NewValueIdentifier(path, value);
        BasicJsonBuilder finalObjectInKeyChain = this.findObject(valueIdentifier);
        if (finalObjectInKeyChain != null) {
            finalObjectInKeyChain.doubles.put(valueIdentifier.finalKey.substring(1), value);
        }
        return this;
    }

    @Override
    public JsonBuilder addString(String path, String value) throws BuildException {
        NewValueIdentifier valueIdentifier = new NewValueIdentifier(path, value);
        BasicJsonBuilder finalObjectInKeyChain = this.findObject(valueIdentifier);
        if (finalObjectInKeyChain != null) {
            finalObjectInKeyChain.strings.put(valueIdentifier.finalKey.substring(1), value);
        }
        return this;
    }

    @Override
    public JsonBuilder addBuilderBlock(String path, JsonBuilder value) throws BuildException {
        if (!(value instanceof BasicJsonBuilder)) {
            throw new BuildException("This implementation of an IJSONBuilder only accepts JSONBuilder as a builder block value.");
        }
        NewValueIdentifier valueIdentifier = new NewValueIdentifier(path, value);
        BasicJsonBuilder finalObjectInKeyChain = this.findObject(valueIdentifier);
        if (finalObjectInKeyChain != null) {
            finalObjectInKeyChain.objects.put(valueIdentifier.finalKey.substring(1), (BasicJsonBuilder)value);
        }
        return this;
    }

    @Override
    public JsonBuilder addBuilderBlock(String path, Json value) throws BuildException {
        return this.addBuilderBlock(path, this.convertFromJSON(value));
    }

    private String identifyFinalKey(JsonKey keyChain) {
        List<String> chainAsListOfKeys = keyChain.getAllKeys();
        if (chainAsListOfKeys.size() == 1) {
            KeyInvalidException invalidException = new KeyInvalidException("The minimum wrapper for this IJsonBuilder is a JSON object, you must provide at least one valid key for your value.");
            throw new BuildException(invalidException.getMessage(), invalidException);
        }
        String lastActionableKey = chainAsListOfKeys.get(chainAsListOfKeys.size() - 2);
        return lastActionableKey.charAt(0) == '[' ? "" : lastActionableKey;
    }

    private BasicJsonBuilder findObject(NewValueIdentifier valueIdentifier) {
        BasicJsonBuilder objectStepInKey = this;
        List<String> allKeys = valueIdentifier.keyChain.getAllKeys();
        try {
            for (int index = 0; index < allKeys.size() && !allKeys.get(index).equals(valueIdentifier.finalKey); ++index) {
                valueIdentifier.keyChain.getNextKey();
                objectStepInKey = this.getOrCreateIfNotExists(objectStepInKey, allKeys.get(index), allKeys.get(index + 1));
            }
        }
        catch (KeyNotFoundException notFoundException) {
            throw new BuildException(valueIdentifier.keyChain.createKeyNotFoundException().getMessage().replaceAll("\\[append]", "[]"), notFoundException);
        }
        catch (KeyDifferentTypeException differentTypeException) {
            valueIdentifier.keyChain.getNextKey();
            throw new BuildException(valueIdentifier.keyChain.createKeyDifferentTypeException().getMessage(), differentTypeException);
        }
        if (objectStepInKey.type == JSType.ARRAY) {
            objectStepInKey.array.add(valueIdentifier.value);
            return null;
        }
        if (valueIdentifier.finalKey.equals("")) {
            valueIdentifier.keyChain.getNextKey();
            throw new BuildException(valueIdentifier.keyChain.createKeyDifferentTypeException().getMessage());
        }
        return objectStepInKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BasicJsonBuilder getOrCreateIfNotExists(BasicJsonBuilder currentObject, String currentKey, String nextKey) {
        boolean keyIsForArray = currentKey.charAt(0) == '[';
        currentKey = currentKey.substring(1);
        if (keyIsForArray) {
            if (currentKey.equals("append") || Integer.parseInt(currentKey) == currentObject.array.size()) {
                if (nextKey.equals("")) return currentObject;
                BasicJsonBuilder nextBuilder = new BasicJsonBuilder(this.determineNewChildType(nextKey));
                currentObject.array.add(nextBuilder);
                return nextBuilder;
            }
            int index = Integer.parseInt(currentKey);
            if (index >= currentObject.array.size()) {
                throw new KeyNotFoundException("");
            }
            Object arrayElement = currentObject.array.get(index);
            if (!(arrayElement instanceof BasicJsonBuilder)) throw new KeyDifferentTypeException("");
            return (BasicJsonBuilder)arrayElement;
        }
        if (currentObject.objects.containsKey(currentKey)) {
            return currentObject.objects.get(currentKey);
        }
        BasicJsonBuilder nextBuilder = new BasicJsonBuilder(this.determineNewChildType(nextKey));
        currentObject.objects.put(currentKey, nextBuilder);
        return nextBuilder;
    }

    private JSType determineNewChildType(String nextKey) {
        return nextKey.charAt(0) == '[' ? JSType.ARRAY : JSType.OBJECT;
    }

    @Override
    public JsonBuilder convertFromJSON(Json json) {
        switch (json.getDataType()) {
            case BOOLEAN: {
                return new BasicJsonBuilder().addBoolean("value", json.getBoolean());
            }
            case DOUBLE: {
                return new BasicJsonBuilder().addDouble("value", json.getDouble());
            }
            case LONG: {
                return new BasicJsonBuilder().addLong("value", json.getLong());
            }
            case STRING: {
                return new BasicJsonBuilder().addString("value", json.getString());
            }
            case ARRAY: {
                return BasicJsonBuilder.getBuilder().addBuilderBlock("value", (BasicJsonBuilder)this.convertNonPrimitive(json));
            }
        }
        BasicJsonBuilder returnObject = new BasicJsonBuilder(JSType.OBJECT);
        for (String key : json.getKeys()) {
            Object child = this.convertNonPrimitive(json.getAnyAt(key));
            if (child instanceof Boolean) {
                returnObject.addBoolean(key, (Boolean)child);
                continue;
            }
            if (child instanceof Double) {
                returnObject.addDouble(key, (Double)child);
                continue;
            }
            if (child instanceof Long) {
                returnObject.addLong(key, (Long)child);
                continue;
            }
            if (child instanceof String) {
                returnObject.addString(key, (String)child);
                continue;
            }
            if (!(child instanceof BasicJsonBuilder)) continue;
            returnObject.objects.put(key, (BasicJsonBuilder)child);
        }
        return returnObject;
    }

    private Object convertNonPrimitive(Json json) {
        switch (json.getDataType()) {
            case BOOLEAN: {
                return json.getBoolean();
            }
            case DOUBLE: {
                return json.getDouble();
            }
            case LONG: {
                return json.getLong();
            }
            case STRING: {
                return json.getString();
            }
            case ARRAY: {
                BasicJsonBuilder values = new BasicJsonBuilder(JSType.ARRAY);
                for (Json element : json.getValues()) {
                    values.array.add(this.convertNonPrimitive(element));
                }
                return values;
            }
        }
        return this.convertFromJSON(json);
    }

    public String toString() {
        StringBuilder o = new StringBuilder();
        if (this.type == JSType.ARRAY) {
            o.append("[");
            for (Object value : this.array) {
                if (value instanceof String) {
                    o.append('\"').append(this.escapeString((String)value)).append('\"');
                } else {
                    o.append(value.toString());
                }
                o.append(',');
            }
            if (o.charAt(o.length() - 1) == ',') {
                o.deleteCharAt(o.length() - 1);
            }
            o.append("]");
        } else {
            o.append("{");
            for (String key : this.booleans.keySet()) {
                o.append('\"').append(this.escapeString(key)).append("\":").append(this.booleans.get(key)).append(',');
            }
            for (String key : this.doubles.keySet()) {
                o.append('\"').append(this.escapeString(key)).append("\":").append(this.doubles.get(key)).append(',');
            }
            for (String key : this.longs.keySet()) {
                o.append('\"').append(this.escapeString(key)).append("\":").append(this.longs.get(key)).append(',');
            }
            for (String key : this.strings.keySet()) {
                o.append('\"').append(this.escapeString(key)).append("\":\"").append(this.escapeString(this.strings.get(key))).append("\",");
            }
            for (String key : this.objects.keySet()) {
                o.append('\"').append(this.escapeString(key)).append("\":");
                o.append(this.objects.get(key).toString());
                o.append(',');
            }
            if (o.charAt(o.length() - 1) == ',') {
                o.deleteCharAt(o.length() - 1);
            }
            o.append('}');
        }
        return o.toString();
    }

    private String escapeString(String stringToEscape) {
        return stringToEscape.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
    }

    private class NewValueIdentifier {
        final JsonKey keyChain;
        final String finalKey;
        final Object value;

        NewValueIdentifier(String path, Object value) {
            try {
                this.keyChain = new JsonKey(path, true);
            }
            catch (KeyInvalidException exception) {
                throw new BuildException("Cannot add new value with invalid key.", exception);
            }
            this.finalKey = BasicJsonBuilder.this.identifyFinalKey(this.keyChain);
            this.value = value;
        }
    }
}

