/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.JSType;
import com.clumd.projects.javajson.core.Json;
import com.clumd.projects.javajson.core.JsonKey;
import com.clumd.projects.javajson.core.JsonTape;
import com.clumd.projects.javajson.exceptions.json.JsonParseException;
import com.clumd.projects.javajson.exceptions.json.KeyNotFoundException;
import java.util.ArrayList;
import java.util.List;

final class JSArray
extends Json {
    private final List<com.clumd.projects.javajson.api.Json> myValue;

    JSArray(JsonTape parsingTape) throws JsonParseException {
        super(parsingTape);
        this.jsType = JSType.ARRAY;
        parsingTape.consumeOne();
        parsingTape.consumeWhiteSpace();
        char checkingChar = parsingTape.checkCurrentChar();
        if (checkingChar == ',') {
            throw (JsonParseException)parsingTape.createParseError("{ / [ / \" / <number> / <boolean> ", "Missing Valid JSON at start of array.");
        }
        this.myValue = new ArrayList<com.clumd.projects.javajson.api.Json>();
        if (checkingChar == ']') {
            parsingTape.consumeOne();
            return;
        }
        boolean moreChildren = true;
        block4: while (moreChildren) {
            this.myValue.add(parsingTape.parseNextElement());
            parsingTape.consumeWhiteSpace();
            checkingChar = parsingTape.consumeOne();
            switch (checkingChar) {
                case ']': {
                    moreChildren = false;
                    continue block4;
                }
                case ',': {
                    parsingTape.consumeWhiteSpace();
                    if (parsingTape.checkCurrentChar() != ']') continue block4;
                    throw (JsonParseException)parsingTape.createParseError("{ / [ / \" / <number> / <boolean> ", "Comma suggests more array elements, but array terminates.");
                }
            }
            throw (JsonParseException)parsingTape.createParseErrorFromOffset(-1, ", / ]", "Invalid array child delimiter.");
        }
    }

    @Override
    public List<com.clumd.projects.javajson.api.Json> getValue() {
        return this.myValue;
    }

    @Override
    public boolean contains(String keys) {
        try {
            this.getAnyAt(keys);
            return true;
        }
        catch (KeyNotFoundException e) {
            return false;
        }
    }

    @Override
    protected com.clumd.projects.javajson.api.Json getInternal(JsonKey keySequence) throws KeyNotFoundException {
        Json childElement;
        String nextKey = keySequence.getNextKey();
        if (nextKey.equals("")) {
            return this;
        }
        if (!nextKey.startsWith("[")) {
            throw keySequence.createKeyDifferentTypeException();
        }
        try {
            childElement = (Json)this.myValue.get(Integer.parseInt(nextKey.substring(1)));
        }
        catch (IndexOutOfBoundsException e) {
            throw keySequence.createKeyNotFoundException();
        }
        return childElement.getInternal(keySequence);
    }

    @Override
    public List<String> getKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < this.myValue.size(); ++i) {
            ret.add(String.valueOf(i));
        }
        return ret;
    }

    @Override
    public List<com.clumd.projects.javajson.api.Json> getValues() {
        return this.getValue();
    }

    @Override
    public String asString(int depth) {
        if (this.myValue.isEmpty()) {
            return "[]";
        }
        StringBuilder ret = new StringBuilder("[");
        if (depth == 0) {
            return ret.append("<").append(this.myValue.size()).append(">]").toString();
        }
        for (com.clumd.projects.javajson.api.Json value : this.myValue) {
            ret.append(value.asString(depth - 1)).append(",");
        }
        if (ret.charAt(ret.length() - 1) == ',') {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.append("]").toString();
    }

    @Override
    protected void asPrettyString(StringBuilder indent, String tabSize, StringBuilder result, int depth) {
        if (this.myValue.isEmpty()) {
            result.append("[]");
            return;
        }
        indent.append(tabSize);
        result.append('[').append('\n').append((CharSequence)indent);
        if (depth == 0) {
            result.append("<").append(this.myValue.size()).append(">");
        } else {
            this.myValue.forEach(value -> {
                ((Json)value).asPrettyString(indent, tabSize, result, depth - 1);
                result.append(",\n").append((CharSequence)indent);
            });
            result.delete(result.length() - 2 - indent.length(), result.length() - 1);
        }
        indent.delete(0, tabSize.length());
        result.append("\n").append((CharSequence)indent).append(']');
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass() && !(other instanceof List)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof List) {
            List o = (List)other;
            if (this.myValue.size() != o.size()) {
                return false;
            }
            for (int i = 0; i < this.myValue.size(); ++i) {
                if (this.myValue.get(i).equals(o.get(i))) continue;
                return false;
            }
        } else {
            JSArray o = (JSArray)other;
            if (this.myValue.size() != o.myValue.size()) {
                return false;
            }
            for (int i = 0; i < this.myValue.size(); ++i) {
                if (this.myValue.get(i).equals(o.myValue.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.myValue.hashCode();
    }
}

