/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.JSType;
import com.clumd.projects.javajson.core.Json;
import com.clumd.projects.javajson.core.JsonTape;
import com.clumd.projects.javajson.exceptions.json.JsonParseException;
import com.clumd.projects.javajson.exceptions.json.KeyDifferentTypeException;

final class JSNumber
extends Json {
    private Long myLongValue;
    private Double myDoubleValue;

    JSNumber(JsonTape parsingTape) throws JsonParseException {
        super(parsingTape);
        int numberStartIndex = parsingTape.getCurrentIndex();
        boolean foundEnd = false;
        boolean isFloating = false;
        block8: while (!foundEnd) {
            try {
                switch (parsingTape.checkCurrentChar()) {
                    case '.': 
                    case 'E': 
                    case 'e': {
                        isFloating = true;
                    }
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        parsingTape.consumeOne();
                        continue block8;
                    }
                }
                foundEnd = true;
            }
            catch (IndexOutOfBoundsException e) {
                foundEnd = true;
            }
        }
        String numberString = parsingTape.requestRegion(numberStartIndex, parsingTape.getCurrentIndex());
        try {
            if (isFloating) {
                this.myDoubleValue = Double.parseDouble(numberString);
                this.jsType = JSType.DOUBLE;
            } else {
                this.myLongValue = Long.parseLong(numberString);
                this.jsType = JSType.LONG;
            }
        }
        catch (NumberFormatException e) {
            throw (JsonParseException)parsingTape.createParseError("<number>", e.getMessage().replaceFirst("For input string", "Invalid number format"));
        }
    }

    @Override
    public Number getValue() {
        if (this.myLongValue == null) {
            return this.myDoubleValue;
        }
        return this.myLongValue;
    }

    @Override
    public double getDouble() {
        if (this.jsType.equals((Object)JSType.LONG)) {
            throw new KeyDifferentTypeException("This number is a long, not a double.");
        }
        return this.myDoubleValue;
    }

    @Override
    public long getLong() {
        if (this.jsType.equals((Object)JSType.DOUBLE)) {
            throw new KeyDifferentTypeException("This number is a double, not a long.");
        }
        return this.myLongValue;
    }

    @Override
    public String asString(int depth) {
        return this.myLongValue == null ? String.valueOf(this.myDoubleValue) : String.valueOf(this.myLongValue);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.myLongValue != null) {
            if (other instanceof JSNumber) {
                return this.myLongValue.equals(((JSNumber)other).myLongValue);
            }
            if (other instanceof Long) {
                return this.myLongValue.equals(other);
            }
        }
        if (this.myDoubleValue != null) {
            if (other instanceof JSNumber) {
                return this.myDoubleValue.equals(((JSNumber)other).myDoubleValue);
            }
            if (other instanceof Double) {
                return this.myDoubleValue.equals(other);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.myLongValue == null ? Double.hashCode(this.myDoubleValue) : Long.hashCode(this.myLongValue);
    }
}

