/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.JSType;
import com.clumd.projects.javajson.core.Json;
import com.clumd.projects.javajson.core.JsonTape;
import com.clumd.projects.javajson.exceptions.json.JsonParseException;

final class JSString
extends Json {
    private final String myValue;

    JSString(JsonTape parsingTape) throws JsonParseException {
        super(parsingTape);
        char stringDelimiter = parsingTape.checkCurrentChar();
        if (stringDelimiter != '\"' && stringDelimiter != '\'' && stringDelimiter != '`') {
            throw (JsonParseException)parsingTape.createParseError("\" / ' / `", stringDelimiter + " is not a valid string delimiter.");
        }
        StringBuilder string = new StringBuilder();
        boolean currentlyEscaped = false;
        boolean endFound = false;
        parsingTape.consumeOne();
        while (!endFound) {
            char currentChar;
            try {
                currentChar = parsingTape.consumeOne();
            }
            catch (IndexOutOfBoundsException e) {
                throw (JsonParseException)parsingTape.createParseErrorFromOffset(-1, String.valueOf(stringDelimiter), "Didn't find matching " + stringDelimiter + ", before end of string.");
            }
            if (currentlyEscaped) {
                currentlyEscaped = false;
                string.append(currentChar);
                continue;
            }
            if (currentChar == '\\') {
                currentlyEscaped = true;
                continue;
            }
            if (currentChar == stringDelimiter) {
                endFound = true;
                continue;
            }
            string.append(currentChar);
        }
        this.myValue = string.toString();
        this.jsType = JSType.STRING;
    }

    @Override
    public String getValue() {
        return this.myValue;
    }

    @Override
    public String asString(int depth) {
        return "\"" + this.myValue.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + "\"";
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof String) {
            return this.myValue.equals(other);
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.myValue.equals(((JSString)other).myValue);
    }

    @Override
    public int hashCode() {
        return this.myValue.hashCode();
    }
}

