/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.JSArray;
import com.clumd.projects.javajson.core.JSBoolean;
import com.clumd.projects.javajson.core.JSObject;
import com.clumd.projects.javajson.core.JSString;
import com.clumd.projects.javajson.core.JSType;
import com.clumd.projects.javajson.core.JsonKey;
import com.clumd.projects.javajson.core.JsonTape;
import com.clumd.projects.javajson.exceptions.JsonException;
import com.clumd.projects.javajson.exceptions.json.JsonParseException;
import com.clumd.projects.javajson.exceptions.json.KeyDifferentTypeException;
import com.clumd.projects.javajson.exceptions.json.KeyNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

abstract class Json
implements com.clumd.projects.javajson.api.Json {
    public static final int DEFAULT_PRETTY_JSON_INDENT_WIDTH = 2;
    protected static final long serialVersionUID = 100L;
    protected JSType jsType = null;

    Json(JsonTape parsingTape) throws JsonParseException {
    }

    @Override
    public com.clumd.projects.javajson.api.Json createFromString(String jsonFragment) throws JsonParseException {
        return this.parseSelf(jsonFragment);
    }

    @Override
    public com.clumd.projects.javajson.api.Json createFromMultilineString(List<String> jsonFragment) throws JsonParseException {
        return this.parseSelf(jsonFragment);
    }

    @Override
    public com.clumd.projects.javajson.api.Json convertToJSON() throws JsonParseException {
        return this;
    }

    @Override
    public boolean contains(String key) {
        return "".equals(key);
    }

    private com.clumd.projects.javajson.api.Json parseSelf(String jsonFragment) {
        return new JsonTape(jsonFragment).parseNextElement();
    }

    private com.clumd.projects.javajson.api.Json parseSelf(List<String> jsonFragment) {
        StringBuilder concater = new StringBuilder();
        jsonFragment.forEach(line -> {
            concater.append((String)line);
            if (!line.endsWith("\n")) {
                concater.append('\n');
            }
        });
        return this.parseSelf(concater.toString());
    }

    @Override
    public boolean containsAllKeys(Collection<String> keys) {
        if (keys == null) {
            return false;
        }
        for (String key : keys) {
            if (key == null) {
                return false;
            }
            if (this.contains(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSType getDataType() {
        return this.jsType;
    }

    @Override
    public List<String> getKeys() {
        return new ArrayList<String>();
    }

    @Override
    public List<com.clumd.projects.javajson.api.Json> getValues() {
        ArrayList<com.clumd.projects.javajson.api.Json> result = new ArrayList<com.clumd.projects.javajson.api.Json>(1);
        result.add(this);
        return result;
    }

    @Override
    public List<com.clumd.projects.javajson.api.Json> getArray() throws KeyDifferentTypeException {
        return this.getArrayAt("");
    }

    @Override
    public boolean getBoolean() throws KeyDifferentTypeException {
        return this.getBooleanAt("");
    }

    @Override
    public double getDouble() throws KeyDifferentTypeException {
        return this.getDoubleAt("");
    }

    @Override
    public long getLong() throws KeyDifferentTypeException {
        return this.getLongAt("");
    }

    @Override
    public String getString() throws KeyDifferentTypeException {
        return this.getStringAt("");
    }

    @Override
    public com.clumd.projects.javajson.api.Json getJSONObject() throws KeyDifferentTypeException {
        return this.getJSONObjectAt("");
    }

    @Override
    public com.clumd.projects.javajson.api.Json getAny() {
        return this.getAnyAt("");
    }

    @Override
    public Object getValueAt(String key) throws JsonException {
        return this.getMatching(key).getValue();
    }

    @Override
    public JSType getDataTypeOf(String key) throws JsonException {
        return this.getMatching(key).getDataType();
    }

    @Override
    public List<String> getKeysOf(String key) throws JsonException {
        return this.getMatching(key).getKeys();
    }

    @Override
    public List<com.clumd.projects.javajson.api.Json> getValuesOf(String key) throws JsonException {
        return this.getMatching(key).getValues();
    }

    @Override
    public com.clumd.projects.javajson.api.Json getJSONObjectAt(String key) throws JsonException {
        return ((JSObject)this.getMatching(key, JSType.OBJECT)).getValue();
    }

    @Override
    public List<com.clumd.projects.javajson.api.Json> getArrayAt(String key) throws JsonException {
        return ((JSArray)this.getMatching(key, JSType.ARRAY)).getValue();
    }

    @Override
    public boolean getBooleanAt(String key) throws JsonException {
        return ((JSBoolean)this.getMatching(key, JSType.BOOLEAN)).getValue();
    }

    @Override
    public double getDoubleAt(String key) throws JsonException {
        return this.getMatching(key, JSType.DOUBLE).getDouble();
    }

    @Override
    public long getLongAt(String key) throws JsonException {
        return this.getMatching(key, JSType.LONG).getLong();
    }

    @Override
    public String getStringAt(String key) throws JsonException {
        return ((JSString)this.getMatching(key, JSType.STRING)).getValue();
    }

    @Override
    public com.clumd.projects.javajson.api.Json getAnyAt(String key) throws JsonException {
        return this.getMatching(key);
    }

    private com.clumd.projects.javajson.api.Json getMatching(String key, JSType requiredType) {
        com.clumd.projects.javajson.api.Json ret = this.getMatching(key);
        JSType actualTyping = ret.getDataType();
        if (!actualTyping.equals((Object)requiredType)) {
            throw new KeyDifferentTypeException("The Type of Object found" + (String)(key.equals("") ? " " : " for key (" + key + ") ") + "was not expected. Expected: " + requiredType + "  ->  Received: " + actualTyping);
        }
        return ret;
    }

    private com.clumd.projects.javajson.api.Json getMatching(String key) {
        if (key == null) {
            throw new KeyNotFoundException("Key provided was Null");
        }
        if (key.replaceAll("\\s", "").equals("")) {
            return this;
        }
        return this.getInternal(new JsonKey(key, false));
    }

    protected com.clumd.projects.javajson.api.Json getInternal(JsonKey keySequence) throws KeyNotFoundException {
        if (keySequence.getNextKey().equals("")) {
            return this;
        }
        throw new KeyNotFoundException("No child elements on a " + this.jsType);
    }

    @Override
    public String toString() {
        return this.asString(0);
    }

    @Override
    public String toPrettyString() {
        return this.asPrettyString(0);
    }

    @Override
    public String asString() {
        return this.asString(Integer.MAX_VALUE);
    }

    @Override
    public String asPrettyString() {
        return this.asPrettyString(Integer.MAX_VALUE);
    }

    @Override
    public String asPrettyString(int depth) {
        return this.asPrettyString(depth, 2);
    }

    @Override
    public String asPrettyString(int depth, int indentWidth) {
        StringBuilder prettyTabSizeBuilder = new StringBuilder();
        do {
            prettyTabSizeBuilder.append(' ');
        } while (indentWidth-- > 1);
        StringBuilder result = new StringBuilder();
        this.asPrettyString(new StringBuilder(), prettyTabSizeBuilder.toString(), result, depth);
        return result.toString();
    }

    protected void asPrettyString(StringBuilder indent, String tabSize, StringBuilder result, int depth) {
        result.append(this.asString(depth));
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();
}

