/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.BuilderKeyTape;
import com.clumd.projects.javajson.core.KeyTape;
import com.clumd.projects.javajson.exceptions.json.KeyDifferentTypeException;
import com.clumd.projects.javajson.exceptions.json.KeyInvalidException;
import com.clumd.projects.javajson.exceptions.json.KeyNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

final class JsonKey {
    private final List<String> callChain;
    private int currentCallChainIndex = 0;

    JsonKey(String key, boolean useBuilderKeyTape) throws KeyInvalidException {
        if (key == null) {
            throw new KeyInvalidException("Key cannot be null");
        }
        if (!key.equals("")) {
            HashSet<Character> whitespaces = new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t')));
            int start = 0;
            int stop = key.length() - 1;
            while (whitespaces.contains(Character.valueOf(key.charAt(start)))) {
                ++start;
            }
            while (whitespaces.contains(Character.valueOf(key.charAt(stop)))) {
                --stop;
            }
            if (start != 0 || ++stop != key.length()) {
                key = key.substring(start, stop);
            }
        } else {
            this.callChain = new ArrayList<String>();
            this.callChain.add("");
            return;
        }
        this.callChain = useBuilderKeyTape ? new BuilderKeyTape(key).parseAllElements() : new KeyTape(key).parseAllElements();
    }

    String getNextKey() {
        try {
            return this.callChain.get(this.currentCallChainIndex++);
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyNotFoundException("End of Key reached. Have already traversed the whole hierarchy.");
        }
    }

    List<String> getAllKeys() {
        return this.callChain;
    }

    KeyNotFoundException createKeyNotFoundException() {
        return new KeyNotFoundException(this.validateKeyStepForErrorMessage(" not found on element: "));
    }

    KeyDifferentTypeException createKeyDifferentTypeException() {
        return new KeyDifferentTypeException(this.validateKeyStepForErrorMessage(" is not a valid accessor on element: "));
    }

    private String validateKeyStepForErrorMessage(String message) {
        if (this.currentCallChainIndex <= 0) {
            return "Invalid usage of a JSONKey tape - trying to create error before collecting values.";
        }
        if (this.callChain.get(this.currentCallChainIndex - 1).equals("")) {
            return "<Anonymous Key>" + message + this.createUpToString();
        }
        return this.callChain.get(--this.currentCallChainIndex).equals("[append") ? "[]" + message + this.createUpToString() : this.callChain.get(this.currentCallChainIndex).substring(1) + message + this.createUpToString();
    }

    private String createUpToString() {
        if (this.currentCallChainIndex <= 0) {
            return "<base element>";
        }
        StringBuilder upToString = new StringBuilder();
        for (int index = 0; index < this.currentCallChainIndex; ++index) {
            String callChainElement = this.callChain.get(index);
            if (callChainElement.startsWith("[")) {
                upToString.append(callChainElement.equals("[append") ? "[" : callChainElement).append(']');
                continue;
            }
            if (callChainElement.startsWith("{")) {
                upToString.append('.').append(callChainElement.substring(1));
                continue;
            }
            if (!callChainElement.startsWith("<")) continue;
            upToString.append("[\"").append(callChainElement.substring(1).replaceAll("(?<!\\\\)\"", "\\\\\"")).append("\"]");
        }
        if (upToString.charAt(0) == '.') {
            upToString.deleteCharAt(0);
        }
        return upToString.toString();
    }
}

