/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.core.JSArray;
import com.clumd.projects.javajson.core.JSBoolean;
import com.clumd.projects.javajson.core.JSNumber;
import com.clumd.projects.javajson.core.JSObject;
import com.clumd.projects.javajson.core.JSString;
import com.clumd.projects.javajson.core.Json;
import com.clumd.projects.javajson.core.Tape;
import com.clumd.projects.javajson.exceptions.json.JsonParseException;

public final class JsonTape
extends Tape<Json, JsonParseException> {
    static final String VALID_JSON = "{ / [ / \" / <number> / <boolean> ";

    public JsonTape(String fullInput) {
        super(fullInput);
    }

    @Override
    public Json parseNextElement() {
        this.consumeWhiteSpace();
        Json nextElement = null;
        switch (this.checkCurrentChar()) {
            case 'F': 
            case 'T': 
            case 'f': 
            case 't': {
                nextElement = new JSBoolean(this);
                break;
            }
            case '{': {
                nextElement = new JSObject(this);
                break;
            }
            case '[': {
                nextElement = new JSArray(this);
                break;
            }
            case '\"': 
            case '\'': 
            case '`': {
                nextElement = new JSString(this);
                break;
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                nextElement = new JSNumber(this);
                break;
            }
            default: {
                this.createParseError(VALID_JSON);
            }
        }
        return nextElement;
    }

    @Override
    protected JsonParseException newTypedException(String message) {
        return new JsonParseException(message);
    }

    @Override
    protected void consumeWhiteSpace() {
        try {
            block6: while (true) {
                switch (this.checkCurrentChar()) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++this.currentIndex;
                        continue block6;
                    }
                    case '#': 
                    case '/': {
                        this.consumeComment();
                        continue block6;
                    }
                }
                break;
            }
            return;
        }
        catch (IndexOutOfBoundsException e) {
            throw new JsonParseException("Reached the end of the JSON input before parsing was complete. Are you missing a terminating delimiter?");
        }
    }

    private void consumeComment() {
        block0 : switch (this.checkCurrentChar()) {
            case '#': {
                this.consumeUntilNewLine();
                break;
            }
            case '/': {
                switch (this.checkNextChar()) {
                    case '/': {
                        this.consumeUntilNewLine();
                        break block0;
                    }
                    case '*': {
                        this.consumeUntilEndOfMultilineString();
                        break block0;
                    }
                }
                this.createParseError("/ or *");
            }
        }
    }

    private void consumeUntilNewLine() {
        while (this.checkCurrentChar() != '\n') {
            ++this.currentIndex;
        }
        ++this.currentIndex;
    }

    private void consumeUntilEndOfMultilineString() {
        while (!this.checkNextFragment("*/")) {
            ++this.currentIndex;
        }
    }
}

