/*
 * Decompiled with CFR 0.152.
 */
package com.clumd.projects.javajson.core;

import com.clumd.projects.javajson.exceptions.JsonException;

abstract class Tape<T, E extends JsonException> {
    private static final int DEFAULT_PARSE_ERROR_CONTEXT_SIZE = 30;
    private static final String DEFAULT_PARSE_ERROR_CONTEXT_SYMBOL = "_";
    private static final String DEFAULT_PARSE_ERROR_MESSAGE = "Unexpected symbol found while parsing.";
    protected final String fullInput;
    protected int currentIndex = 0;

    Tape(String fullInput) {
        this.fullInput = fullInput;
        if (fullInput == null || fullInput.length() == 0) {
            throw this.newTypedException("You cannot create something from nothing. Input was " + (fullInput == null ? "null." : "empty."));
        }
    }

    abstract T parseNextElement();

    int getCurrentIndex() {
        return this.currentIndex;
    }

    char checkCurrentChar() {
        return this.checkCharAtOffsetFromCurrent(0);
    }

    char checkNextChar() {
        return this.checkCharAtOffsetFromCurrent(1);
    }

    char consumeOne() {
        return this.checkCharAt(this.currentIndex++);
    }

    boolean checkNextFragment(String fragment) {
        if (fragment.length() > this.fullInput.substring(this.currentIndex).length()) {
            return false;
        }
        boolean matches = fragment.equals(this.fullInput.substring(this.currentIndex, this.currentIndex + fragment.length()));
        if (matches) {
            this.currentIndex += fragment.length();
        }
        return matches;
    }

    String requestRegion(int fromHere, int toHere) {
        return this.fullInput.substring(fromHere, toHere);
    }

    E createParseErrorFromOffset(int relativeOffset, String expectedFragment, String customErrorMessage) {
        this.currentIndex += relativeOffset;
        return this.createParseError(expectedFragment, customErrorMessage);
    }

    E createParseError(String expectedFragment, String customErrorMessage) {
        Object gotFragment = "...";
        gotFragment = this.currentIndex > 30 ? (String)gotFragment + this.getNonSpaceSnippetForException() : this.fullInput.substring(0, this.currentIndex);
        gotFragment = (String)gotFragment + DEFAULT_PARSE_ERROR_CONTEXT_SYMBOL;
        int lineCount = 1;
        for (int charIndex = 0; charIndex < this.currentIndex; ++charIndex) {
            if (this.fullInput.charAt(charIndex) != '\n') continue;
            ++lineCount;
        }
        return this.newTypedException(customErrorMessage + "\nLine: " + lineCount + "\nReached: " + (String)gotFragment + "\nExpected: " + expectedFragment);
    }

    void createParseError(String expectedFragment) {
        throw this.createParseError(expectedFragment, DEFAULT_PARSE_ERROR_MESSAGE);
    }

    protected abstract E newTypedException(String var1);

    protected void consumeWhiteSpace() {
        try {
            block5: while (true) {
                switch (this.fullInput.charAt(this.currentIndex)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++this.currentIndex;
                        continue block5;
                    }
                }
                break;
            }
            return;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.newTypedException("Reached end of input before parsing was complete. Are you missing a terminating delimiter?");
        }
    }

    private char checkCharAtOffsetFromCurrent(int relativeOffset) {
        return this.checkCharAt(this.currentIndex + relativeOffset);
    }

    private char checkCharAt(int absoluteOffset) {
        return this.fullInput.charAt(absoluteOffset);
    }

    private String getNonSpaceSnippetForException() {
        int snippetIndex = this.currentIndex - 1;
        for (int snippetLength = 0; snippetIndex > 0 && snippetLength < 30; --snippetIndex, ++snippetLength) {
            char currentChar = this.checkCharAt(snippetIndex);
            switch (currentChar) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    --snippetLength;
                }
            }
        }
        return this.fullInput.substring(snippetIndex, this.currentIndex);
    }
}

