/*
 * Decompiled with CFR 0.152.
 */
package codacy.api.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class ApiRequest {
    private String scheme = null;
    private String url = null;
    private int port = 80;

    public ApiRequest(String scheme, String url, int port) {
        this.scheme = scheme;
        this.url = url;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request(String requestType, String endpoint, HashMap<String, String> parameters) throws URISyntaxException, IOException {
        HttpURLConnection conn = null;
        try {
            ArrayList<BasicNameValuePair> nameValues = new ArrayList<BasicNameValuePair>();
            for (String identifier : parameters.keySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(identifier, parameters.get(identifier));
                nameValues.add(pair);
            }
            URI uri = new URIBuilder().setScheme(this.scheme).setHost(this.url).setPort(this.port).setPath(endpoint).setParameters(nameValues).build();
            if (requestType.equals("https")) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)uri.toURL().openConnection();
                httpsConn.setRequestMethod(requestType);
                httpsConn.setDoInput(true);
                httpsConn.connect();
                conn = httpsConn;
            } else {
                HttpURLConnection httpConn = (HttpURLConnection)uri.toURL().openConnection();
                httpConn.setRequestMethod(requestType);
                httpConn.setDoInput(true);
                httpConn.connect();
                conn = httpConn;
            }
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)conn.getInputStream(), (Writer)writer, (String)"UTF-8");
            String string = writer.toString();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

