/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.core;

import com.codegik.gitflow.command.CommandExecutor;
import com.codegik.gitflow.command.GitCommandExecutor;
import com.codegik.gitflow.core.BranchType;
import com.codegik.gitflow.core.GitFlowPattern;
import com.codegik.gitflow.core.MergeGitFlow;
import com.codegik.gitflow.core.impl.DefaultBranchType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;

public abstract class GitFlow {
    private Git git;
    private Log log;
    private File repository;
    private CommandExecutor gitExecutor;
    private GitFlowPattern gitFlowPattern;

    public GitFlow(GitFlowPattern gitFlowPattern, Log log, File repository) {
        this.log = log;
        this.repository = repository;
        this.gitFlowPattern = gitFlowPattern;
        this.gitExecutor = new GitCommandExecutor(log);
    }

    public void setGit(Git git) {
        this.git = git;
    }

    public Git getGit() throws Exception {
        if (this.git == null) {
            this.git = Git.open((File)this.repository);
        }
        return this.git;
    }

    public String getBranch() throws Exception {
        return this.getGit().getRepository().getBranch();
    }

    public Ref tag(String tagName, String message) throws Exception {
        this.getLog().info((CharSequence)("Tagging " + tagName));
        return this.getGit().tag().setName(tagName).setMessage(message).call();
    }

    public void merge(MergeGitFlow mergeGitFlow) throws Exception {
        this.merge(mergeGitFlow, null);
    }

    public void merge(MergeGitFlow mergeGitFlow, MergeStrategy mergeStrategy) throws Exception {
        this.getLog().info((CharSequence)("Merging " + mergeGitFlow.getTargetRef().getName() + " into " + mergeGitFlow.getBranchName()));
        MergeResult mergeResult = null;
        mergeResult = mergeStrategy == null ? this.getGit().merge().include(mergeGitFlow.getTargetRef()).call() : this.getGit().merge().setStrategy(mergeStrategy).include(mergeGitFlow.getTargetRef()).call();
        if (!mergeResult.getMergeStatus().isSuccessful()) {
            this.processPreferentialConflicts(mergeGitFlow, mergeResult);
        }
    }

    private void processPreferentialConflicts(MergeGitFlow mergeGitFlow, MergeResult merge) throws Exception {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : merge.getConflicts().keySet()) {
            for (String file : mergeGitFlow.getIgnoringFiles()) {
                if (!key.contains(file)) continue;
                this.checkoutFiles(mergeGitFlow.getBranchName(), key, mergeGitFlow.getIgnoringFilesStage());
                toRemove.add(key);
            }
        }
        for (String key : toRemove) {
            merge.getConflicts().remove(key);
        }
        if (merge.getConflicts().size() > 0) {
            throw this.buildConflictExeption(mergeGitFlow, merge);
        }
        this.commit("Commiting resolved conflicts");
    }

    public String deleteRemoteBranch(Ref branchRef) throws Exception {
        String simpleName = this.getSimpleBranchName(branchRef);
        this.deleteLocalBranch(simpleName);
        return this.gitExecutor.execute("push", "origin", ":" + simpleName);
    }

    public String deleteRemoteBranch(String branchName) throws Exception {
        this.getLog().info((CharSequence)("Deleting branch " + branchName));
        Ref branchRef = this.findBranch(branchName);
        if (branchRef == null) {
            throw new MojoExecutionException("Branch " + branchName + " not found");
        }
        return this.deleteRemoteBranch(branchRef);
    }

    public void deleteRemoteBranch(String version, BranchType branchType) throws Exception {
        this.getLog().info((CharSequence)("Deleting " + branchType.toString() + " branch of release " + version));
        ArrayList<String> deleted = new ArrayList<String>();
        String release = branchType.toString() + this.gitFlowPattern.getGitSeparator() + version;
        for (Ref b : this.getGit().branchList().setListMode(ListBranchCommand.ListMode.ALL).call()) {
            if (!b.getName().contains(release) || deleted.contains(this.getSimpleBranchName(b))) continue;
            this.deleteRemoteBranch(b);
            deleted.add(this.getSimpleBranchName(b));
        }
    }

    public String deleteLocalBranch(String branchName) throws Exception {
        this.getLog().info((CharSequence)("Deleting local branch " + branchName));
        if (this.getBranch().equals(branchName)) {
            throw new MojoExecutionException("Please change to another branch before delete");
        }
        if (this.findLocalBranch(branchName) != null) {
            return this.gitExecutor.execute("branch", "-D", branchName);
        }
        return null;
    }

    public String deleteTag(String tagName) throws Exception {
        return this.gitExecutor.execute("push", "origin", ":" + tagName);
    }

    public Ref reset(String branchName) throws Exception {
        this.getLog().info((CharSequence)("Reseting into " + branchName));
        return this.getGit().reset().setMode(ResetCommand.ResetType.HARD).setRef(branchName).call();
    }

    public Ref checkoutBranchForced(String branchName) throws Exception {
        this.getLog().info((CharSequence)("Checkout forced into " + branchName));
        return this.getGit().checkout().setCreateBranch(false).setForce(true).setName(branchName).call();
    }

    public Ref checkoutBranch(String branchName) throws Exception {
        this.getLog().info((CharSequence)("Checkout into " + branchName));
        Boolean branchExists = this.getGit().getRepository().getRef(branchName) != null;
        if (!branchExists.booleanValue()) {
            this.getGit().branchCreate().setName(branchName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + branchName).call();
        }
        return this.getGit().checkout().setName(branchName).call();
    }

    public Ref checkoutFiles(String branchName, String file, CheckoutCommand.Stage stage) throws Exception {
        this.getLog().info((CharSequence)("Updating file " + file + " from branch " + branchName + " using " + stage.toString()));
        Ref ref = this.getGit().checkout().addPath(file).setName(branchName).setCreateBranch(false).setStage(stage).call();
        this.getGit().add().addFilepattern(file).call();
        return ref;
    }

    public Ref createBranch(String branchName) throws Exception {
        this.getLog().info((CharSequence)("Creating branch " + branchName));
        return this.getGit().checkout().setCreateBranch(true).setName(branchName).call();
    }

    public RevCommit commit(String message) throws Exception {
        this.getLog().info((CharSequence)("Commiting... " + message));
        this.getGit().add().addFilepattern(".").call();
        return this.getGit().commit().setAll(true).setMessage(message).call();
    }

    public String pull() throws Exception {
        return this.gitExecutor.execute("pull");
    }

    public String pushBranch(String branchName) throws Exception {
        return this.gitExecutor.execute("push", "--set-upstream", "origin", branchName);
    }

    public String pushTag(Ref tag) throws Exception {
        this.getLog().info((CharSequence)("Pushing Tag " + tag.getName()));
        return this.gitExecutor.execute("push", "origin", this.getVersionFromTag(tag));
    }

    public String push() throws Exception {
        this.getLog().info((CharSequence)"Pushing commit");
        return this.gitExecutor.execute("push");
    }

    private Ref findLocalBranch(String branch) throws Exception {
        this.getLog().info((CharSequence)("Looking for local branch " + branch));
        for (Ref b : this.getGit().branchList().call()) {
            if (!branch.equals(b.getName().toLowerCase().replace("refs/heads/", ""))) continue;
            return b;
        }
        return null;
    }

    public Ref findBranch(String branch) throws Exception {
        this.getLog().info((CharSequence)("Looking for branch " + branch));
        for (Ref b : this.getGit().branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call()) {
            if (!branch.equals(this.getSimpleBranchName(b))) continue;
            return b;
        }
        return null;
    }

    public MojoExecutionException buildConflictExeption(MergeGitFlow mergeGitFlow, MergeResult merge) {
        this.getLog().error((CharSequence)"There is conflicts in the following files:");
        for (String key : merge.getConflicts().keySet()) {
            this.getLog().error((CharSequence)key);
        }
        String message = "\nThe merge has conflicts, please try resolve manually! [from " + mergeGitFlow.getTargetRef().getName() + " to " + mergeGitFlow.getBranchName() + "]";
        message = message + "\nExecute the steps:";
        message = message + "\ngit reset --hard " + mergeGitFlow.getBranchName();
        message = message + "\ngit checkout " + mergeGitFlow.getBranchName();
        message = message + "\ngit merge " + mergeGitFlow.getTargetRef().getName();
        message = message + "\nmvn gitflow:" + mergeGitFlow.getErrorMessage();
        return new MojoExecutionException(message);
    }

    public RevCommit revertCommit(RevCommit commit) throws Exception {
        this.getLog().info((CharSequence)"Reverting commit");
        return this.getGit().revert().include((AnyObjectId)commit).setStrategy(MergeStrategy.OURS).call();
    }

    public String getSimpleBranchName(Ref ref) {
        return this.replaceAll(ref);
    }

    public String replaceAll(Ref ref) {
        String result = ref.getName();
        for (String replace : this.getGitFlowPattern().getPrefixToReplace()) {
            result = result.replace(replace, "");
        }
        return result;
    }

    public String getReleaseFromVersion(String fullVersion) {
        Matcher matcher = this.getGitFlowPattern().getTagVersionPattern().matcher(fullVersion);
        if (matcher.matches()) {
            return String.format("%s.%s", matcher.group(1), matcher.group(2));
        }
        return null;
    }

    public String getVersionFromTag(Ref tag) {
        return tag.getName().replace(this.getGitFlowPattern().getPrefixGitTag() + this.getGitFlowPattern().getGitSeparator(), "");
    }

    public String buildDevBranchName(String branchType, String version, String branchName) {
        return branchType + this.getGitFlowPattern().getGitSeparator() + version + this.getGitFlowPattern().getGitSeparator() + branchName;
    }

    public String buildReleaseBranchName(String version) {
        return this.getGitFlowPattern().getPrefixGitRelease() + this.getGitFlowPattern().getGitSeparator() + version;
    }

    public String buildHotfixBranchName(String version, String branchName) {
        return this.getGitFlowPattern().getPrefixGitHotfix() + this.getGitFlowPattern().getGitSeparator() + version + this.getGitFlowPattern().getGitSeparator() + branchName;
    }

    public String buildHotfixBranchName(String branchName) {
        return this.getGitFlowPattern().getPrefixGitHotfix() + this.getGitFlowPattern().getGitSeparator() + branchName;
    }

    public String buildRemoteBranchName(Ref ref) {
        return this.getGitFlowPattern().getPrefixGitHeads() + this.replaceAll(ref);
    }

    public List<String> branchTypeToArray() {
        ArrayList<String> values = new ArrayList<String>();
        for (DefaultBranchType type : DefaultBranchType.values()) {
            values.add(type.name());
        }
        return values;
    }

    public Map<String, String> validateFullBranchName(String branchName) throws Exception {
        String errorMessage = "The fullBranchName must be <branchType=[feature|bugfix]>/<releaseVersion>/<branchName>. EX: feature/1.1.0/issue3456";
        String[] pattern = branchName.split("/");
        HashMap<String, String> result = new HashMap<String, String>();
        if (pattern.length != 3) {
            throw new MojoExecutionException(errorMessage);
        }
        if (!this.branchTypeToArray().contains(pattern[0])) {
            throw new MojoExecutionException(errorMessage);
        }
        result.put("branchType", pattern[0]);
        result.put("version", pattern[1]);
        result.put("branchName", pattern[2]);
        return result;
    }

    protected Log getLog() {
        return this.log;
    }

    public GitFlowPattern getGitFlowPattern() {
        return this.gitFlowPattern;
    }
}

