/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.core;

import com.codegik.gitflow.command.CommandExecutor;
import com.codegik.gitflow.command.MvnCommandExecutor;
import com.codegik.gitflow.core.impl.DefaultGitFlow;
import java.util.ArrayList;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;

public abstract class GitFlowMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="skipTests")
    private Boolean skipTests;
    private CommandExecutor mvnExecutor;

    public abstract DefaultGitFlow getGitFlow();

    public abstract void run() throws Exception;

    public abstract void rollback(Exception var1) throws MojoExecutionException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.mvnExecutor = new MvnCommandExecutor(this.getLog());
        try {
            this.run();
            this.getLog().info((CharSequence)"DONE");
        }
        catch (Exception e) {
            this.rollback(e);
        }
    }

    protected String updatePomVersion(String newVersion) throws Exception {
        this.getLog().info((CharSequence)("Bumping version of files to " + newVersion));
        return this.mvnExecutor.execute("versions:set", "-DgenerateBackupPoms=false", "-DnewVersion=" + newVersion, "-DskipTests");
    }

    public String compileProject() throws Exception {
        this.getLog().info((CharSequence)"Compiling project...");
        ArrayList<String> args = new ArrayList<String>();
        args.add("clean");
        args.add("install");
        if (Boolean.TRUE.equals(this.getSkipTests())) {
            args.add("-DskipTests");
        }
        if (Boolean.TRUE.equals(this.getSettings().isOffline())) {
            args.add("-o");
        }
        if (this.getSettings().getActiveProfiles() != null && this.getSettings().getActiveProfiles().size() > 0) {
            args.add("-P");
            args.add(StringUtils.join(this.getSettings().getActiveProfiles().iterator(), (String)","));
        }
        return this.mvnExecutor.execute(args.toArray(new String[args.size()]));
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public Boolean getSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(Boolean skipTests) {
        this.skipTests = skipTests;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public CommandExecutor getMvnExecutor() {
        return this.mvnExecutor;
    }

    public void setMvnExecutor(CommandExecutor mvnExecutor) {
        this.mvnExecutor = mvnExecutor;
    }

    public MavenSession getSession() {
        return this.session;
    }
}

