/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.core.impl;

import com.codegik.gitflow.core.GitFlow;
import com.codegik.gitflow.core.GitFlowPattern;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevWalk;

public class DefaultGitFlow
extends GitFlow {
    public DefaultGitFlow(GitFlowPattern gitFlowPattern, Log log) {
        this(gitFlowPattern, log, new File("."));
    }

    public DefaultGitFlow(GitFlowPattern gitFlowPattern, Log log, File repository) {
        super(gitFlowPattern, log, repository);
    }

    public void validadePatternReleaseVersion(String version) throws Exception {
        if (!this.getGitFlowPattern().getReleaseVersionPattern().matcher(version).matches()) {
            throw new MojoExecutionException("The version pattern is " + this.getGitFlowPattern().getReleaseVersionPattern().toString() + "  EX: 1.3");
        }
    }

    public Ref validadeReleaseVersion(String version) throws Exception {
        this.validadePatternReleaseVersion(version);
        String fullVersion = this.buildReleaseBranchName(version);
        Ref ref = this.findBranch(fullVersion);
        if (ref == null) {
            throw new MojoExecutionException("The version " + fullVersion + "  not found");
        }
        return ref;
    }

    public Ref findLastTag() throws Exception {
        return this.findLastTag(null);
    }

    public Ref findLastTag(String releaseVersion) throws Exception {
        final RevWalk walk = new RevWalk(this.getGit().getRepository());
        List tags = this.getGit().tagList().call();
        int index = 0;
        if (releaseVersion != null) {
            while (index < tags.size()) {
                if (!((Ref)tags.get(index)).getName().startsWith(this.getGitFlowPattern().getPrefixGitTag() + this.getGitFlowPattern().getGitSeparator() + releaseVersion + ".")) {
                    tags.remove(index);
                    continue;
                }
                ++index;
            }
        }
        index = 0;
        while (index < tags.size()) {
            if (!this.getGitFlowPattern().getTagVersionPattern().matcher(this.getVersionFromTag((Ref)tags.get(index))).matches()) {
                tags.remove(index);
                continue;
            }
            ++index;
        }
        Collections.sort(tags, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                Date d1 = null;
                Date d2 = null;
                try {
                    d1 = walk.parseTag((AnyObjectId)o1.getObjectId()).getTaggerIdent().getWhen();
                    d2 = walk.parseTag((AnyObjectId)o2.getObjectId()).getTaggerIdent().getWhen();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return d1.compareTo(d2);
            }
        });
        return tags.size() > 0 ? (Ref)tags.get(tags.size() - 1) : null;
    }

    public String increaseVersion(String version) throws Exception {
        Matcher matcher = this.getGitFlowPattern().getTagVersionPattern().matcher(version);
        if (matcher.matches()) {
            Integer increment;
            Integer n = increment = new Integer(matcher.group(3));
            Integer n2 = increment = Integer.valueOf(increment + 1);
            return String.format("%s.%s.%s", matcher.group(1), matcher.group(2), increment.toString());
        }
        throw new MojoExecutionException("The version " + version + " does not match with pattern " + this.getGitFlowPattern().getTagVersionPattern().toString());
    }

    public String increaseVersionBasedOnTag(Ref lastTag) throws Exception {
        return this.increaseVersionBasedOnTag(this.getVersionFromTag(lastTag));
    }

    public String increaseVersionBasedOnTag(String version) throws Exception {
        Matcher matcher = this.getGitFlowPattern().getTagVersionPattern().matcher(version);
        if (matcher.matches()) {
            String releaseVersion = String.format("%s.%s", matcher.group(1), matcher.group(2));
            Ref lastTag = this.findLastTag(releaseVersion);
            String newVersion = null;
            Integer increment = null;
            if (lastTag == null) {
                newVersion = matcher.group(3);
            } else {
                newVersion = this.getVersionFromTag(lastTag);
                matcher = this.getGitFlowPattern().getTagVersionPattern().matcher(newVersion);
                newVersion = matcher.matches() ? matcher.group(3) : null;
            }
            Integer n = increment = new Integer(newVersion);
            Integer n2 = increment = Integer.valueOf(increment + 1);
            return String.format("%s.%s.%s", matcher.group(1), matcher.group(2), increment.toString());
        }
        throw new MojoExecutionException("The version " + version + " does not match with pattern " + this.getGitFlowPattern().getTagVersionPattern().toString());
    }

    public CheckoutCommand.Stage defineStageForMerge(String currentVersion, String releaseBranchVersion) throws Exception {
        return Boolean.TRUE.equals(this.isReleaseSmallerThanCurrentVersion(releaseBranchVersion, currentVersion)) ? CheckoutCommand.Stage.OURS : CheckoutCommand.Stage.THEIRS;
    }

    public Boolean isReleaseSmallerThanCurrentVersion(String releaseBranchVersion, String currentVersion) throws Exception {
        this.getLog().info((CharSequence)("Is release smaller than currentVersion " + releaseBranchVersion + " -> " + currentVersion + "?"));
        Matcher matcherReleaseBranchVersion = this.getGitFlowPattern().getReleaseVersionPattern().matcher(releaseBranchVersion);
        Matcher matcherCurrentVersion = this.getGitFlowPattern().getTagVersionPattern().matcher(currentVersion);
        if (!matcherCurrentVersion.matches()) {
            throw new MojoExecutionException("The currentVersion " + currentVersion + " does not match with pattern " + this.getGitFlowPattern().getTagVersionPattern().toString());
        }
        if (!matcherReleaseBranchVersion.matches()) {
            throw new MojoExecutionException("The releaseBranchVersion " + releaseBranchVersion + " does not match with pattern " + this.getGitFlowPattern().getTagVersionPattern().toString());
        }
        return this.compareVersions(matcherReleaseBranchVersion, matcherCurrentVersion) == -1;
    }

    private Integer compareVersions(Matcher version1, Matcher version2) throws MojoExecutionException {
        int maxGroup = version1.groupCount() < version2.groupCount() ? version1.groupCount() : version2.groupCount();
        for (int i = 1; i <= maxGroup; ++i) {
            int intVersion2;
            int intVersion1 = new Integer(version1.group(i));
            if (intVersion1 == (intVersion2 = new Integer(version2.group(i)).intValue())) continue;
            if (intVersion1 < intVersion2) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public Integer whatIsTheBigger(String firstVersion, String secondVersion) throws Exception {
        Integer intSecondVersion;
        this.getLog().info((CharSequence)("What is bigger " + firstVersion + " -> " + secondVersion + "?"));
        Matcher matcherFirstVersion = this.getGitFlowPattern().getTagVersionPattern().matcher(firstVersion);
        Matcher matcherSecondVersion = this.getGitFlowPattern().getTagVersionPattern().matcher(secondVersion);
        if (!matcherFirstVersion.matches()) {
            throw new MojoExecutionException("The firstVersion " + firstVersion + " does not match with pattern " + this.getGitFlowPattern().getTagVersionPattern().toString());
        }
        if (!matcherSecondVersion.matches()) {
            throw new MojoExecutionException("The secondVersion " + secondVersion + " does not match with pattern " + this.getGitFlowPattern().getTagVersionPattern().toString());
        }
        Integer intFirstVersion = new Integer(matcherFirstVersion.group(2));
        if (intFirstVersion.compareTo(intSecondVersion = new Integer(matcherSecondVersion.group(2))) == 0) {
            intFirstVersion = new Integer(matcherFirstVersion.group(3));
            intSecondVersion = new Integer(matcherSecondVersion.group(3));
        }
        return intFirstVersion.compareTo(intSecondVersion);
    }
}

