/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.mojo;

import com.codegik.gitflow.core.MergeGitFlow;
import com.codegik.gitflow.core.impl.DefaultGitFlowMojo;
import java.io.File;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.api.PomHelper;
import org.eclipse.jgit.lib.Ref;

@Mojo(name="build-release", aggregator=true)
public class BuildReleaseMojo
extends DefaultGitFlowMojo {
    @Parameter(property="version", required=true)
    private String version;

    @Override
    public void run() throws Exception {
        String releaseBranch = this.getGitFlow().buildReleaseBranchName(this.getVersion());
        if (!this.getGitFlow().getBranch().equals(releaseBranch)) {
            throw new MojoExecutionException("You must be on branch " + releaseBranch + " for execute this goal! ");
        }
        Ref releaseRef = this.getGitFlow().validadeReleaseVersion(this.getVersion());
        String devPomVer = PomHelper.getVersion((Model)PomHelper.getRawModel((File)this.getProject().getFile()));
        Ref develop = this.getGitFlow().findBranch(this.getGitFlow().getGitFlowPattern().getDevelopName());
        String branch = this.getGitFlow().getSimpleBranchName(releaseRef);
        this.getGitFlow().checkoutBranch(branch);
        MergeGitFlow mergeGitFlow = new MergeGitFlow();
        mergeGitFlow.setBranchName(branch);
        mergeGitFlow.setErrorMessage("build-release -Dversion=" + this.getVersion());
        mergeGitFlow.setTargetRef(develop);
        mergeGitFlow.setIgnoringFilesStage(this.getGitFlow().defineStageForMerge(devPomVer, this.getVersion()));
        mergeGitFlow.addIgnoringFiles(this.getGitFlow().getGitFlowPattern().getPomFileName());
        this.getGitFlow().merge(mergeGitFlow);
        this.compileProject();
        this.getGitFlow().commit("[GitFlow::build-release] Build release branch " + this.getVersion());
        this.getGitFlow().push();
    }

    @Override
    public void rollback(Exception e) throws MojoExecutionException {
        throw new MojoExecutionException("ERROR", e);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

