/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.mojo;

import com.codegik.gitflow.core.MergeGitFlow;
import com.codegik.gitflow.core.impl.DefaultGitFlowMojo;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.lib.Ref;

@Mojo(name="finish-development", aggregator=true)
public class FinishDevelopmentMojo
extends DefaultGitFlowMojo {
    @Parameter(property="fullBranchName", required=true)
    private String branchName;
    @Parameter(property="keepBranch", defaultValue="true")
    private Boolean keepBranch;

    @Override
    public void run() throws Exception {
        Map<String, String> branchInfo = this.getGitFlow().validateFullBranchName(this.getBranchName());
        String releaseBranch = this.getGitFlow().buildReleaseBranchName(branchInfo.get("version"));
        this.getGitFlow().checkoutBranch(releaseBranch);
        Ref ref = this.getGitFlow().findBranch(this.getBranchName());
        if (ref == null) {
            throw new MojoExecutionException("The fullBranchName " + this.getBranchName() + " not found!");
        }
        MergeGitFlow mergeGitFlow = new MergeGitFlow();
        mergeGitFlow.setBranchName(releaseBranch);
        mergeGitFlow.setErrorMessage("finish-development -DfullBranchName=" + this.getBranchName());
        mergeGitFlow.setTargetRef(ref);
        mergeGitFlow.setIgnoringFilesStage(CheckoutCommand.Stage.OURS);
        mergeGitFlow.addIgnoringFiles(this.getGitFlow().getGitFlowPattern().getPomFileName());
        this.getGitFlow().merge(mergeGitFlow);
        this.compileProject();
        this.getGitFlow().push();
        if (!this.keepBranch.booleanValue()) {
            this.getGitFlow().deleteRemoteBranch(this.getBranchName());
        }
    }

    @Override
    public void rollback(Exception e) throws MojoExecutionException {
        throw new MojoExecutionException("ERROR", e);
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }
}

