/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.mojo;

import com.codegik.gitflow.core.MergeGitFlow;
import com.codegik.gitflow.core.impl.DefaultGitFlowMojo;
import java.io.File;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.api.PomHelper;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;

@Mojo(name="finish-hotfix", aggregator=true)
public class FinishHotfixMojo
extends DefaultGitFlowMojo {
    private String pomVersion;
    private RevCommit revertCommit;
    @Parameter(property="branchName", required=true)
    private String branchName;
    @Parameter(property="version")
    private String version;

    @Override
    public void run() throws Exception {
        String simpleName = this.getBranchName();
        this.setBranchName(this.getGitFlow().buildHotfixBranchName(this.getBranchName()));
        if (this.getVersion() != null) {
            this.getGitFlow().validadePatternReleaseVersion(this.getVersion());
        }
        if (this.getGitFlow().findBranch(this.getBranchName()) == null) {
            throw new MojoExecutionException("The branch " + this.getBranchName() + " dosen't exists!");
        }
        Ref hotfixRef = this.getGitFlow().checkoutBranch(this.getBranchName());
        this.pomVersion = PomHelper.getVersion((Model)PomHelper.getRawModel((File)this.getProject().getFile()));
        Ref lastTag = this.getGitFlow().findLastTag();
        if (lastTag != null) {
            this.getLog().info((CharSequence)"Finding the newest tag");
            String lastTagVer = this.getGitFlow().getVersionFromTag(lastTag);
            if (this.getGitFlow().whatIsTheBigger(this.pomVersion, lastTagVer) <= 0) {
                this.getLog().info((CharSequence)("Found newer " + lastTagVer));
                String newVersion = this.getGitFlow().increaseVersionBasedOnTag(lastTag);
                this.updatePomVersion(newVersion);
                this.compileProject();
                this.revertCommit = this.getGitFlow().commit("[GitFlow::finish-hotfix] Bumped version number to " + newVersion);
                this.getGitFlow().push();
            }
        }
        this.getGitFlow().checkoutBranch(this.getGitFlow().getGitFlowPattern().getMasterName());
        this.getGitFlow().reset(this.getGitFlow().getGitFlowPattern().getOriginName() + this.getGitFlow().getGitFlowPattern().getGitSeparator() + this.getGitFlow().getGitFlowPattern().getMasterName());
        this.getGitFlow().deleteLocalBranch(this.getBranchName());
        hotfixRef = this.getGitFlow().findBranch(this.getBranchName());
        MergeGitFlow mergeGitFlow = new MergeGitFlow();
        mergeGitFlow.setBranchName(this.getGitFlow().getGitFlowPattern().getMasterName());
        mergeGitFlow.setErrorMessage("finish-hotfix -DbranchName=" + simpleName);
        mergeGitFlow.setTargetRef(hotfixRef);
        mergeGitFlow.setIgnoringFilesStage(CheckoutCommand.Stage.THEIRS);
        mergeGitFlow.addIgnoringFiles(this.getGitFlow().getGitFlowPattern().getPomFileName());
        this.getGitFlow().merge(mergeGitFlow);
        this.compileProject();
        this.getGitFlow().push();
        this.pomVersion = PomHelper.getVersion((Model)PomHelper.getRawModel((File)this.getProject().getFile()));
        Ref tag = this.getGitFlow().tag(this.pomVersion, "[GitFlow::finish-hotfix] Create tag " + this.pomVersion);
        this.getGitFlow().pushTag(tag);
        this.getGitFlow().checkoutBranch(this.getGitFlow().getGitFlowPattern().getDevelopName());
        this.getGitFlow().merge(mergeGitFlow);
        this.getGitFlow().deleteRemoteBranch(this.getBranchName());
        this.getGitFlow().push();
    }

    @Override
    public void rollback(Exception e) throws MojoExecutionException {
        try {
            this.getLog().error((CharSequence)e.getMessage());
            this.getLog().info((CharSequence)"Rolling back all changes");
            this.getGitFlow().reset(this.getGitFlow().getGitFlowPattern().getMasterName());
            this.getGitFlow().checkoutBranchForced(this.getGitFlow().getGitFlowPattern().getMasterName());
            if (this.revertCommit != null) {
                this.getGitFlow().revertCommit(this.revertCommit);
                this.getGitFlow().push();
            }
            if (this.pomVersion != null) {
                this.getGitFlow().deleteTag(this.pomVersion);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new MojoExecutionException("ERROR", e);
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

