/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.mojo;

import com.codegik.gitflow.core.MergeGitFlow;
import com.codegik.gitflow.core.impl.DefaultGitFlowMojo;
import java.io.File;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.api.PomHelper;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;

@Mojo(name="finish-release", aggregator=true)
public class FinishReleaseMojo
extends DefaultGitFlowMojo {
    private String pomVersion;
    private RevCommit revertCommit;
    @Parameter(property="version", required=true)
    private String version;

    @Override
    public void run() throws Exception {
        Ref releaseRef = this.getGitFlow().validadeReleaseVersion(this.getVersion());
        if (!this.getGitFlow().getBranch().equals(this.getGitFlow().getGitFlowPattern().getDevelopName())) {
            throw new MojoExecutionException("You must be on branch develop for execute this goal! ");
        }
        this.pomVersion = this.getProject().getVersion();
        Ref lastTag = this.getGitFlow().findLastTag();
        String lastTagVer = this.getGitFlow().getVersionFromTag(lastTag);
        if (this.getGitFlow().isReleaseSmallerThanCurrentVersion(this.getVersion(), lastTagVer).booleanValue()) {
            throw new MojoExecutionException("The release " + this.getVersion() + " is older than " + lastTagVer + ", please start new release!");
        }
        lastTag = this.getGitFlow().findLastTag(this.getVersion());
        if (lastTag != null) {
            this.getLog().info((CharSequence)"Finding the newest tag");
            lastTagVer = this.getGitFlow().getVersionFromTag(lastTag);
            if (this.getGitFlow().whatIsTheBigger(this.pomVersion, lastTagVer) <= 0) {
                this.getLog().info((CharSequence)("Found newer " + lastTagVer));
                String newVersion = this.getGitFlow().increaseVersionBasedOnTag(lastTag);
                this.updatePomVersion(newVersion);
                this.compileProject();
                this.revertCommit = this.getGitFlow().commit("[GitFlow::finish-release] Bumped version number to " + newVersion);
                this.getGitFlow().push();
                this.pomVersion = PomHelper.getVersion((Model)PomHelper.getRawModel((File)this.getProject().getFile()));
            }
        }
        MergeGitFlow mergeGitFlow = new MergeGitFlow();
        mergeGitFlow.setBranchName(this.getGitFlow().getGitFlowPattern().getDevelopName());
        mergeGitFlow.setErrorMessage("finish-release -Dversion=" + this.getVersion());
        mergeGitFlow.setTargetRef(releaseRef);
        mergeGitFlow.setIgnoringFilesStage(this.getGitFlow().defineStageForMerge(this.pomVersion, this.getVersion()));
        mergeGitFlow.addIgnoringFiles(this.getGitFlow().getGitFlowPattern().getPomFileName());
        this.getGitFlow().merge(mergeGitFlow);
        this.compileProject();
        this.pomVersion = PomHelper.getVersion((Model)PomHelper.getRawModel((File)this.getProject().getFile()));
        Ref tag = this.getGitFlow().tag(this.pomVersion, "[GitFlow::finish-release] Create tag " + this.pomVersion);
        this.getGitFlow().commit("[GitFlow::finish-release] Finish release branch " + this.getVersion());
        this.getGitFlow().push();
        this.getGitFlow().pushTag(tag);
        this.getGitFlow().checkoutBranch(this.getGitFlow().getSimpleBranchName(releaseRef));
        String newVersion = this.getGitFlow().increaseVersionBasedOnTag(tag);
        this.updatePomVersion(newVersion);
        this.getGitFlow().commit("[GitFlow::finish-release] Bumped version number to " + newVersion);
        this.getGitFlow().push();
    }

    @Override
    public void rollback(Exception e) throws MojoExecutionException {
        try {
            this.getLog().error((CharSequence)e.getMessage());
            this.getLog().info((CharSequence)"Rolling back all changes");
            if (this.revertCommit != null) {
                this.getGitFlow().revertCommit(this.revertCommit);
                this.getGitFlow().push();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new MojoExecutionException("ERROR", e);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

