/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.mojo;

import com.codegik.gitflow.core.impl.DefaultGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.lib.Ref;

@Mojo(name="init", aggregator=true)
public class InitMojo
extends DefaultGitFlowMojo {
    @Parameter(property="version")
    private String version;

    @Override
    public void run() throws Exception {
        if (!this.getGitFlow().getBranch().equals(this.getGitFlow().getGitFlowPattern().getMasterName())) {
            throw new MojoExecutionException("You must be on branch master for execute this goal!");
        }
        String newVersion = "1.0";
        if (this.version != null) {
            this.getGitFlow().validadePatternReleaseVersion(this.version);
            newVersion = this.version;
        }
        Ref lastTag = this.getGitFlow().findLastTag(newVersion);
        newVersion = newVersion + this.getGitFlow().getGitFlowPattern().getSuffixRelease();
        if (lastTag != null) {
            String lastTagVer = this.getGitFlow().getVersionFromTag(this.getGitFlow().findLastTag());
            if (this.getGitFlow().whatIsTheBigger(newVersion, lastTagVer) <= 0) {
                newVersion = this.getGitFlow().increaseVersionBasedOnTag(lastTag);
            }
        }
        if (this.getGitFlow().findBranch(this.getGitFlow().getGitFlowPattern().getDevelopName()) != null) {
            throw new MojoExecutionException("The branch develop already exists!");
        }
        this.getGitFlow().createBranch(this.getGitFlow().getGitFlowPattern().getDevelopName());
        this.updatePomVersion(newVersion);
        this.compileProject();
        Ref tag = this.getGitFlow().tag(newVersion, "[GitFlow::init] Create tag " + newVersion);
        this.getGitFlow().commit("[GitFlow::init] Bumped version number to " + newVersion);
        this.getGitFlow().push();
        this.getGitFlow().pushTag(tag);
        this.getLog().info((CharSequence)"Now your repository is ready to start a release");
    }

    @Override
    public void rollback(Exception e) throws MojoExecutionException {
        throw new MojoExecutionException("ERROR", e);
    }
}

