/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.mojo;

import com.codegik.gitflow.core.MergeGitFlow;
import com.codegik.gitflow.core.impl.DefaultBranchType;
import com.codegik.gitflow.core.impl.DefaultGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.merge.MergeStrategy;

@Mojo(name="publish-release", aggregator=true)
public class PublishReleaseMojo
extends DefaultGitFlowMojo {
    @Parameter(property="version", required=true)
    private String version;

    @Override
    public void run() throws Exception {
        this.validadeBefore();
        Ref tagRef = this.getGitFlow().findLastTag(this.getVersion());
        if (tagRef == null) {
            throw new MojoExecutionException("The release " + this.getVersion() + " was never finished, please execute finish-release goal before!");
        }
        this.getGitFlow().checkoutBranch(this.getGitFlow().getGitFlowPattern().getMasterName());
        MergeGitFlow mergeGitFlow = new MergeGitFlow();
        mergeGitFlow.setBranchName(this.getGitFlow().getGitFlowPattern().getMasterName());
        mergeGitFlow.setErrorMessage("publish-release -Dversion=" + this.getVersion());
        mergeGitFlow.setTargetRef(tagRef);
        mergeGitFlow.addIgnoringFiles(this.getGitFlow().getGitFlowPattern().getPomFileName());
        this.getGitFlow().merge(mergeGitFlow, MergeStrategy.THEIRS);
        this.compileProject();
        this.getGitFlow().push();
        this.getGitFlow().deleteRemoteBranch(this.getVersion(), DefaultBranchType.feature);
        this.getGitFlow().deleteRemoteBranch(this.getVersion(), DefaultBranchType.bugfix);
        this.getGitFlow().deleteRemoteBranch(this.getGitFlow().buildReleaseBranchName(this.getVersion()));
    }

    private void validadeBefore() throws Exception {
        this.getGitFlow().validadePatternReleaseVersion(this.getVersion());
    }

    @Override
    public void rollback(Exception e) throws MojoExecutionException {
        try {
            this.getLog().error((CharSequence)e.getMessage());
            this.getLog().info((CharSequence)"Rolling back all changes");
            this.getGitFlow().reset(this.getGitFlow().getGitFlowPattern().getMasterName());
            this.getGitFlow().checkoutBranchForced(this.getGitFlow().getGitFlowPattern().getMasterName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new MojoExecutionException("ERROR", e);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

