/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.mojo;

import com.codegik.gitflow.core.impl.DefaultGitFlowMojo;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start-development", aggregator=true)
public class StartDevelopmentMojo
extends DefaultGitFlowMojo {
    @Parameter(property="fullBranchName", required=true)
    private String fullBranchName;

    @Override
    public void run() throws Exception {
        Map<String, String> branchInfo = this.getGitFlow().validateFullBranchName(this.getFullBranchName());
        String version = branchInfo.get("version");
        this.getGitFlow().validadeReleaseVersion(version);
        if (this.getGitFlow().findBranch(this.getFullBranchName()) != null) {
            throw new MojoExecutionException("The branch " + this.getFullBranchName() + " already exists!");
        }
        this.compileProject();
        this.getGitFlow().checkoutBranch(this.getGitFlow().buildReleaseBranchName(version));
        this.getGitFlow().createBranch(this.getFullBranchName());
        this.getGitFlow().pushBranch(this.getFullBranchName());
    }

    @Override
    public void rollback(Exception e) throws MojoExecutionException {
        try {
            this.getLog().error((CharSequence)e.getMessage());
            this.getLog().info((CharSequence)"Rolling back all changes");
            this.getGitFlow().reset(this.getGitFlow().getGitFlowPattern().getDevelopName());
            this.getGitFlow().checkoutBranchForced(this.getGitFlow().getGitFlowPattern().getDevelopName());
            this.getGitFlow().deleteLocalBranch(this.getFullBranchName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new MojoExecutionException("ERROR", e);
    }

    public String getFullBranchName() {
        return this.fullBranchName;
    }

    public void setFullBranchName(String fullBranchName) {
        this.fullBranchName = fullBranchName;
    }
}

