/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.mojo;

import com.codegik.gitflow.core.impl.DefaultGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start-hotfix", aggregator=true)
public class StartHotfixMojo
extends DefaultGitFlowMojo {
    @Parameter(property="branchName", required=true)
    private String branchName;
    @Parameter(property="version")
    private String version;

    @Override
    public void run() throws Exception {
        String newVersion = null;
        if (this.getVersion() != null) {
            this.getGitFlow().validadePatternReleaseVersion(this.getVersion());
            newVersion = this.getVersion() + this.getGitFlow().getGitFlowPattern().getSuffixRelease();
        }
        this.setBranchName(this.getGitFlow().buildHotfixBranchName(this.getBranchName()));
        this.validadeBefore();
        this.getGitFlow().createBranch(this.getBranchName());
        if (newVersion == null) {
            newVersion = this.getGitFlow().increaseVersionBasedOnTag(this.getProject().getVersion());
        }
        this.updatePomVersion(newVersion);
        this.compileProject();
        this.getGitFlow().commit("[GitFlow::start-hotfix] Create hotfix branch " + this.getBranchName() + ": Bumped version number to " + newVersion);
        this.getGitFlow().pushBranch(this.getBranchName());
    }

    private void validadeBefore() throws Exception {
        if (!this.getGitFlow().getBranch().toLowerCase().equals(this.getGitFlow().getGitFlowPattern().getMasterName())) {
            throw new MojoExecutionException("You must be on branch master for execute this goal!");
        }
        if (this.getGitFlow().findBranch(this.getBranchName()) != null) {
            throw new MojoExecutionException("The branch " + this.getBranchName() + " already exists!");
        }
    }

    @Override
    public void rollback(Exception e) throws MojoExecutionException {
        try {
            this.getLog().error((CharSequence)e.getMessage());
            this.getLog().info((CharSequence)"Rollbacking all changes");
            this.getGitFlow().reset(this.getGitFlow().getGitFlowPattern().getMasterName());
            this.getGitFlow().checkoutBranchForced(this.getGitFlow().getGitFlowPattern().getMasterName());
            this.getGitFlow().deleteRemoteBranch(this.getBranchName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new MojoExecutionException("ERROR", e);
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

