/*
 * Decompiled with CFR 0.152.
 */
package com.codegik.gitflow.mojo;

import com.codegik.gitflow.core.impl.DefaultGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start-release", aggregator=true)
public class StartReleaseMojo
extends DefaultGitFlowMojo {
    private String branchName;
    @Parameter(property="version", required=true)
    private String version;

    @Override
    public void run() throws Exception {
        this.validadeBefore();
        this.setBranchName(this.getGitFlow().buildReleaseBranchName(this.getVersion()));
        this.getGitFlow().createBranch(this.getBranchName());
        String newVersion = this.getVersion();
        this.updatePomVersion(newVersion + this.getGitFlow().getGitFlowPattern().getSuffixRelease());
        this.compileProject();
        this.getGitFlow().commit("[GitFlow::start-release] Create release branch " + this.getBranchName() + ": Bumped version number to " + newVersion + this.getGitFlow().getGitFlowPattern().getSuffixRelease());
        this.getGitFlow().pushBranch(this.getBranchName());
    }

    private void validadeBefore() throws Exception {
        this.getGitFlow().validadePatternReleaseVersion(this.getVersion());
        if (this.getGitFlow().findBranch(this.getVersion()) != null) {
            throw new MojoExecutionException("The release " + this.getVersion() + " already exists!");
        }
        if (this.getGitFlow().findLastTag(this.getVersion()) != null) {
            throw new MojoExecutionException("The release " + this.getVersion() + " already existed!");
        }
        if (this.getGitFlow().findBranch(this.getGitFlow().getGitFlowPattern().getDevelopName()) == null) {
            throw new MojoExecutionException("Please run gitflow:init goal to initialize your repository!");
        }
        if (!this.getGitFlow().getBranch().equals(this.getGitFlow().getGitFlowPattern().getDevelopName())) {
            throw new MojoExecutionException("You must be on branch develop for execute this goal!");
        }
    }

    @Override
    public void rollback(Exception e) throws MojoExecutionException {
        try {
            this.getLog().error((CharSequence)e.getMessage());
            this.getLog().info((CharSequence)"Rolling back all changes");
            this.getGitFlow().reset(this.getGitFlow().getGitFlowPattern().getDevelopName());
            this.getGitFlow().checkoutBranchForced(this.getGitFlow().getGitFlowPattern().getDevelopName());
            this.getGitFlow().deleteLocalBranch(this.getBranchName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new MojoExecutionException("ERROR", e);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }
}

