/*
 * Decompiled with CFR 0.152.
 */
package com.codeheadsystems.test.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public abstract class BaseJacksonTest<T> {
    private static final Condition<Optional<?>> PRESENT = new Condition(Optional::isPresent, "isPresent", new Object[0]);
    protected static Set<String> methodsToIgnore;
    protected ObjectMapper objectMapper;
    protected String simpleName;

    @BeforeAll
    public static void findObjectMethods() {
        methodsToIgnore = Arrays.stream(Object.class.getDeclaredMethods()).map(Method::getName).collect(Collectors.toSet());
    }

    protected abstract Class<T> getBaseClass();

    protected abstract T getInstance();

    protected Optional<Class<?>> getPolymorphicBaseClass() {
        return Optional.empty();
    }

    protected ObjectMapper objectMapper() {
        return new ObjectMapper().registerModule((Module)new Jdk8Module());
    }

    @BeforeEach
    public void baseJacksonTestSetup() {
        this.objectMapper = this.objectMapper();
        this.simpleName = this.getBaseClass().getSimpleName();
    }

    @Test
    public void testRoundTrip() throws JsonProcessingException {
        T instance = this.getInstance();
        String json = this.objectMapper.writeValueAsString(instance);
        System.out.println(json);
        Object unwoundInstance = this.objectMapper.readValue(json, this.getBaseClass());
        ((ObjectAssert)Assertions.assertThat((Object)unwoundInstance).describedAs("Verification %s can go to json and back to an object," + json, new Object[]{this.simpleName})).isEqualTo(instance);
    }

    @Test
    public void testRoundTripWithExtraCharacters() throws JsonProcessingException {
        T instance = this.getInstance();
        String json = this.objectMapper.writeValueAsString(instance);
        ObjectNode objectNode = (ObjectNode)this.objectMapper.readValue(json, ObjectNode.class);
        objectNode.put("someWierdFieldWeDontCareAbout", "whatevervalue");
        String jsonWithExtraStuff = this.objectMapper.writeValueAsString((Object)objectNode);
        Object unwoundInstance = this.objectMapper.readValue(jsonWithExtraStuff, this.getBaseClass());
        ((ObjectAssert)Assertions.assertThat((Object)unwoundInstance).describedAs("Verification %s can go to json and back to an object with extra fields", new Object[]{this.simpleName})).isEqualTo(instance);
    }

    @Test
    public void testNotNullMethods() throws JsonProcessingException {
        String json = this.objectMapper.writeValueAsString(this.getInstance());
        for (Method method : this.getRequiredMethods()) {
            String reducedJson = this.getReducedJson(json, method);
            Throwable thrown = Assertions.catchThrowable(() -> this.objectMapper.readValue(reducedJson, this.getBaseClass()));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).describedAs("Throw test fail %s.%s()", new Object[]{this.simpleName, method.getName()})).isNotNull()).isInstanceOf(ValueInstantiationException.class)).hasMessageContaining("Cannot construct instance of");
        }
    }

    private String getReducedJson(String json, Method methodToRemove) throws JsonProcessingException {
        ObjectNode objectNode = (ObjectNode)this.objectMapper.readValue(json, ObjectNode.class);
        String methodName = methodToRemove.getName();
        JsonProperty annotation = methodToRemove.getAnnotation(JsonProperty.class);
        if (annotation != null && objectNode.findValue(annotation.value()) != null) {
            objectNode.remove(annotation.value());
        } else if (objectNode.findValue(methodName) != null) {
            objectNode.remove(methodName);
        } else {
            System.out.println("WARNING: Likely testing failure on notnull. No value seen to remove for method: " + methodName);
        }
        String reducedJson = this.objectMapper.writeValueAsString((Object)objectNode);
        return reducedJson;
    }

    @Test
    public void testNullableMethods() throws JsonProcessingException, InvocationTargetException, IllegalAccessException {
        T instance = this.getInstance();
        String json = this.objectMapper.writeValueAsString(instance);
        for (Method method : this.getNullableMethods()) {
            String methodName = method.getName();
            String reducedJson = this.getReducedJson(json, method);
            Object reducedInstance = this.objectMapper.readValue(reducedJson, this.getBaseClass());
            ((ObjectAssert)Assertions.assertThat(instance).describedAs("Expected object equality to fail when removing %s.%s", new Object[]{this.simpleName, methodName})).isNotEqualTo(reducedInstance);
            ((ObjectAssert)Assertions.assertThat((Object)method.invoke(instance, new Object[0])).describedAs("Setup fail %s.%s()", new Object[]{this.simpleName, methodName})).isNotNull();
            ((ObjectAssert)Assertions.assertThat((Object)method.invoke(reducedInstance, new Object[0])).describedAs("Method fail %s.%s()", new Object[]{this.simpleName, methodName})).isNull();
        }
    }

    @Test
    public void testCollectionMethods() throws JsonProcessingException, InvocationTargetException, IllegalAccessException {
        T instance = this.getInstance();
        String json = this.objectMapper.writeValueAsString(instance);
        for (Method method : this.getCollectionMethods()) {
            String methodName = method.getName();
            String reducedJson = this.getReducedJson(json, method);
            Object reducedInstance = this.objectMapper.readValue(reducedJson, this.getBaseClass());
            Assertions.assertThat(instance).isNotEqualTo(reducedInstance);
            ((IterableAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)method.invoke(instance, new Object[0])).describedAs("Setup fail %s.%s()", new Object[]{this.simpleName, methodName})).isNotNull()).asInstanceOf(InstanceOfAssertFactories.ITERABLE)).isNotEmpty();
            ((IterableAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)method.invoke(reducedInstance, new Object[0])).describedAs("Method fail %s.%s()", new Object[]{this.simpleName, methodName})).isNotNull()).asInstanceOf(InstanceOfAssertFactories.ITERABLE)).isEmpty();
        }
    }

    @Test
    public void testMapMethods() throws JsonProcessingException, InvocationTargetException, IllegalAccessException {
        T instance = this.getInstance();
        String json = this.objectMapper.writeValueAsString(instance);
        for (Method method : this.getMapMethods()) {
            String methodName = method.getName();
            String reducedJson = this.getReducedJson(json, method);
            Object reducedInstance = this.objectMapper.readValue(reducedJson, this.getBaseClass());
            Assertions.assertThat(instance).isNotEqualTo(reducedInstance);
            ((MapAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)method.invoke(instance, new Object[0])).describedAs("Setup fail %s.%s()", new Object[]{this.simpleName, methodName})).isNotNull()).asInstanceOf(InstanceOfAssertFactories.MAP)).isNotEmpty();
            ((MapAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)method.invoke(reducedInstance, new Object[0])).describedAs("Method fail %s.%s()", new Object[]{this.simpleName, methodName})).isNotNull()).asInstanceOf(InstanceOfAssertFactories.MAP)).isEmpty();
        }
    }

    @Test
    public void testOptionalMethods() throws JsonProcessingException, InvocationTargetException, IllegalAccessException {
        T instance = this.getInstance();
        String json = this.objectMapper.writeValueAsString(instance);
        for (Method method : this.getOptionalMethods()) {
            String methodName = method.getName();
            String reducedJson = this.getReducedJson(json, method);
            Object reducedInstance = this.objectMapper.readValue(reducedJson, this.getBaseClass());
            Assertions.assertThat(instance).isNotEqualTo(reducedInstance);
            Object instanceValue = method.invoke(instance, new Object[0]);
            Object reducedValue = method.invoke(reducedInstance, new Object[0]);
            ((OptionalAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)instanceValue).describedAs("Setup fail %s.%s()", new Object[]{this.simpleName, methodName})).isNotNull()).isInstanceOf(Optional.class)).asInstanceOf(InstanceOfAssertFactories.OPTIONAL)).is(PRESENT);
            ((OptionalAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)reducedValue).describedAs("Setup fail %s.%s()", new Object[]{this.simpleName, methodName})).isNotNull()).isInstanceOf(Optional.class)).asInstanceOf(InstanceOfAssertFactories.OPTIONAL)).isNot(PRESENT);
        }
    }

    @Test
    public void testPolymorphicBaseClass() throws JsonProcessingException {
        Optional<Class<?>> polymorphicBaseClass = this.getPolymorphicBaseClass();
        if (polymorphicBaseClass.isEmpty()) {
            return;
        }
        String json = this.objectMapper.writeValueAsString(this.getInstance());
        Object polymorphicObject = this.objectMapper.readValue(json, polymorphicBaseClass.get());
        ((ObjectAssert)Assertions.assertThat((Object)polymorphicObject).isNotNull()).isInstanceOf(this.getBaseClass());
    }

    List<Method> getClassMethods() {
        Class<T> clazz = this.getBaseClass();
        return Arrays.stream(clazz.getMethods()).filter(m -> !methodsToIgnore.contains(m.getName())).filter(m -> !Modifier.isStatic(m.getModifiers())).filter(m -> m.getParameterCount() == 0).filter(m -> !m.getReturnType().equals(Void.TYPE)).collect(Collectors.toList());
    }

    List<Method> getDefaultMethods() {
        return this.getClassMethods().stream().filter(m -> m.getDeclaredAnnotation(JsonIgnore.class) == null).filter(Method::isDefault).collect(Collectors.toList());
    }

    List<Method> getRequiredMethods() {
        return this.getClassMethods().stream().filter(m -> m.getDeclaredAnnotation(JsonIgnore.class) == null).filter(m -> m.getDeclaredAnnotation(Nullable.class) == null).filter(method -> !method.isDefault()).filter(m -> !m.getReturnType().equals(Optional.class)).filter(m -> !Collection.class.isAssignableFrom(m.getReturnType())).filter(m -> !Map.class.isAssignableFrom(m.getReturnType())).collect(Collectors.toList());
    }

    List<Method> getCollectionMethods() {
        return this.getClassMethods().stream().filter(m -> m.getDeclaredAnnotation(JsonIgnore.class) == null).filter(m -> Collection.class.isAssignableFrom(m.getReturnType())).collect(Collectors.toList());
    }

    List<Method> getMapMethods() {
        return this.getClassMethods().stream().filter(m -> m.getDeclaredAnnotation(JsonIgnore.class) == null).filter(m -> Map.class.isAssignableFrom(m.getReturnType())).collect(Collectors.toList());
    }

    List<Method> getNullableMethods() {
        return this.getClassMethods().stream().filter(m -> m.getDeclaredAnnotation(JsonIgnore.class) == null).filter(m -> m.getDeclaredAnnotation(Nullable.class) != null).collect(Collectors.toList());
    }

    List<Method> getOptionalMethods() {
        return this.getClassMethods().stream().filter(m -> m.getDeclaredAnnotation(JsonIgnore.class) == null).filter(m -> m.getReturnType().equals(Optional.class)).collect(Collectors.toList());
    }
}

