/*
 * Decompiled with CFR 0.152.
 */
package com.codeheadsystems.test.unique;

import com.codeheadsystems.test.unique.UniqueString;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class UniqueStringExtension
implements BeforeEachCallback,
BeforeAllCallback {
    public static final String ATOMIC = "atomic";
    protected final ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{UniqueStringExtension.class});

    public void beforeAll(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = context.getStore(this.namespace);
        store.put((Object)ATOMIC, (Object)new AtomicInteger(0));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = context.getStore(this.namespace);
        AtomicInteger atomic = (AtomicInteger)store.get((Object)ATOMIC, AtomicInteger.class);
        long currentTime = System.currentTimeMillis();
        int currentRun = atomic.incrementAndGet();
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.uniqueFields(instance.getClass()).forEach(field -> {
            this.enableSettingTheField((Field)field);
            UniqueString prefixAnnotation = field.getAnnotation(UniqueString.class);
            String sep = prefixAnnotation.separator();
            String value = prefixAnnotation.prefix() + sep + currentTime + sep + currentRun;
            this.setValueForField(value, instance, (Field)field);
        }));
    }

    public Set<Field> uniqueFields(Class<?> clazz) {
        HashSet<Field> set = new HashSet<Field>();
        while (clazz != Object.class) {
            Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.isAnnotationPresent(UniqueString.class)).forEach(set::add);
            clazz = clazz.getSuperclass();
        }
        return set;
    }

    protected void setValueForField(String value, Object object, Field field) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void enableSettingTheField(Field field) {
        try {
            field.setAccessible(true);
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }
}

