/*
 * Decompiled with CFR 0.152.
 */
package com.codeheadsystems.test.datastore;

import com.codeheadsystems.test.datastore.DataStore;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataStoreExtension
implements BeforeEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataStoreExtension.class);
    protected final ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{this.namespaceClass()});

    protected DataStoreExtension() {
        LOGGER.info("DataStoreExtension({})", (Object)this.namespace);
    }

    protected abstract Class<?> namespaceClass();

    protected void withStore(ExtensionContext context, Consumer<ExtensionContext.Store> consumer) {
        consumer.accept(context.getStore(this.namespace));
    }

    public void beforeEach(ExtensionContext context) {
        this.withStore(context, store -> context.getRequiredTestInstances().getAllInstances().forEach(o -> Arrays.stream(o.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(DataStore.class)).forEach(field -> this.setValueForField((ExtensionContext.Store)store, o, (Field)field))));
    }

    protected void setValueForField(ExtensionContext.Store store, Object o, Field field) {
        Object value = store.get(field.getType());
        if (value != null) {
            LOGGER.info("Setting field {}:{}", (Object)field.getName(), (Object)field.getType().getSimpleName());
            this.enableSettingTheField(field);
            try {
                field.set(o, value);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unable to set the field value for {}", (Object)field.getName(), (Object)e);
                LOGGER.error("Continuing, but expect nothing good will happen next.");
            }
        } else {
            LOGGER.error("Type {} is unknown to the DynamoDB extension. You have the annotation on the wrong field", field.getType());
            throw new IllegalArgumentException("Unable to find DynamoDB extension value of type " + String.valueOf(field.getType()));
        }
    }

    protected void enableSettingTheField(Field field) {
        try {
            field.setAccessible(true);
        }
        catch (RuntimeException re) {
            LOGGER.error("Unable to change accessibility for field due to private var or security manager: {}", (Object)field.getName());
            LOGGER.error("The setting will likely fail. Consider changing that type to protected.", (Throwable)re);
        }
    }
}

