/*
 * Decompiled with CFR 0.152.
 */
package com.codeheadsystems.test.datastore;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.local.main.ServerRunner;
import com.amazonaws.services.dynamodbv2.local.server.DynamoDBProxyServer;
import com.codeheadsystems.test.datastore.DataStore;
import com.codeheadsystems.test.datastore.DataStoreExtension;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

public class DynamoDbExtension
extends DataStoreExtension
implements BeforeAllCallback,
AfterAllCallback,
ParameterResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDbExtension.class);
    private static final Class<?> SERVER = DynamoDBProxyServer.class;
    private static final Class<?> CLIENT = AmazonDynamoDB.class;
    private static final Class<?> CLIENT2 = DynamoDbClient.class;
    private static final Class<?> MAPPER = DynamoDBMapper.class;

    @Override
    protected Class<?> namespaceClass() {
        return DynamoDbExtension.class;
    }

    public void afterAll(ExtensionContext context) {
        LOGGER.info("Tearing down in memory DynamoDB local instance");
        this.withStore(context, s -> {
            try {
                ((DynamoDBProxyServer)s.remove(SERVER, DynamoDBProxyServer.class)).stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            s.remove(CLIENT);
            s.remove(CLIENT2);
            s.remove(MAPPER);
        });
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        LOGGER.info("Setting in memory DynamoDB local instance");
        String port = "8000";
        DynamoDBProxyServer server = ServerRunner.createServerFromCommandLineArgs((String[])new String[]{"-inMemory", "-port", port});
        server.start();
        this.withStore(context, s -> {
            AmazonDynamoDB client = this.getAmazonDynamoDb();
            s.put(SERVER, (Object)server);
            s.put(CLIENT, (Object)client);
            s.put(CLIENT2, (Object)this.getDynamoDbClient());
            s.put(MAPPER, (Object)new DynamoDBMapper(client));
        });
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(DataStore.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return extensionContext.getStore(this.namespace).get(CLIENT);
    }

    private AmazonDynamoDB getAmazonDynamoDb() {
        BasicAWSCredentials credentials = new BasicAWSCredentials("one", "two");
        AWSStaticCredentialsProvider provider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        AwsClientBuilder.EndpointConfiguration configuration = new AwsClientBuilder.EndpointConfiguration("http://localhost:8000", "us-west-2");
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)provider)).withEndpointConfiguration(configuration)).build();
    }

    private DynamoDbClient getDynamoDbClient() {
        AwsBasicCredentials credentials = AwsBasicCredentials.create((String)"one", (String)"two");
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
        try {
            return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.US_EAST_1)).endpointOverride(new URI("http://localhost:8000"))).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Should not have happened given the hardcoded url", e);
        }
    }
}

