/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.packets.ReturnOpenOrders;
import com.cml.idex.util.Utils;
import com.cml.idex.value.Order;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

public class PlaceOrder
implements Req,
Parser<Order> {
    final String tokenBuy;
    final BigInteger amountBuy;
    final String tokenSell;
    final BigInteger amountSell;
    final String address;
    final long nonce;
    final long expires;
    final byte v;
    final byte[] r;
    final byte[] s;

    private PlaceOrder(String tokenBuy, BigInteger amountBuy, String tokenSell, BigInteger amountSell, String address, long nonce, long expires, byte v, byte[] r, byte[] s) {
        this.tokenBuy = tokenBuy;
        this.amountBuy = amountBuy;
        this.tokenSell = tokenSell;
        this.amountSell = amountSell;
        this.address = address;
        this.nonce = nonce;
        this.expires = expires;
        this.v = v;
        this.r = r;
        this.s = s;
    }

    @Override
    public String getEndpoint() {
        return "order";
    }

    @Override
    public String getPayload() {
        String val = "{\"tokenBuy\": \"" + this.tokenBuy + "\", \"amountBuy\": \"" + this.amountBuy + "\", \"tokenSell\": \"" + this.tokenSell + "\", \"amountSell\": \"" + this.amountSell + "\", \"address\": \"" + this.address + "\", \"nonce\": \"" + this.nonce + "\", \"expires\": " + this.expires + ", \"v\": " + this.v + ", \"r\": \"" + Numeric.toHexString((byte[])this.r) + "\", \"s\": \"" + Numeric.toHexString((byte[])this.s) + "\"}";
        return val;
    }

    @Override
    public Order parse(ObjectMapper mapper, String body) {
        if (Utils.isEmptyJson(body)) {
            throw new IDexException(ErrorCode.ORDER_FAILED, body);
        }
        return PlaceOrder.fromJson(mapper, body);
    }

    public static PlaceOrder create(String tokenBuy, BigInteger amountBuy, String tokenSell, BigInteger amountSell, String address, Long nonce, Long expires, byte v, byte[] r, byte[] s) {
        return new PlaceOrder(tokenBuy, amountBuy, tokenSell, amountSell, address, nonce, expires, v, r, s);
    }

    public static Order fromJson(ObjectMapper mapper, String body) {
        try {
            JsonNode root = mapper.readTree(body);
            Utils.checkError(root);
            if (root.get("orderNumber") == null) {
                throw new IDexException(ErrorCode.ORDER_FAILED, body);
            }
            return ReturnOpenOrders.parseOrder(root);
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }
}

