/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.util;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class Utils {
    public static final DateTimeFormatter DT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private Utils() {
    }

    public static final LocalDateTime parseDate(JsonNode node, String fieldName) {
        return LocalDateTime.parse(node.get(fieldName).asText(), DT_FORMATTER);
    }

    public static final void checkError(JsonNode root) {
        if (root.get("error") != null) {
            throw new IDexException(ErrorCode.GENERIC, root.get("error").asText());
        }
    }

    public static final boolean isEmptyJson(String json) {
        return json == null || json.length() < 3;
    }

    public static final BigDecimal toBD(JsonNode node, String fieldName) {
        if (node.get(fieldName) == null) {
            return null;
        }
        return Utils.toBD(node.get(fieldName).asText());
    }

    public static final BigDecimal toBDrequired(JsonNode node, String fieldName) {
        return Utils.toBD(node.get(fieldName).asText());
    }

    public static final BigDecimal toBD(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException numberFormatException) {
            if ("N/A".equalsIgnoreCase(value)) {
                return null;
            }
            throw new NumberFormatException(value);
        }
    }

    public static boolean isValidEthAddress(byte[] addr) {
        return addr != null && addr.length == 20;
    }

    public static Long toEpochSecond(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        return dateTime.atZone(zoneId).toEpochSecond();
    }

    public static final String fixString(String inputStr) {
        if (inputStr == null) {
            return null;
        }
        String fixedStr = inputStr.trim();
        if (fixedStr.isEmpty()) {
            return null;
        }
        return fixedStr;
    }

    public static void prettyPrint(ObjectMapper mapper, String body) {
        try {
            Object json = mapper.readValue(body, Object.class);
            System.out.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

