/*
 * Decompiled with CFR 0.152.
 */
package com.cml.idex.packets;

import com.cml.idex.ErrorCode;
import com.cml.idex.IDexException;
import com.cml.idex.packets.Parser;
import com.cml.idex.packets.Req;
import com.cml.idex.packets.SortOrder;
import com.cml.idex.util.Utils;
import com.cml.idex.value.TradeHistory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ReturnTradeHistory
implements Req,
Parser<List<TradeHistory>> {
    private final String market;
    private final String address;
    private final Long start;
    private final Long end;
    private final SortOrder sort;
    private final Integer count;
    private final String cursor;

    private ReturnTradeHistory(String market, String address, Long start, Long end, SortOrder sort, Integer count, String cursor) {
        this.market = market;
        this.address = address;
        this.start = start;
        this.end = end;
        this.sort = sort;
        this.count = count;
        this.cursor = cursor;
    }

    @Override
    public String getEndpoint() {
        return "returnTradeHistory";
    }

    @Override
    public String getPayload() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.market != null) {
            sb.append("\"market\":\"").append(this.market).append("\"");
        }
        if (this.address != null) {
            if (this.market != null) {
                sb.append(",");
            }
            sb.append("\"address\":\"").append(this.address).append("\"");
        }
        if (this.start != null) {
            sb.append(",\"start\":").append(this.start);
        }
        if (this.end != null) {
            sb.append(",\"end\":").append(this.end);
        }
        if (this.sort != null) {
            sb.append(",\"sort\": \"").append(this.sort.getValue()).append("\"");
        }
        if (this.count != null) {
            sb.append(",\"count\":").append(this.count);
        }
        if (this.cursor != null) {
            sb.append(",\"cursor\": \"").append(this.cursor).append("\"");
        }
        return sb.append("}").toString();
    }

    @Override
    public List<TradeHistory> parse(ObjectMapper mapper, String json) {
        if (Utils.isEmptyJson(json)) {
            return Collections.emptyList();
        }
        return ReturnTradeHistory.fromJson(mapper, json);
    }

    public static ReturnTradeHistory create(String market, String address, Long start, Long end, SortOrder sort, Integer count, String cursor) {
        String marketFixed = Utils.fixString(market);
        String adrFixed = Utils.fixString(address);
        if (marketFixed == null && adrFixed == null) {
            throw new IllegalArgumentException("market or address is requried!");
        }
        if (count != null && (count < 1 || count > 100)) {
            throw new IllegalArgumentException("count must be between 1 and 100 OR null value");
        }
        return new ReturnTradeHistory(marketFixed, address, start, end, sort, count, cursor);
    }

    private static List<TradeHistory> fromJson(ObjectMapper mapper, String json) {
        try {
            JsonNode root = mapper.readTree(json);
            Utils.checkError(root);
            LinkedList<TradeHistory> trades = new LinkedList<TradeHistory>();
            Iterator eleItr = root.elements();
            while (eleItr.hasNext()) {
                trades.add(ReturnTradeHistory.parseTradeHistory((JsonNode)eleItr.next()));
            }
            return trades;
        }
        catch (Exception e1) {
            throw new IDexException(ErrorCode.RESPONSE_PARSE_FAILED, e1.getLocalizedMessage(), e1);
        }
    }

    private static TradeHistory parseTradeHistory(JsonNode node) {
        LocalDateTime date = Utils.parseDate(node, "date");
        BigDecimal amount = Utils.toBDrequired(node, "amount");
        String type = node.get("type").asText();
        BigDecimal total = Utils.toBDrequired(node, "total");
        BigDecimal price = Utils.toBDrequired(node, "price");
        String orderHash = node.get("orderHash").asText();
        String uuid = node.get("uuid").asText();
        Long tid = node.get("tid").asLong();
        BigDecimal buyerFee = Utils.toBDrequired(node, "buyerFee");
        BigDecimal sellerFee = Utils.toBDrequired(node, "sellerFee");
        BigDecimal gasFee = Utils.toBDrequired(node, "gasFee");
        Long timestamp = node.get("timestamp").asLong();
        String maker = node.get("maker").asText();
        String taker = node.get("taker").asText();
        String tokenBuy = node.get("tokenBuy").asText();
        String tokenSell = node.get("tokenSell").asText();
        String transactionHash = node.get("transactionHash").asText();
        String usdValue = node.get("usdValue").asText();
        return new TradeHistory(date, amount, type, total, price, orderHash, uuid, tid, buyerFee, sellerFee, gasFee, timestamp, maker, taker, tokenBuy, tokenSell, transactionHash, usdValue);
    }
}

