/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E> {
    transient int size = 0;
    transient Link<E> voidLink = new Link<Object>(null, null, null);

    public LinkedList() {
        this.voidLink.previous = this.voidLink;
        this.voidLink.next = this.voidLink;
    }

    public LinkedList(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public void add(int location, E object) {
        if (0 <= location && location <= this.size) {
            int i;
            Link<Object> link = this.voidLink;
            if (location < this.size / 2) {
                for (i = 0; i <= location; ++i) {
                    link = link.next;
                }
            } else {
                for (i = this.size; i > location; --i) {
                    link = link.previous;
                }
            }
            Link previous = link.previous;
            Link<E> newLink = new Link<E>(object, previous, link);
            previous.next = newLink;
            link.previous = newLink;
            ++this.size;
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean add(E object) {
        return this.addLastImpl(object);
    }

    private boolean addLastImpl(E object) {
        Link oldLast = this.voidLink.previous;
        Link<E> newLink = new Link<E>(object, oldLast, this.voidLink);
        this.voidLink.previous = newLink;
        oldLast.next = newLink;
        ++this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(int location, Collection<? extends E> collection) {
        int i;
        if (location < 0 || location > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int adding = collection.size();
        if (adding == 0) {
            return false;
        }
        ArrayList elements = collection == this ? new ArrayList(collection) : collection;
        Link<Object> previous = this.voidLink;
        if (location < this.size / 2) {
            for (i = 0; i < location; ++i) {
                previous = previous.next;
            }
        } else {
            for (i = this.size; i >= location; --i) {
                previous = previous.previous;
            }
        }
        Link next = previous.next;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Link newLink = new Link(it.next(), previous, null);
            previous.next = newLink;
            previous = newLink;
        }
        previous.next = next;
        next.previous = previous;
        this.size += adding;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int adding = collection.size();
        if (adding == 0) {
            return false;
        }
        ArrayList elements = collection == this ? new ArrayList(collection) : collection;
        Link<Object> previous = this.voidLink.previous;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Link newLink = new Link(it.next(), previous, null);
            previous.next = newLink;
            previous = newLink;
        }
        previous.next = this.voidLink;
        this.voidLink.previous = previous;
        this.size += adding;
        ++this.modCount;
        return true;
    }

    @Override
    public void addFirst(E object) {
        this.addFirstImpl(object);
    }

    private boolean addFirstImpl(E object) {
        Link oldFirst = this.voidLink.next;
        Link<E> newLink = new Link<E>(object, this.voidLink, oldFirst);
        this.voidLink.next = newLink;
        oldFirst.previous = newLink;
        ++this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public void addLast(E object) {
        this.addLastImpl(object);
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            this.size = 0;
            this.voidLink.next = this.voidLink;
            this.voidLink.previous = this.voidLink;
            ++this.modCount;
        }
    }

    @Override
    public boolean contains(Object object) {
        Link link = this.voidLink.next;
        if (object != null) {
            while (link != this.voidLink) {
                if (object.equals(link.data)) {
                    return true;
                }
                link = link.next;
            }
        } else {
            while (link != this.voidLink) {
                if (link.data == null) {
                    return true;
                }
                link = link.next;
            }
        }
        return false;
    }

    @Override
    public E get(int location) {
        if (0 <= location && location < this.size) {
            Link<Object> link = this.voidLink;
            if (location < this.size / 2) {
                for (int i = 0; i <= location; ++i) {
                    link = link.next;
                }
            } else {
                for (int i = this.size; i > location; --i) {
                    link = link.previous;
                }
            }
            return (E)link.data;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public E getFirst() {
        return this.getFirstImpl();
    }

    private E getFirstImpl() {
        Link first = this.voidLink.next;
        if (first != this.voidLink) {
            return (E)first.data;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E getLast() {
        Link last = this.voidLink.previous;
        if (last != this.voidLink) {
            return (E)last.data;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int indexOf(Object object) {
        int pos = 0;
        Link link = this.voidLink.next;
        if (object != null) {
            while (link != this.voidLink) {
                if (object.equals(link.data)) {
                    return pos;
                }
                link = link.next;
                ++pos;
            }
        } else {
            while (link != this.voidLink) {
                if (link.data == null) {
                    return pos;
                }
                link = link.next;
                ++pos;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int pos = this.size;
        Link link = this.voidLink.previous;
        if (object != null) {
            while (link != this.voidLink) {
                --pos;
                if (object.equals(link.data)) {
                    return pos;
                }
                link = link.previous;
            }
        } else {
            while (link != this.voidLink) {
                --pos;
                if (link.data == null) {
                    return pos;
                }
                link = link.previous;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        return new LinkIterator(this, location);
    }

    @Override
    public E remove(int location) {
        if (0 <= location && location < this.size) {
            Link next;
            int i;
            Link<Object> link = this.voidLink;
            if (location < this.size / 2) {
                for (i = 0; i <= location; ++i) {
                    link = link.next;
                }
            } else {
                for (i = this.size; i > location; --i) {
                    link = link.previous;
                }
            }
            Link previous = link.previous;
            previous.next = next = link.next;
            next.previous = previous;
            --this.size;
            ++this.modCount;
            return (E)link.data;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrenceImpl(object);
    }

    @Override
    public E removeFirst() {
        return this.removeFirstImpl();
    }

    private E removeFirstImpl() {
        Link first = this.voidLink.next;
        if (first != this.voidLink) {
            Link next;
            this.voidLink.next = next = first.next;
            next.previous = this.voidLink;
            --this.size;
            ++this.modCount;
            return (E)first.data;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E removeLast() {
        return this.removeLastImpl();
    }

    private E removeLastImpl() {
        Link last = this.voidLink.previous;
        if (last != this.voidLink) {
            Link previous;
            this.voidLink.previous = previous = last.previous;
            previous.next = this.voidLink;
            --this.size;
            ++this.modCount;
            return (E)last.data;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new ReverseLinkIterator(this);
    }

    @Override
    public boolean offerFirst(E e) {
        return this.addFirstImpl(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.addLastImpl(e);
    }

    @Override
    public E peekFirst() {
        return this.peekFirstImpl();
    }

    @Override
    public E peekLast() {
        Link last = this.voidLink.previous;
        return last == this.voidLink ? null : (E)last.data;
    }

    @Override
    public E pollFirst() {
        return this.size == 0 ? null : (E)this.removeFirstImpl();
    }

    @Override
    public E pollLast() {
        return this.size == 0 ? null : (E)this.removeLastImpl();
    }

    @Override
    public E pop() {
        return this.removeFirstImpl();
    }

    @Override
    public void push(E e) {
        this.addFirstImpl(e);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.removeFirstOccurrenceImpl(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        ReverseLinkIterator iter = new ReverseLinkIterator(this);
        return this.removeOneOccurrence(o, iter);
    }

    private boolean removeFirstOccurrenceImpl(Object o) {
        LinkIterator iter = new LinkIterator(this, 0);
        return this.removeOneOccurrence(o, iter);
    }

    private boolean removeOneOccurrence(Object o, Iterator<E> iter) {
        while (iter.hasNext()) {
            E element = iter.next();
            if (!(o == null ? element == null : o.equals(element))) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public E set(int location, E object) {
        if (0 <= location && location < this.size) {
            int i;
            Link<Object> link = this.voidLink;
            if (location < this.size / 2) {
                for (i = 0; i <= location; ++i) {
                    link = link.next;
                }
            } else {
                for (i = this.size; i > location; --i) {
                    link = link.previous;
                }
            }
            Object result = link.data;
            link.data = object;
            return (E)result;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean offer(E o) {
        return this.addLastImpl(o);
    }

    @Override
    public E poll() {
        return this.size == 0 ? null : (E)this.removeFirst();
    }

    @Override
    public E remove() {
        return this.removeFirstImpl();
    }

    @Override
    public E peek() {
        return this.peekFirstImpl();
    }

    private E peekFirstImpl() {
        Link first = this.voidLink.next;
        return first == this.voidLink ? null : (E)first.data;
    }

    @Override
    public E element() {
        return this.getFirstImpl();
    }

    @Override
    public Object[] toArray() {
        int index = 0;
        Object[] contents = new Object[this.size];
        Link link = this.voidLink.next;
        while (link != this.voidLink) {
            contents[index++] = link.data;
            link = link.next;
        }
        return contents;
    }

    @Override
    public <T> T[] toArray(T[] contents) {
        int index = 0;
        if (this.size > contents.length) {
            return null;
        }
        Link link = this.voidLink.next;
        while (link != this.voidLink) {
            contents[index++] = link.data;
            link = link.next;
        }
        if (index < contents.length) {
            contents[index] = null;
        }
        return contents;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Link<ET> {
        ET data;
        Link<ET> previous;
        Link<ET> next;

        Link(ET o, Link<ET> p, Link<ET> n) {
            this.data = o;
            this.previous = p;
            this.next = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LinkIterator<ET>
    implements ListIterator<ET> {
        int pos;
        int expectedModCount;
        final LinkedList<ET> list;
        Link<ET> link;
        Link<ET> lastLink;

        LinkIterator(LinkedList<ET> object, int location) {
            this.list = object;
            this.expectedModCount = this.list.modCount;
            if (0 <= location && location <= this.list.size) {
                this.link = this.list.voidLink;
                if (location < this.list.size / 2) {
                    this.pos = -1;
                    while (this.pos + 1 < location) {
                        this.link = this.link.next;
                        ++this.pos;
                    }
                } else {
                    this.pos = this.list.size;
                    while (this.pos >= location) {
                        this.link = this.link.previous;
                        --this.pos;
                    }
                }
            } else {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void add(ET object) {
            if (this.expectedModCount == this.list.modCount) {
                Link next = this.link.next;
                Link<ET> newLink = new Link<ET>(object, this.link, next);
                this.link.next = newLink;
                next.previous = newLink;
                this.link = newLink;
                this.lastLink = null;
                ++this.pos;
                ++this.expectedModCount;
                ++this.list.size;
                ++this.list.modCount;
            } else {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.link.next != this.list.voidLink;
        }

        @Override
        public boolean hasPrevious() {
            return this.link != this.list.voidLink;
        }

        @Override
        public ET next() {
            if (this.expectedModCount == this.list.modCount) {
                Link next = this.link.next;
                if (next != this.list.voidLink) {
                    this.link = next;
                    this.lastLink = this.link;
                    ++this.pos;
                    return this.link.data;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int nextIndex() {
            return this.pos + 1;
        }

        @Override
        public ET previous() {
            if (this.expectedModCount == this.list.modCount) {
                if (this.link != this.list.voidLink) {
                    this.lastLink = this.link;
                    this.link = this.link.previous;
                    --this.pos;
                    return this.lastLink.data;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int previousIndex() {
            return this.pos;
        }

        @Override
        public void remove() {
            if (this.expectedModCount == this.list.modCount) {
                if (this.lastLink != null) {
                    Link previous;
                    Link next = this.lastLink.next;
                    next.previous = previous = this.lastLink.previous;
                    previous.next = next;
                    if (this.lastLink == this.link) {
                        --this.pos;
                    }
                    this.link = previous;
                    this.lastLink = null;
                    ++this.expectedModCount;
                    --this.list.size;
                    ++this.list.modCount;
                    return;
                }
                throw new IllegalStateException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public void set(ET object) {
            if (this.expectedModCount == this.list.modCount) {
                if (this.lastLink == null) {
                    throw new IllegalStateException();
                }
            } else {
                throw new ConcurrentModificationException();
            }
            this.lastLink.data = object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReverseLinkIterator<ET>
    implements Iterator<ET> {
        private int expectedModCount;
        private final LinkedList<ET> list;
        private Link<ET> link;
        private boolean canRemove;

        ReverseLinkIterator(LinkedList<ET> linkedList2) {
            this.list = linkedList2;
            this.expectedModCount = this.list.modCount;
            this.link = this.list.voidLink;
            this.canRemove = false;
        }

        @Override
        public boolean hasNext() {
            return this.link.previous != this.list.voidLink;
        }

        @Override
        public ET next() {
            if (this.expectedModCount == this.list.modCount) {
                if (this.hasNext()) {
                    this.link = this.link.previous;
                    this.canRemove = true;
                    return this.link.data;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount == this.list.modCount) {
                if (this.canRemove) {
                    Link previous;
                    Link next = this.link.previous;
                    next.next = previous = this.link.next;
                    previous.previous = next;
                    this.link = previous;
                    --this.list.size;
                    ++this.list.modCount;
                    ++this.expectedModCount;
                    this.canRemove = false;
                    return;
                }
                throw new IllegalStateException();
            }
            throw new ConcurrentModificationException();
        }
    }
}

