/*
 * Decompiled with CFR 0.152.
 */
package java.util;

public class BitSet {
    private static final int OFFSET = 6;
    private static final int ELM_SIZE = 64;
    private static final int RIGHT_BITS = 63;
    private static final long[] TWO_N_ARRAY = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    private long[] bits;
    private transient boolean needClear;
    private transient int actualArrayLength;
    private transient boolean isLengthActual;

    public BitSet() {
        this.bits = new long[1];
        this.actualArrayLength = 0;
        this.isLengthActual = true;
    }

    public BitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException();
        }
        this.bits = new long[(nbits >> 6) + ((nbits & 0x3F) > 0 ? 1 : 0)];
        this.actualArrayLength = 0;
        this.isLengthActual = true;
    }

    private BitSet(long[] bits, boolean needClear, int actualArrayLength, boolean isLengthActual) {
        this.bits = bits;
        this.needClear = needClear;
        this.actualArrayLength = actualArrayLength;
        this.isLengthActual = isLengthActual;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BitSet) {
            long[] bsBits = ((BitSet)obj).bits;
            int length1 = this.actualArrayLength;
            int length2 = ((BitSet)obj).actualArrayLength;
            if (this.isLengthActual && ((BitSet)obj).isLengthActual && length1 != length2) {
                return false;
            }
            if (length1 <= length2) {
                int i;
                for (i = 0; i < length1; ++i) {
                    if (this.bits[i] == bsBits[i]) continue;
                    return false;
                }
                for (i = length1; i < length2; ++i) {
                    if (bsBits[i] == 0L) continue;
                    return false;
                }
            } else {
                int i;
                for (i = 0; i < length2; ++i) {
                    if (this.bits[i] == bsBits[i]) continue;
                    return false;
                }
                for (i = length2; i < length1; ++i) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private final void growLength(int len) {
        long[] tempBits = new long[Math.max(len, this.bits.length * 2)];
        System.arraycopy(this.bits, 0, tempBits, 0, this.actualArrayLength);
        this.bits = tempBits;
    }

    public int hashCode() {
        long x = 1234L;
        int length = this.actualArrayLength;
        for (int i = 0; i < length; ++i) {
            x ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(x >> 32 ^ x);
    }

    public boolean get(int pos) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + pos);
        }
        int arrayPos = pos >> 6;
        if (arrayPos < this.actualArrayLength) {
            return (this.bits[arrayPos] & TWO_N_ARRAY[pos & 0x3F]) != 0L;
        }
        return false;
    }

    public BitSet get(int pos1, int pos2) {
        if (pos1 < 0 || pos2 < 0 || pos2 < pos1) {
            throw new IndexOutOfBoundsException("" + pos1 + " and: " + pos2);
        }
        int last = this.actualArrayLength << 6;
        if (pos1 >= last || pos1 == pos2) {
            return new BitSet(0);
        }
        if (pos2 > last) {
            pos2 = last;
        }
        int idx1 = pos1 >> 6;
        int idx2 = pos2 - 1 >> 6;
        long factor1 = -1L << (pos1 & 0x3F);
        long factor2 = -1L >>> 64 - (pos2 & 0x3F);
        if (idx1 == idx2) {
            long result = (this.bits[idx1] & (factor1 & factor2)) >>> pos1 % 64;
            if (result == 0L) {
                return new BitSet(0);
            }
            return new BitSet(new long[]{result}, this.needClear, 1, true);
        }
        long[] newbits = new long[idx2 - idx1 + 1];
        newbits[0] = this.bits[idx1] & factor1;
        newbits[newbits.length - 1] = this.bits[idx2] & factor2;
        for (int i = 1; i < idx2 - idx1; ++i) {
            newbits[i] = this.bits[idx1 + i];
        }
        int numBitsToShift = pos1 & 0x3F;
        int actualLen = newbits.length;
        if (numBitsToShift != 0) {
            for (int i = 0; i < newbits.length; ++i) {
                newbits[i] = newbits[i] >>> numBitsToShift;
                if (i != newbits.length - 1) {
                    int n = i;
                    newbits[n] = newbits[n] | newbits[i + 1] << 64 - numBitsToShift;
                }
                if (newbits[i] == 0L) continue;
                actualLen = i + 1;
            }
        }
        return new BitSet(newbits, this.needClear, actualLen, newbits[actualLen - 1] != 0L);
    }

    public void set(int pos) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException("" + pos);
        }
        int len = (pos >> 6) + 1;
        if (len > this.bits.length) {
            this.growLength(len);
        }
        int n = len - 1;
        this.bits[n] = this.bits[n] | TWO_N_ARRAY[pos & 0x3F];
        if (len > this.actualArrayLength) {
            this.actualArrayLength = len;
            this.isLengthActual = true;
        }
        this.needClear();
    }

    public void set(int pos, boolean val) {
        if (val) {
            this.set(pos);
        } else {
            this.clear(pos);
        }
    }

    public void set(int pos1, int pos2) {
        if (pos1 < 0 || pos2 < 0 || pos2 < pos1) {
            throw new IndexOutOfBoundsException("" + pos1 + " and: " + pos2);
        }
        if (pos1 == pos2) {
            return;
        }
        int len2 = (pos2 - 1 >> 6) + 1;
        if (len2 > this.bits.length) {
            this.growLength(len2);
        }
        int idx1 = pos1 >> 6;
        int idx2 = pos2 - 1 >> 6;
        long factor1 = -1L << (pos1 & 0x3F);
        long factor2 = -1L >>> 64 - (pos2 & 0x3F);
        if (idx1 == idx2) {
            int n = idx1;
            this.bits[n] = this.bits[n] | factor1 & factor2;
        } else {
            int n = idx1;
            this.bits[n] = this.bits[n] | factor1;
            int n2 = idx2;
            this.bits[n2] = this.bits[n2] | factor2;
            int i = idx1 + 1;
            while (i < idx2) {
                int n3 = i++;
                this.bits[n3] = this.bits[n3] | 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (idx2 + 1 > this.actualArrayLength) {
            this.actualArrayLength = idx2 + 1;
            this.isLengthActual = true;
        }
        this.needClear();
    }

    private void needClear() {
        this.needClear = true;
    }

    public void set(int pos1, int pos2, boolean val) {
        if (val) {
            this.set(pos1, pos2);
        } else {
            this.clear(pos1, pos2);
        }
    }

    public void clear() {
        if (this.needClear) {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
            this.actualArrayLength = 0;
            this.isLengthActual = true;
            this.needClear = false;
        }
    }

    public void clear(int pos) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException("" + pos);
        }
        if (!this.needClear) {
            return;
        }
        int arrayPos = pos >> 6;
        if (arrayPos < this.actualArrayLength) {
            int n = arrayPos;
            this.bits[n] = this.bits[n] & (TWO_N_ARRAY[pos & 0x3F] ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.bits[this.actualArrayLength - 1] == 0L) {
                this.isLengthActual = false;
            }
        }
    }

    public void clear(int pos1, int pos2) {
        if (pos1 < 0 || pos2 < 0 || pos2 < pos1) {
            throw new IndexOutOfBoundsException("" + pos1 + " and: " + pos2);
        }
        if (!this.needClear) {
            return;
        }
        int last = this.actualArrayLength << 6;
        if (pos1 >= last || pos1 == pos2) {
            return;
        }
        if (pos2 > last) {
            pos2 = last;
        }
        int idx1 = pos1 >> 6;
        int idx2 = pos2 - 1 >> 6;
        long factor1 = -1L << (pos1 & 0x3F);
        long factor2 = -1L >>> 64 - (pos2 & 0x3F);
        if (idx1 == idx2) {
            int n = idx1;
            this.bits[n] = this.bits[n] & (factor1 & factor2 ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int n = idx1;
            this.bits[n] = this.bits[n] & (factor1 ^ 0xFFFFFFFFFFFFFFFFL);
            int n2 = idx2;
            this.bits[n2] = this.bits[n2] & (factor2 ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = idx1 + 1; i < idx2; ++i) {
                this.bits[i] = 0L;
            }
        }
        if (this.actualArrayLength > 0 && this.bits[this.actualArrayLength - 1] == 0L) {
            this.isLengthActual = false;
        }
    }

    public void flip(int pos) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException("" + pos);
        }
        int len = (pos >> 6) + 1;
        if (len > this.bits.length) {
            this.growLength(len);
        }
        int n = len - 1;
        this.bits[n] = this.bits[n] ^ TWO_N_ARRAY[pos & 0x3F];
        if (len > this.actualArrayLength) {
            this.actualArrayLength = len;
        }
        this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
        this.needClear();
    }

    public void flip(int pos1, int pos2) {
        if (pos1 < 0 || pos2 < 0 || pos2 < pos1) {
            throw new IndexOutOfBoundsException("" + pos1 + " and: " + pos2);
        }
        if (pos1 == pos2) {
            return;
        }
        int len2 = (pos2 - 1 >> 6) + 1;
        if (len2 > this.bits.length) {
            this.growLength(len2);
        }
        int idx1 = pos1 >> 6;
        int idx2 = pos2 - 1 >> 6;
        long factor1 = -1L << (pos1 & 0x3F);
        long factor2 = -1L >>> 64 - (pos2 & 0x3F);
        if (idx1 == idx2) {
            int n = idx1;
            this.bits[n] = this.bits[n] ^ factor1 & factor2;
        } else {
            int n = idx1;
            this.bits[n] = this.bits[n] ^ factor1;
            int n2 = idx2;
            this.bits[n2] = this.bits[n2] ^ factor2;
            int i = idx1 + 1;
            while (i < idx2) {
                int n3 = i++;
                this.bits[n3] = this.bits[n3] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (len2 > this.actualArrayLength) {
            this.actualArrayLength = len2;
        }
        this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
        this.needClear();
    }

    public boolean intersects(BitSet bs) {
        long[] bsBits = bs.bits;
        int length1 = this.actualArrayLength;
        int length2 = bs.actualArrayLength;
        if (length1 <= length2) {
            for (int i = 0; i < length1; ++i) {
                if ((this.bits[i] & bsBits[i]) == 0L) continue;
                return true;
            }
        } else {
            for (int i = 0; i < length2; ++i) {
                if ((this.bits[i] & bsBits[i]) == 0L) continue;
                return true;
            }
        }
        return false;
    }

    public void and(BitSet bs) {
        long[] bsBits = bs.bits;
        if (!this.needClear) {
            return;
        }
        int length1 = this.actualArrayLength;
        int length2 = bs.actualArrayLength;
        if (length1 <= length2) {
            for (int i = 0; i < length1; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & bsBits[i];
            }
        } else {
            int i;
            for (i = 0; i < length2; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & bsBits[i];
            }
            for (i = length2; i < length1; ++i) {
                this.bits[i] = 0L;
            }
            this.actualArrayLength = length2;
        }
        this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
    }

    public void andNot(BitSet bs) {
        long[] bsBits = bs.bits;
        if (!this.needClear) {
            return;
        }
        int range = this.actualArrayLength < bs.actualArrayLength ? this.actualArrayLength : bs.actualArrayLength;
        for (int i = 0; i < range; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (bsBits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.actualArrayLength < range) {
            this.actualArrayLength = range;
        }
        this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
    }

    public void or(BitSet bs) {
        int bsActualLen = bs.getActualArrayLength();
        if (bsActualLen > this.bits.length) {
            long[] tempBits = new long[bsActualLen];
            System.arraycopy(bs.bits, 0, tempBits, 0, bs.actualArrayLength);
            for (int i = 0; i < this.actualArrayLength; ++i) {
                int n = i;
                tempBits[n] = tempBits[n] | this.bits[i];
            }
            this.bits = tempBits;
            this.actualArrayLength = bsActualLen;
            this.isLengthActual = true;
        } else {
            long[] bsBits = bs.bits;
            for (int i = 0; i < bsActualLen; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] | bsBits[i];
            }
            if (bsActualLen > this.actualArrayLength) {
                this.actualArrayLength = bsActualLen;
                this.isLengthActual = true;
            }
        }
        this.needClear();
    }

    public void xor(BitSet bs) {
        int bsActualLen = bs.getActualArrayLength();
        if (bsActualLen > this.bits.length) {
            long[] tempBits = new long[bsActualLen];
            System.arraycopy(bs.bits, 0, tempBits, 0, bs.actualArrayLength);
            for (int i = 0; i < this.actualArrayLength; ++i) {
                int n = i;
                tempBits[n] = tempBits[n] ^ this.bits[i];
            }
            this.bits = tempBits;
            this.actualArrayLength = bsActualLen;
            this.isLengthActual = this.actualArrayLength <= 0 || this.bits[this.actualArrayLength - 1] != 0L;
        } else {
            long[] bsBits = bs.bits;
            for (int i = 0; i < bsActualLen; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] ^ bsBits[i];
            }
            if (bsActualLen > this.actualArrayLength) {
                this.actualArrayLength = bsActualLen;
                this.isLengthActual = true;
            }
        }
        this.needClear();
    }

    public int size() {
        return this.bits.length << 6;
    }

    public int length() {
        int i;
        int idx;
        for (idx = this.actualArrayLength - 1; idx >= 0 && this.bits[idx] == 0L; --idx) {
        }
        this.actualArrayLength = idx + 1;
        if (idx == -1) {
            return 0;
        }
        long val = this.bits[idx];
        for (i = 63; (val & TWO_N_ARRAY[i]) == 0L && i > 0; --i) {
        }
        return (idx << 6) + i + 1;
    }

    private final int getActualArrayLength() {
        int idx;
        if (this.isLengthActual) {
            return this.actualArrayLength;
        }
        for (idx = this.actualArrayLength - 1; idx >= 0 && this.bits[idx] == 0L; --idx) {
        }
        this.actualArrayLength = idx + 1;
        this.isLengthActual = true;
        return this.actualArrayLength;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.bits.length / 2);
        int bitCount = 0;
        sb.append('{');
        boolean comma = false;
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == 0L) {
                bitCount += 64;
                continue;
            }
            for (int j = 0; j < 64; ++j) {
                if ((this.bits[i] & TWO_N_ARRAY[j]) != 0L) {
                    if (comma) {
                        sb.append(", ");
                    }
                    sb.append(bitCount);
                    comma = true;
                }
                ++bitCount;
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public int nextSetBit(int pos) {
        int j;
        if (pos < 0) {
            throw new IndexOutOfBoundsException("" + pos);
        }
        if (pos >= this.actualArrayLength << 6) {
            return -1;
        }
        int idx = pos >> 6;
        if (this.bits[idx] != 0L) {
            for (j = pos & 0x3F; j < 64; ++j) {
                if ((this.bits[idx] & TWO_N_ARRAY[j]) == 0L) continue;
                return (idx << 6) + j;
            }
        }
        ++idx;
        while (idx < this.actualArrayLength && this.bits[idx] == 0L) {
            ++idx;
        }
        if (idx == this.actualArrayLength) {
            return -1;
        }
        for (j = 0; j < 64; ++j) {
            if ((this.bits[idx] & TWO_N_ARRAY[j]) == 0L) continue;
            return (idx << 6) + j;
        }
        return -1;
    }

    public int nextClearBit(int pos) {
        int j;
        if (pos < 0) {
            throw new IndexOutOfBoundsException("" + pos);
        }
        int length = this.actualArrayLength;
        int bssize = length << 6;
        if (pos >= bssize) {
            return pos;
        }
        int idx = pos >> 6;
        if (this.bits[idx] != -1L) {
            for (j = pos % 64; j < 64; ++j) {
                if ((this.bits[idx] & TWO_N_ARRAY[j]) != 0L) continue;
                return idx * 64 + j;
            }
        }
        ++idx;
        while (idx < length && this.bits[idx] == -1L) {
            ++idx;
        }
        if (idx == length) {
            return bssize;
        }
        for (j = 0; j < 64; ++j) {
            if ((this.bits[idx] & TWO_N_ARRAY[j]) != 0L) continue;
            return (idx << 6) + j;
        }
        return bssize;
    }

    public boolean isEmpty() {
        if (!this.needClear) {
            return true;
        }
        int length = this.bits.length;
        for (int idx = 0; idx < length; ++idx) {
            if (this.bits[idx] == 0L) continue;
            return false;
        }
        return true;
    }

    public int cardinality() {
        if (!this.needClear) {
            return 0;
        }
        int count = 0;
        int length = this.bits.length;
        for (int idx = 0; idx < length; ++idx) {
            count += this.pop(this.bits[idx] & 0xFFFFFFFFL);
            count += this.pop(this.bits[idx] >>> 32);
        }
        return count;
    }

    private final int pop(long x) {
        x -= x >>> 1 & 0x55555555L;
        x = (x & 0x33333333L) + (x >>> 2 & 0x33333333L);
        x = x + (x >>> 4) & 0xF0F0F0FL;
        x += x >>> 8;
        x += x >>> 16;
        return (int)x & 0x3F;
    }
}

