/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private final boolean accessOrder;
    private transient LinkedHashMapEntry<K, V> head;
    private transient LinkedHashMapEntry<K, V> tail;

    public LinkedHashMap() {
        this.accessOrder = false;
        this.head = null;
    }

    public LinkedHashMap(int s) {
        super(s);
        this.accessOrder = false;
        this.head = null;
    }

    public LinkedHashMap(int s, float lf) {
        super(s, lf);
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
    }

    public LinkedHashMap(int s, float lf, boolean order) {
        super(s, lf);
        this.accessOrder = order;
        this.head = null;
        this.tail = null;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> m) {
        this.accessOrder = false;
        this.head = null;
        this.tail = null;
        this.putAll(m);
    }

    @Override
    public boolean containsValue(Object value) {
        LinkedHashMapEntry<K, V> entry = this.head;
        if (null == value) {
            while (null != entry) {
                if (null == entry.value) {
                    return true;
                }
                entry = entry.chainForward;
            }
        } else {
            while (null != entry) {
                if (value.equals(entry.value)) {
                    return true;
                }
                entry = entry.chainForward;
            }
        }
        return false;
    }

    @Override
    HashMap.Entry<K, V>[] newElementArray(int s) {
        return new LinkedHashMapEntry[s];
    }

    @Override
    public V get(Object key) {
        LinkedHashMapEntry m;
        if (key == null) {
            m = (LinkedHashMapEntry)this.findNullKeyEntry();
        } else {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            m = (LinkedHashMapEntry)this.findNonNullKeyEntry(key, index, hash);
        }
        if (m == null) {
            return null;
        }
        if (this.accessOrder && this.tail != m) {
            LinkedHashMapEntry p = m.chainBackward;
            LinkedHashMapEntry n = m.chainForward;
            n.chainBackward = p;
            if (p != null) {
                p.chainForward = n;
            } else {
                this.head = n;
            }
            m.chainForward = null;
            m.chainBackward = this.tail;
            this.tail.chainForward = m;
            this.tail = m;
        }
        return (V)m.value;
    }

    @Override
    HashMap.Entry<K, V> createEntry(K key, int index, V value) {
        LinkedHashMapEntry<K, V> m = new LinkedHashMapEntry<K, V>(key, value);
        m.next = this.elementData[index];
        this.elementData[index] = m;
        this.linkEntry(m);
        return m;
    }

    @Override
    HashMap.Entry<K, V> createHashedEntry(K key, int index, int hash) {
        LinkedHashMapEntry m = new LinkedHashMapEntry(key, hash);
        m.next = this.elementData[index];
        this.elementData[index] = m;
        this.linkEntry(m);
        return m;
    }

    @Override
    public V put(K key, V value) {
        V result = this.putImpl(key, value);
        if (this.removeEldestEntry(this.head)) {
            this.remove(this.head.key);
        }
        return result;
    }

    @Override
    V putImpl(K key, V value) {
        LinkedHashMapEntry m;
        if (this.elementCount == 0) {
            this.tail = null;
            this.head = null;
        }
        if (key == null) {
            m = (LinkedHashMapEntry)this.findNullKeyEntry();
            if (m == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
                m = (LinkedHashMapEntry)this.createHashedEntry(null, 0, 0);
            } else {
                this.linkEntry(m);
            }
        } else {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            m = (LinkedHashMapEntry)this.findNonNullKeyEntry(key, index, hash);
            if (m == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    index = (hash & Integer.MAX_VALUE) % this.elementData.length;
                }
                m = (LinkedHashMapEntry)this.createHashedEntry(key, index, hash);
            } else {
                this.linkEntry(m);
            }
        }
        Object result = m.value;
        m.value = value;
        return (V)result;
    }

    void linkEntry(LinkedHashMapEntry<K, V> m) {
        if (this.tail == m) {
            return;
        }
        if (this.head == null) {
            this.tail = m;
            this.head = this.tail;
            return;
        }
        LinkedHashMapEntry p = m.chainBackward;
        LinkedHashMapEntry n = m.chainForward;
        if (p == null) {
            if (n != null) {
                if (this.accessOrder) {
                    this.head = n;
                    n.chainBackward = null;
                    m.chainBackward = this.tail;
                    m.chainForward = null;
                    this.tail.chainForward = m;
                    this.tail = m;
                }
            } else {
                m.chainBackward = this.tail;
                m.chainForward = null;
                this.tail.chainForward = m;
                this.tail = m;
            }
            return;
        }
        if (n == null) {
            return;
        }
        if (this.accessOrder) {
            p.chainForward = n;
            n.chainBackward = p;
            m.chainForward = null;
            m.chainBackward = this.tail;
            this.tail.chainForward = m;
            this.tail = m;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new LinkedHashMapEntrySet(this);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return LinkedHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return LinkedHashMap.this.size();
                }

                @Override
                public void clear() {
                    LinkedHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    if (LinkedHashMap.this.containsKey(key)) {
                        LinkedHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator(LinkedHashMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return LinkedHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return LinkedHashMap.this.size();
                }

                @Override
                public void clear() {
                    LinkedHashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator(LinkedHashMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public V remove(Object key) {
        LinkedHashMapEntry m = (LinkedHashMapEntry)this.removeEntry(key);
        if (m == null) {
            return null;
        }
        LinkedHashMapEntry p = m.chainBackward;
        LinkedHashMapEntry n = m.chainForward;
        if (p != null) {
            p.chainForward = n;
        } else {
            this.head = n;
        }
        if (n != null) {
            n.chainBackward = p;
        } else {
            this.tail = p;
        }
        return (V)m.value;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.tail = null;
        this.head = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LinkedHashMapEntry<K, V>
    extends HashMap.Entry<K, V> {
        LinkedHashMapEntry<K, V> chainForward = null;
        LinkedHashMapEntry<K, V> chainBackward = null;

        LinkedHashMapEntry(K theKey, V theValue) {
            super(theKey, theValue);
        }

        LinkedHashMapEntry(K theKey, int hash) {
            super(theKey, hash);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LinkedHashMapEntrySet<KT, VT>
    extends HashMap.HashMapEntrySet<KT, VT> {
        public LinkedHashMapEntrySet(LinkedHashMap<KT, VT> lhm) {
            super(lhm);
        }

        @Override
        public Iterator<Map.Entry<KT, VT>> iterator() {
            return new EntryIterator((LinkedHashMap)this.hashMap());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<V> {
        ValueIterator(LinkedHashMap<K, V> map) {
            super(map);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<K> {
        KeyIterator(LinkedHashMap<K, V> map) {
            super(map);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(LinkedHashMap<K, V> map) {
            super(map);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbstractMapIterator<K, V> {
        int expectedModCount;
        LinkedHashMapEntry<K, V> futureEntry;
        LinkedHashMapEntry<K, V> currentEntry;
        final LinkedHashMap<K, V> associatedMap;

        AbstractMapIterator(LinkedHashMap<K, V> map) {
            this.expectedModCount = map.modCount;
            this.futureEntry = ((LinkedHashMap)map).head;
            this.associatedMap = map;
        }

        public boolean hasNext() {
            return this.futureEntry != null;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentEntry = this.futureEntry;
            this.futureEntry = this.futureEntry.chainForward;
        }

        public void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            this.associatedMap.removeEntry(this.currentEntry);
            LinkedHashMapEntry<K, V> lhme = this.currentEntry;
            LinkedHashMapEntry p = lhme.chainBackward;
            LinkedHashMapEntry n = lhme.chainForward;
            LinkedHashMap<K, V> lhm = this.associatedMap;
            if (p != null) {
                p.chainForward = n;
                if (n != null) {
                    n.chainBackward = p;
                } else {
                    ((LinkedHashMap)lhm).tail = p;
                }
            } else {
                ((LinkedHashMap)lhm).head = n;
                if (n != null) {
                    n.chainBackward = null;
                } else {
                    ((LinkedHashMap)lhm).tail = null;
                }
            }
            this.currentEntry = null;
            ++this.expectedModCount;
        }
    }
}

