/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E> {
    private static final int DEFAULT_SIZE = 16;
    private transient DequeStatus status;
    private transient int modCount;
    private transient int front;
    private transient int rear;
    private transient E[] elements;

    public ArrayDeque() {
        this(16);
    }

    public ArrayDeque(int minSize) {
        int size = this.countInitSize(minSize);
        this.elements = new Object[size];
        this.rear = 0;
        this.front = 0;
        this.status = DequeStatus.Empty;
        this.modCount = 0;
    }

    private int countInitSize(int minSize) {
        return -1;
    }

    public ArrayDeque(Collection<? extends E> c) {
        this.elements = new Object[this.countInitSize(c.size())];
        this.rear = 0;
        this.front = 0;
        this.status = DequeStatus.Empty;
        this.modCount = 0;
        Iterator<E> it = c.iterator();
        while (it.hasNext()) {
            this.addLastImpl(it.next());
        }
    }

    @Override
    public void addFirst(E e) {
        this.offerFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.addLastImpl(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.checkNull(e);
        this.checkAndExpand();
        this.front = this.circularSmallerPos(this.front);
        this.elements[this.front] = e;
        this.resetStatus(true);
        ++this.modCount;
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        return this.addLastImpl(e);
    }

    @Override
    public boolean offer(E e) {
        return this.addLastImpl(e);
    }

    @Override
    public boolean add(E e) {
        return this.addLastImpl(e);
    }

    @Override
    public void push(E e) {
        this.offerFirst(e);
    }

    @Override
    public E removeFirst() {
        this.checkEmpty();
        return this.removePollFirstImpl();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public E removeLast() {
        this.checkEmpty();
        return this.removeLastImpl();
    }

    @Override
    public E pollFirst() {
        return this.status == DequeStatus.Empty ? null : (E)this.removePollFirstImpl();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.status == DequeStatus.Empty ? null : (E)this.removeLastImpl();
    }

    @Override
    public E getFirst() {
        this.checkEmpty();
        return this.elements[this.front];
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E getLast() {
        this.checkEmpty();
        return this.elements[this.circularSmallerPos(this.rear)];
    }

    @Override
    public E peekFirst() {
        return this.status == DequeStatus.Empty ? null : (E)this.elements[this.front];
    }

    @Override
    public E peek() {
        return this.status == DequeStatus.Empty ? null : (E)this.elements[this.front];
    }

    @Override
    public E peekLast() {
        return this.status == DequeStatus.Empty ? null : (E)this.elements[this.circularSmallerPos(this.rear)];
    }

    private void checkNull(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
    }

    private void checkEmpty() {
        if (this.status == DequeStatus.Empty) {
            throw new NoSuchElementException();
        }
    }

    private int circularSmallerPos(int current) {
        return current - 1 < 0 ? this.elements.length - 1 : current - 1;
    }

    private int circularBiggerPos(int current) {
        return current + 1 >= this.elements.length ? 0 : current + 1;
    }

    private void checkAndExpand() {
        if (this.status != DequeStatus.Full) {
            return;
        }
        if (Integer.MAX_VALUE == this.elements.length) {
            throw new IllegalStateException();
        }
        int length = this.elements.length;
        int newLength = length << 1;
        if (newLength < 0) {
            newLength = Integer.MAX_VALUE;
        }
        Object[] newElements = new Object[newLength];
        System.arraycopy(this.elements, this.front, newElements, 0, length - this.front);
        System.arraycopy(this.elements, 0, newElements, length - this.front, this.front);
        this.front = 0;
        this.rear = length;
        this.status = DequeStatus.Normal;
        this.elements = newElements;
    }

    private void resetStatus(boolean adding) {
        this.status = this.front == this.rear ? (adding ? DequeStatus.Full : DequeStatus.Empty) : DequeStatus.Normal;
    }

    private boolean addLastImpl(E e) {
        this.checkNull(e);
        this.checkAndExpand();
        this.elements[this.rear] = e;
        this.rear = this.circularBiggerPos(this.rear);
        this.resetStatus(true);
        ++this.modCount;
        return true;
    }

    private E removePollFirstImpl() {
        E element = this.elements[this.front];
        this.elements[this.front] = null;
        this.front = this.circularBiggerPos(this.front);
        this.resetStatus(false);
        ++this.modCount;
        return element;
    }

    private E removeLastImpl() {
        int last = this.circularSmallerPos(this.rear);
        E element = this.elements[last];
        this.elements[last] = null;
        this.rear = last;
        this.resetStatus(false);
        ++this.modCount;
        return element;
    }

    @Override
    public boolean removeFirstOccurrence(Object obj) {
        return this.removeFirstOccurrenceImpl(obj);
    }

    @Override
    public boolean remove(Object obj) {
        return this.removeFirstOccurrenceImpl(obj);
    }

    @Override
    public boolean removeLastOccurrence(Object obj) {
        if (null != obj) {
            Iterator<E> iter = this.descendingIterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(obj)) continue;
                iter.remove();
                return true;
            }
        }
        return false;
    }

    private boolean removeFirstOccurrenceImpl(Object obj) {
        if (null != obj) {
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(obj)) continue;
                iter.remove();
                return true;
            }
        }
        return false;
    }

    private void removeInternal(int current, boolean frontShift) {
        int cursor = current;
        if (frontShift) {
            while (cursor != this.front) {
                int next = this.circularSmallerPos(cursor);
                this.elements[cursor] = this.elements[next];
                cursor = next;
            }
            this.front = this.circularBiggerPos(this.front);
        } else {
            while (cursor != this.rear) {
                int next = this.circularBiggerPos(cursor);
                this.elements[cursor] = this.elements[next];
                cursor = next;
            }
            this.rear = this.circularSmallerPos(this.rear);
        }
        this.elements[cursor] = null;
        this.resetStatus(false);
    }

    @Override
    public int size() {
        if (this.status == DequeStatus.Full) {
            return this.elements.length;
        }
        return this.front <= this.rear ? this.rear - this.front : this.rear + this.elements.length - this.front;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean contains(Object obj) {
        if (null != obj) {
            ArrayDequeIterator it = new ArrayDequeIterator();
            while (it.hasNext()) {
                if (!obj.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.status != DequeStatus.Empty) {
            int cursor = this.front;
            do {
                this.elements[cursor] = null;
            } while ((cursor = this.circularBiggerPos(cursor)) != this.rear);
            this.status = DequeStatus.Empty;
        }
        this.rear = 0;
        this.front = 0;
        this.modCount = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayDequeIterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new ReverseArrayDequeIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReverseArrayDequeIterator<E>
    implements Iterator<E> {
        private int pos;
        private final int expectedModCount;
        private boolean canRemove;

        ReverseArrayDequeIterator() {
            this.expectedModCount = ArrayDeque.this.modCount;
            this.pos = ArrayDeque.this.circularSmallerPos(ArrayDeque.this.rear);
            this.canRemove = false;
        }

        @Override
        public boolean hasNext() {
            if (this.expectedModCount != ArrayDeque.this.modCount) {
                return false;
            }
            return this.hasNextInternal();
        }

        private boolean hasNextInternal() {
            return ArrayDeque.this.circularBiggerPos(this.pos) != ArrayDeque.this.front || ArrayDeque.this.status == DequeStatus.Full && !this.canRemove;
        }

        @Override
        public E next() {
            if (this.hasNextInternal()) {
                Object result = ArrayDeque.this.elements[this.pos];
                this.canRemove = true;
                this.pos = ArrayDeque.this.circularSmallerPos(this.pos);
                return (E)result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.canRemove) {
                ArrayDeque.this.removeInternal(ArrayDeque.this.circularBiggerPos(this.pos), false);
                this.canRemove = false;
                return;
            }
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayDequeIterator<E>
    implements Iterator<E> {
        private int pos;
        private final int expectedModCount;
        private boolean canRemove;

        ArrayDequeIterator() {
            this.pos = ArrayDeque.this.front;
            this.expectedModCount = ArrayDeque.this.modCount;
            this.canRemove = false;
        }

        @Override
        public boolean hasNext() {
            if (this.expectedModCount != ArrayDeque.this.modCount) {
                return false;
            }
            return this.hasNextInternal();
        }

        private boolean hasNextInternal() {
            return this.pos != ArrayDeque.this.rear || ArrayDeque.this.status == DequeStatus.Full && !this.canRemove;
        }

        @Override
        public E next() {
            if (this.hasNextInternal()) {
                Object result = ArrayDeque.this.elements[this.pos];
                if (this.expectedModCount == ArrayDeque.this.modCount && null != result) {
                    this.canRemove = true;
                    this.pos = ArrayDeque.this.circularBiggerPos(this.pos);
                    return (E)result;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.canRemove) {
                int removedPos = ArrayDeque.this.circularSmallerPos(this.pos);
                if (this.expectedModCount == ArrayDeque.this.modCount && null != ArrayDeque.this.elements[removedPos]) {
                    ArrayDeque.this.removeInternal(removedPos, true);
                    this.canRemove = false;
                    return;
                }
                throw new ConcurrentModificationException();
            }
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DequeStatus {
        Empty,
        Normal,
        Full;

    }
}

