/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess {
    private static final long serialVersionUID = 8683452581122892189L;
    private transient int firstIndex;
    private transient int size;
    private transient E[] array;

    public ArrayList() {
        this(10);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.firstIndex = 0;
        this.array = this.newElementArray(capacity);
    }

    public ArrayList(Collection<? extends E> collection) {
        this.firstIndex = 0;
        Object[] objects = ArrayList.toObjectArray(collection);
        this.size = objects.length;
        this.array = this.newElementArray(this.size + this.size / 10);
        System.arraycopy(objects, 0, this.array, 0, this.size);
        this.modCount = 1;
    }

    static void toObjectArray(Object[] objects, Collection collection) {
        Iterator i = collection.iterator();
        for (int iter = 0; iter < objects.length; ++iter) {
            objects[iter] = i.next();
        }
    }

    static Object[] toObjectArray(Collection collection) {
        Object[] objects = new Object[collection.size()];
        ArrayList.toObjectArray(objects, collection);
        return objects;
    }

    private E[] newElementArray(int size) {
        return new Object[size];
    }

    @Override
    public void add(int location, E object) {
        if (location < 0 || location > this.size) {
            throw new IndexOutOfBoundsException("" + location + " out of: " + this.size);
        }
        if (location == 0) {
            if (this.firstIndex == 0) {
                this.growAtFront(1);
            }
            this.array[--this.firstIndex] = object;
        } else if (location == this.size) {
            if (this.firstIndex + this.size == this.array.length) {
                this.growAtEnd(1);
            }
            this.array[this.firstIndex + this.size] = object;
        } else {
            if (this.size == this.array.length) {
                this.growForInsert(location, 1);
            } else if (this.firstIndex + this.size == this.array.length || this.firstIndex > 0 && location < this.size / 2) {
                System.arraycopy(this.array, this.firstIndex, this.array, --this.firstIndex, location);
            } else {
                int index = location + this.firstIndex;
                System.arraycopy(this.array, index, this.array, index + 1, this.size - location);
            }
            this.array[location + this.firstIndex] = object;
        }
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean add(E object) {
        if (this.firstIndex + this.size == this.array.length) {
            this.growAtEnd(1);
        }
        this.array[this.firstIndex + this.size] = object;
        ++this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(int location, Collection<? extends E> collection) {
        if (location < 0 || location > this.size) {
            throw new IndexOutOfBoundsException("" + location + " out of: " + this.size);
        }
        Object[] dumparray = ArrayList.toObjectArray(collection);
        int growSize = dumparray.length;
        if (growSize == 0) {
            return false;
        }
        if (location == 0) {
            this.growAtFront(growSize);
            this.firstIndex -= growSize;
        } else if (location == this.size) {
            if (this.firstIndex + this.size > this.array.length - growSize) {
                this.growAtEnd(growSize);
            }
        } else if (this.array.length - this.size < growSize) {
            this.growForInsert(location, growSize);
        } else if (this.firstIndex + this.size > this.array.length - growSize || this.firstIndex > 0 && location < this.size / 2) {
            int newFirst = this.firstIndex - growSize;
            if (newFirst < 0) {
                int index = location + this.firstIndex;
                System.arraycopy(this.array, index, this.array, index - newFirst, this.size - location);
                newFirst = 0;
            }
            System.arraycopy(this.array, this.firstIndex, this.array, newFirst, location);
            this.firstIndex = newFirst;
        } else {
            int index = location + this.firstIndex;
            System.arraycopy(this.array, index, this.array, index + growSize, this.size - location);
        }
        System.arraycopy(dumparray, 0, this.array, location + this.firstIndex, growSize);
        this.size += growSize;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] dumpArray = ArrayList.toObjectArray(collection);
        if (dumpArray.length == 0) {
            return false;
        }
        if (dumpArray.length > this.array.length - (this.firstIndex + this.size)) {
            this.growAtEnd(dumpArray.length);
        }
        System.arraycopy(dumpArray, 0, this.array, this.firstIndex + this.size, dumpArray.length);
        this.size += dumpArray.length;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            Arrays.fill(this.array, this.firstIndex, this.firstIndex + this.size, null);
            this.size = 0;
            this.firstIndex = 0;
            ++this.modCount;
        }
    }

    @Override
    public boolean contains(Object object) {
        int lastIndex = this.firstIndex + this.size;
        if (object != null) {
            for (int i = this.firstIndex; i < lastIndex; ++i) {
                if (!object.equals(this.array[i])) continue;
                return true;
            }
        } else {
            for (int i = this.firstIndex; i < lastIndex; ++i) {
                if (this.array[i] != null) continue;
                return true;
            }
        }
        return false;
    }

    public void ensureCapacity(int minimumCapacity) {
        int required = minimumCapacity - this.array.length;
        if (required > 0) {
            if (this.firstIndex > 0) {
                this.growAtFront(required);
            } else {
                this.growAtEnd(required);
            }
        }
    }

    @Override
    public E get(int location) {
        if (location < 0 || location >= this.size) {
            throw new IndexOutOfBoundsException("" + location + " out of: " + this.size);
        }
        return this.array[this.firstIndex + location];
    }

    private void growAtEnd(int required) {
        if (this.array.length - this.size >= required) {
            if (this.size != 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, 0, this.size);
                int start = this.size < this.firstIndex ? this.firstIndex : this.size;
                Arrays.fill(this.array, start, this.array.length, null);
            }
            this.firstIndex = 0;
        } else {
            int increment = this.size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            E[] newArray = this.newElementArray(this.size + increment);
            if (this.size != 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, 0, this.size);
                this.firstIndex = 0;
            }
            this.array = newArray;
        }
    }

    private void growAtFront(int required) {
        if (this.array.length - this.size >= required) {
            int newFirst = this.array.length - this.size;
            if (this.size != 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, newFirst, this.size);
                int lastIndex = this.firstIndex + this.size;
                int length = lastIndex > newFirst ? newFirst : lastIndex;
                Arrays.fill(this.array, this.firstIndex, length, null);
            }
            this.firstIndex = newFirst;
        } else {
            int increment = this.size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            E[] newArray = this.newElementArray(this.size + increment);
            if (this.size != 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, increment, this.size);
            }
            this.firstIndex = newArray.length - this.size;
            this.array = newArray;
        }
    }

    private void growForInsert(int location, int required) {
        int increment = this.size / 2;
        if (required > increment) {
            increment = required;
        }
        if (increment < 12) {
            increment = 12;
        }
        E[] newArray = this.newElementArray(this.size + increment);
        int newFirst = increment - required;
        System.arraycopy(this.array, location + this.firstIndex, newArray, newFirst + location + required, this.size - location);
        System.arraycopy(this.array, this.firstIndex, newArray, newFirst, location);
        this.firstIndex = newFirst;
        this.array = newArray;
    }

    @Override
    public int indexOf(Object object) {
        int lastIndex = this.firstIndex + this.size;
        if (object != null) {
            for (int i = this.firstIndex; i < lastIndex; ++i) {
                if (!object.equals(this.array[i])) continue;
                return i - this.firstIndex;
            }
        } else {
            for (int i = this.firstIndex; i < lastIndex; ++i) {
                if (this.array[i] != null) continue;
                return i - this.firstIndex;
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int lastIndexOf(Object object) {
        int lastIndex = this.firstIndex + this.size;
        if (object != null) {
            for (int i = lastIndex - 1; i >= this.firstIndex; --i) {
                if (!object.equals(this.array[i])) continue;
                return i - this.firstIndex;
            }
        } else {
            for (int i = lastIndex - 1; i >= this.firstIndex; --i) {
                if (this.array[i] != null) continue;
                return i - this.firstIndex;
            }
        }
        return -1;
    }

    @Override
    public E remove(int location) {
        E result;
        if (location < 0 || location >= this.size) {
            throw new IndexOutOfBoundsException("" + location + " out of: " + this.size);
        }
        if (location == 0) {
            result = this.array[this.firstIndex];
            this.array[this.firstIndex++] = null;
        } else if (location == this.size - 1) {
            int lastIndex = this.firstIndex + this.size - 1;
            result = this.array[lastIndex];
            this.array[lastIndex] = null;
        } else {
            int elementIndex = this.firstIndex + location;
            result = this.array[elementIndex];
            if (location < this.size / 2) {
                System.arraycopy(this.array, this.firstIndex, this.array, this.firstIndex + 1, location);
                this.array[this.firstIndex++] = null;
            } else {
                System.arraycopy(this.array, elementIndex + 1, this.array, elementIndex, this.size - location - 1);
                this.array[this.firstIndex + this.size - 1] = null;
            }
        }
        --this.size;
        if (this.size == 0) {
            this.firstIndex = 0;
        }
        ++this.modCount;
        return result;
    }

    @Override
    public boolean remove(Object object) {
        int location = this.indexOf(object);
        if (location >= 0) {
            this.remove(location);
            return true;
        }
        return false;
    }

    @Override
    protected void removeRange(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("" + start);
        }
        if (end > this.size) {
            throw new IndexOutOfBoundsException("" + end + " out of: " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("" + start + " out of: " + end);
        }
        if (start == end) {
            return;
        }
        if (end == this.size) {
            Arrays.fill(this.array, this.firstIndex + start, this.firstIndex + this.size, null);
        } else if (start == 0) {
            Arrays.fill(this.array, this.firstIndex, this.firstIndex + end, null);
            this.firstIndex += end;
        } else {
            System.arraycopy(this.array, this.firstIndex + end, this.array, this.firstIndex + start, this.size - end);
            int lastIndex = this.firstIndex + this.size;
            int newLast = lastIndex + start - end;
            Arrays.fill(this.array, newLast, lastIndex, null);
        }
        this.size -= end - start;
        ++this.modCount;
    }

    @Override
    public E set(int location, E object) {
        if (location < 0 || location >= this.size) {
            throw new IndexOutOfBoundsException("" + location + " out of: " + this.size);
        }
        E result = this.array[this.firstIndex + location];
        this.array[this.firstIndex + location] = object;
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.array, this.firstIndex, result, 0, this.size);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] contents) {
        Object[] arr = contents;
        if (this.size > arr.length) {
            arr = new Object[this.size];
        }
        System.arraycopy(this.array, this.firstIndex, arr, 0, this.size);
        if (this.size < arr.length) {
            arr[this.size] = null;
        }
        return arr;
    }

    public void trimToSize() {
        E[] newArray = this.newElementArray(this.size);
        System.arraycopy(this.array, this.firstIndex, newArray, 0, this.size);
        this.array = newArray;
        this.firstIndex = 0;
        this.modCount = 0;
    }
}

