/*
 * Decompiled with CFR 0.152.
 */
package com.codepine.api.testrail;

import com.codepine.api.testrail.Request;
import com.codepine.api.testrail.TestRailConfig;
import com.codepine.api.testrail.internal.BooleanToIntSerializer;
import com.codepine.api.testrail.internal.ListToCsvSerializer;
import com.codepine.api.testrail.model.Case;
import com.codepine.api.testrail.model.CaseField;
import com.codepine.api.testrail.model.CaseType;
import com.codepine.api.testrail.model.Configuration;
import com.codepine.api.testrail.model.Milestone;
import com.codepine.api.testrail.model.Plan;
import com.codepine.api.testrail.model.Priority;
import com.codepine.api.testrail.model.Project;
import com.codepine.api.testrail.model.Result;
import com.codepine.api.testrail.model.ResultField;
import com.codepine.api.testrail.model.Run;
import com.codepine.api.testrail.model.Section;
import com.codepine.api.testrail.model.Status;
import com.codepine.api.testrail.model.Suite;
import com.codepine.api.testrail.model.Test;
import com.codepine.api.testrail.model.User;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import lombok.NonNull;

public class TestRail {
    private final TestRailConfig config;

    public static Builder builder(@NonNull String endPoint, @NonNull String username, @NonNull String password) {
        if (endPoint == null) {
            throw new NullPointerException("endPoint");
        }
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        return new Builder(endPoint, username, password);
    }

    public Projects projects() {
        return new Projects();
    }

    public Cases cases() {
        return new Cases();
    }

    public CaseFields caseFields() {
        return new CaseFields();
    }

    public CaseTypes caseTypes() {
        return new CaseTypes();
    }

    public Configurations configurations() {
        return new Configurations();
    }

    public Sections sections() {
        return new Sections();
    }

    public Suites suites() {
        return new Suites();
    }

    public Milestones milestones() {
        return new Milestones();
    }

    public Priorities priorities() {
        return new Priorities();
    }

    public ResultFields resultFields() {
        return new ResultFields();
    }

    public Tests tests() {
        return new Tests();
    }

    public Users users() {
        return new Users();
    }

    public Statuses statuses() {
        return new Statuses();
    }

    public Runs runs() {
        return new Runs();
    }

    public Plans plans() {
        return new Plans();
    }

    public Results results() {
        return new Results();
    }

    private TestRail(TestRailConfig config) {
        this.config = config;
    }

    TestRailConfig getConfig() {
        return this.config;
    }

    public class Users {
        public Get get(int userId) {
            Preconditions.checkArgument((userId > 0 ? 1 : 0) != 0, (Object)"userId should be positive");
            return new Get(userId);
        }

        public GetByEmail getByEmail(@NonNull String email) {
            if (email == null) {
                throw new NullPointerException("email");
            }
            Preconditions.checkArgument((!(email = email.trim()).isEmpty() ? 1 : 0) != 0, (Object)"email cannot be empty");
            return new GetByEmail(email);
        }

        public List list() {
            return new List();
        }

        public class List
        extends Request<java.util.List<User>> {
            private static final String REST_PATH = "get_users";

            private List() {
                super(TestRail.this.config, Request.Method.GET, REST_PATH, new TypeReference<java.util.List<User>>(){});
            }
        }

        public class GetByEmail
        extends Request<User> {
            private static final String REST_PATH = "get_user_by_email&email=";

            private GetByEmail(String email) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + email, User.class);
            }
        }

        public class Get
        extends Request<User> {
            private static final String REST_PATH = "get_user/";

            private Get(int userId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + userId, User.class);
            }
        }
    }

    public class Tests {
        public Get get(int testId) {
            Preconditions.checkArgument((testId > 0 ? 1 : 0) != 0, (Object)"testId should be positive");
            return new Get(testId);
        }

        public List list(int runId) {
            Preconditions.checkArgument((runId > 0 ? 1 : 0) != 0, (Object)"runId should be positive");
            return new List(runId);
        }

        public class List
        extends Request<java.util.List<Test>> {
            private static final String REST_PATH = "get_tests/";
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> statusId;

            private List(int runId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + runId, new TypeReference<java.util.List<Test>>(){});
            }

            public java.util.List<Integer> statusId() {
                return this.statusId;
            }

            public List statusId(java.util.List<Integer> statusId) {
                this.statusId = statusId;
                return this;
            }
        }

        public class Get
        extends Request<Test> {
            private static final String REST_PATH = "get_test/";

            private Get(int testId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + testId, Test.class);
            }
        }
    }

    public class Suites {
        public Get get(int suiteId) {
            Preconditions.checkArgument((suiteId > 0 ? 1 : 0) != 0, (Object)"suiteId should be positive");
            return new Get(suiteId);
        }

        public List list(int projectId) {
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new List(projectId);
        }

        public Add add(int projectId, @NonNull Suite suite) {
            if (suite == null) {
                throw new NullPointerException("suite");
            }
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new Add(projectId, suite);
        }

        public Update update(@NonNull Suite suite) {
            if (suite == null) {
                throw new NullPointerException("suite");
            }
            return new Update(suite);
        }

        public Delete delete(int suiteId) {
            Preconditions.checkArgument((suiteId > 0 ? 1 : 0) != 0, (Object)"suiteId should be positive");
            return new Delete(suiteId);
        }

        public class Delete
        extends Request<Void> {
            private static final String REST_PATH = "delete_suite/";

            private Delete(int suiteId) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + suiteId, Void.class);
            }
        }

        public class Update
        extends Request<Suite> {
            private static final String REST_PATH = "update_suite/";
            private final Suite suite;

            private Update(Suite suite) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + suite.getId(), Suite.class);
                this.suite = suite;
            }

            @Override
            protected Object getContent() {
                return this.suite;
            }
        }

        public class Add
        extends Request<Suite> {
            private static final String REST_PATH = "add_suite/";
            private final Suite suite;

            private Add(int projectId, Suite suite) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + projectId, Suite.class);
                this.suite = suite;
            }

            @Override
            protected Object getContent() {
                return this.suite;
            }
        }

        public class List
        extends Request<java.util.List<Suite>> {
            private static final String REST_PATH = "get_suites/";

            private List(int projectId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + projectId, new TypeReference<java.util.List<Suite>>(){});
            }
        }

        public class Get
        extends Request<Suite> {
            private static final String REST_PATH = "get_suite/";

            private Get(int suiteId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + suiteId, Suite.class);
            }
        }
    }

    public class Statuses {
        public List list() {
            return new List();
        }

        public class List
        extends Request<java.util.List<Status>> {
            private static final String REST_PATH = "get_statuses";

            private List() {
                super(TestRail.this.config, Request.Method.GET, REST_PATH, new TypeReference<java.util.List<Status>>(){});
            }
        }
    }

    public class Sections {
        public Get get(int sectionId) {
            Preconditions.checkArgument((sectionId > 0 ? 1 : 0) != 0, (Object)"sectionId should be positive");
            return new Get(sectionId);
        }

        public List list(int projectId) {
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new List(projectId);
        }

        public List list(int projectId, int suiteId) {
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            Preconditions.checkArgument((suiteId > 0 ? 1 : 0) != 0, (Object)"suiteId should be positive");
            return new List(projectId, suiteId);
        }

        public Add add(int projectId, @NonNull Section section) {
            if (section == null) {
                throw new NullPointerException("section");
            }
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new Add(projectId, section);
        }

        public Update update(@NonNull Section section) {
            if (section == null) {
                throw new NullPointerException("section");
            }
            return new Update(section);
        }

        public Delete delete(int sectionId) {
            Preconditions.checkArgument((sectionId > 0 ? 1 : 0) != 0, (Object)"sectionId should be positive");
            return new Delete(sectionId);
        }

        public class Delete
        extends Request<Void> {
            private static final String REST_PATH = "delete_section/";

            private Delete(int sectionId) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + sectionId, Void.class);
            }
        }

        public class Update
        extends Request<Section> {
            private static final String REST_PATH = "update_section/";
            private final Section section;

            private Update(Section section) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + section.getId(), Section.class);
                this.section = section;
            }

            @Override
            protected Object getContent() {
                return this.section;
            }
        }

        public class Add
        extends Request<Section> {
            private static final String REST_PATH = "add_section/";
            private final Section section;

            private Add(int projectId, Section section) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + projectId, Section.class);
                this.section = section;
            }

            @Override
            protected Object getContent() {
                return this.section;
            }
        }

        public class List
        extends Request<java.util.List<Section>> {
            private static final String REST_PATH = "get_sections/%s&suite_id=%s";

            private List(int projectId) {
                super(TestRail.this.config, Request.Method.GET, String.format(REST_PATH, projectId, ""), new TypeReference<java.util.List<Section>>(){});
            }

            private List(int projectId, int suiteId) {
                super(TestRail.this.config, Request.Method.GET, String.format(REST_PATH, projectId, suiteId), new TypeReference<java.util.List<Section>>(){});
            }
        }

        public class Get
        extends Request<Section> {
            private static final String REST_PATH = "get_section/";

            private Get(int sectionId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + sectionId, Section.class);
            }
        }
    }

    public class Runs {
        public Get get(int runId) {
            Preconditions.checkArgument((runId > 0 ? 1 : 0) != 0, (Object)"runId should be positive");
            return new Get(runId);
        }

        public List list(int projectId) {
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new List(projectId);
        }

        public Add add(int projectId, @NonNull Run run) {
            if (run == null) {
                throw new NullPointerException("run");
            }
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new Add(projectId, run);
        }

        public Update update(@NonNull Run run) {
            if (run == null) {
                throw new NullPointerException("run");
            }
            return new Update(run);
        }

        public Close close(int runId) {
            Preconditions.checkArgument((runId > 0 ? 1 : 0) != 0, (Object)"runId should be positive");
            return new Close(runId);
        }

        public Delete delete(int runId) {
            Preconditions.checkArgument((runId > 0 ? 1 : 0) != 0, (Object)"runId should be positive");
            return new Delete(runId);
        }

        public class Delete
        extends Request<Void> {
            private static final String REST_PATH = "delete_run/";

            private Delete(int runId) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + runId, Void.class);
            }
        }

        public class Close
        extends Request<Run> {
            private static final String REST_PATH = "close_run/";

            private Close(int runId) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + runId, Run.class);
            }
        }

        public class Update
        extends Request<Run> {
            private static final String REST_PATH = "update_run/";
            private final Run run;

            private Update(Run run) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + run.getId(), Run.class);
                this.run = run;
            }

            @Override
            protected Object getContent() {
                return this.run;
            }
        }

        public class Add
        extends Request<Run> {
            private static final String REST_PATH = "add_run/";
            private final Run run;

            private Add(int projectId, Run run) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + projectId, Run.class);
                this.run = run;
            }

            @Override
            protected Object getContent() {
                return this.run;
            }
        }

        public class List
        extends Request<java.util.List<Run>> {
            private static final String REST_PATH = "get_runs/";
            @JsonView(value={List.class})
            private Date createdAfter;
            @JsonView(value={List.class})
            private Date createdBefore;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> createdBy;
            @JsonView(value={List.class})
            @JsonSerialize(using=BooleanToIntSerializer.class)
            private Boolean isCompleted;
            @JsonView(value={List.class})
            private Integer limit;
            @JsonView(value={List.class})
            private Integer offset;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> milestoneId;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> suiteId;

            private List(int projectId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + projectId, new TypeReference<java.util.List<Run>>(){});
            }

            public Date createdAfter() {
                return this.createdAfter;
            }

            public Date createdBefore() {
                return this.createdBefore;
            }

            public java.util.List<Integer> createdBy() {
                return this.createdBy;
            }

            public Boolean isCompleted() {
                return this.isCompleted;
            }

            public Integer limit() {
                return this.limit;
            }

            public Integer offset() {
                return this.offset;
            }

            public java.util.List<Integer> milestoneId() {
                return this.milestoneId;
            }

            public java.util.List<Integer> suiteId() {
                return this.suiteId;
            }

            public List createdAfter(Date createdAfter) {
                this.createdAfter = createdAfter;
                return this;
            }

            public List createdBefore(Date createdBefore) {
                this.createdBefore = createdBefore;
                return this;
            }

            public List createdBy(java.util.List<Integer> createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            public List isCompleted(Boolean isCompleted) {
                this.isCompleted = isCompleted;
                return this;
            }

            public List limit(Integer limit) {
                this.limit = limit;
                return this;
            }

            public List offset(Integer offset) {
                this.offset = offset;
                return this;
            }

            public List milestoneId(java.util.List<Integer> milestoneId) {
                this.milestoneId = milestoneId;
                return this;
            }

            public List suiteId(java.util.List<Integer> suiteId) {
                this.suiteId = suiteId;
                return this;
            }
        }

        public class Get
        extends Request<Run> {
            private static final String REST_PATH = "get_run/";

            private Get(int runId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + runId, Run.class);
            }
        }
    }

    public class ResultFields {
        public List list() {
            return new List();
        }

        public class List
        extends Request<java.util.List<ResultField>> {
            private static final String REST_PATH = "get_result_fields";

            private List() {
                super(TestRail.this.config, Request.Method.GET, REST_PATH, new TypeReference<java.util.List<ResultField>>(){});
            }
        }
    }

    public class Results {
        public List list(int testId, @NonNull java.util.List<ResultField> resultFields) {
            if (resultFields == null) {
                throw new NullPointerException("resultFields");
            }
            Preconditions.checkArgument((testId > 0 ? 1 : 0) != 0, (Object)"testId should be positive");
            return new List(testId, resultFields);
        }

        public ListForCase listForCase(int runId, int testCaseId, @NonNull java.util.List<ResultField> resultFields) {
            if (resultFields == null) {
                throw new NullPointerException("resultFields");
            }
            Preconditions.checkArgument((runId > 0 ? 1 : 0) != 0, (Object)"runId should be positive");
            Preconditions.checkArgument((testCaseId > 0 ? 1 : 0) != 0, (Object)"testCaseId should be positive");
            return new ListForCase(runId, testCaseId, resultFields);
        }

        public ListForRun listForRun(int runId, @NonNull java.util.List<ResultField> resultFields) {
            if (resultFields == null) {
                throw new NullPointerException("resultFields");
            }
            Preconditions.checkArgument((runId > 0 ? 1 : 0) != 0, (Object)"runId should be positive");
            return new ListForRun(runId, resultFields);
        }

        public Add add(int testId, @NonNull Result result, @NonNull java.util.List<ResultField> resultFields) {
            if (result == null) {
                throw new NullPointerException("result");
            }
            if (resultFields == null) {
                throw new NullPointerException("resultFields");
            }
            Preconditions.checkArgument((testId > 0 ? 1 : 0) != 0, (Object)"testId should be positive");
            return new Add(testId, result, resultFields);
        }

        public AddForCase addForCase(int runId, int testCaseId, @NonNull Result result, @NonNull java.util.List<ResultField> resultFields) {
            if (result == null) {
                throw new NullPointerException("result");
            }
            if (resultFields == null) {
                throw new NullPointerException("resultFields");
            }
            Preconditions.checkArgument((runId > 0 ? 1 : 0) != 0, (Object)"runId should be positive");
            Preconditions.checkArgument((testCaseId > 0 ? 1 : 0) != 0, (Object)"testCaseId should be positive");
            return new AddForCase(runId, testCaseId, result, resultFields);
        }

        public AddList add(int runId, @NonNull java.util.List<Result> results, @NonNull java.util.List<ResultField> resultFields) {
            if (results == null) {
                throw new NullPointerException("results");
            }
            if (resultFields == null) {
                throw new NullPointerException("resultFields");
            }
            Preconditions.checkArgument((runId > 0 ? 1 : 0) != 0, (Object)"runId should be positive");
            Preconditions.checkArgument((!results.isEmpty() ? 1 : 0) != 0, (Object)"results cannot be empty");
            return new AddList(runId, results, resultFields);
        }

        public AddListForCases addForCases(int runId, @NonNull java.util.List<Result> results, @NonNull java.util.List<ResultField> resultFields) {
            if (results == null) {
                throw new NullPointerException("results");
            }
            if (resultFields == null) {
                throw new NullPointerException("resultFields");
            }
            Preconditions.checkArgument((runId > 0 ? 1 : 0) != 0, (Object)"runId should be positive");
            Preconditions.checkArgument((!results.isEmpty() ? 1 : 0) != 0, (Object)"results cannot be empty");
            return new AddListForCases(runId, results, resultFields);
        }

        public class AddListForCases
        extends Request<java.util.List<Result>> {
            private static final String REST_PATH = "add_results_for_cases/";
            private final Result.List results;
            private final java.util.List<ResultField> resultFields;

            private AddListForCases(int runId, java.util.List<Result> results, java.util.List<ResultField> resultFields) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + runId, new TypeReference<java.util.List<Result>>(){});
                this.results = new Result.List(results);
                this.resultFields = resultFields;
            }

            @Override
            protected Object getContent() {
                return this.results;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.resultFields;
            }
        }

        public class AddList
        extends Request<java.util.List<Result>> {
            private static final String REST_PATH = "add_results/";
            private final Result.List results;
            private final java.util.List<ResultField> resultFields;

            private AddList(int runId, java.util.List<Result> results, java.util.List<ResultField> resultFields) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + runId, new TypeReference<java.util.List<Result>>(){});
                this.results = new Result.List(results);
                this.resultFields = resultFields;
            }

            @Override
            protected Object getContent() {
                return this.results;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.resultFields;
            }
        }

        public class AddForCase
        extends Request<Result> {
            private static final String REST_PATH = "add_result_for_case/";
            private final Result result;
            private final java.util.List<ResultField> resultFields;

            private AddForCase(int runId, int testCaseId, Result result, java.util.List<ResultField> resultFields) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + runId + "/" + testCaseId, Result.class);
                this.result = result;
                this.resultFields = resultFields;
            }

            @Override
            protected Object getContent() {
                return this.result;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.resultFields;
            }
        }

        public class Add
        extends Request<Result> {
            private static final String REST_PATH = "add_result/";
            private final Result result;
            private final java.util.List<ResultField> resultFields;

            private Add(int testId, Result result, java.util.List<ResultField> resultFields) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + testId, Result.class);
                this.result = result;
                this.resultFields = resultFields;
            }

            @Override
            protected Object getContent() {
                return this.result;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.resultFields;
            }
        }

        public class ListForCase
        extends Request<java.util.List<Result>> {
            private static final String REST_PATH = "get_results_for_case/";
            private final java.util.List<ResultField> resultFields;
            @JsonView(value={ListForCase.class})
            private Integer limit;
            @JsonView(value={ListForCase.class})
            private Integer offset;
            @JsonView(value={ListForCase.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> statusId;

            private ListForCase(int runId, int testCaseId, java.util.List<ResultField> resultFields) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + runId + "/" + testCaseId, new TypeReference<java.util.List<Result>>(){});
                this.resultFields = resultFields;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.resultFields;
            }

            public java.util.List<ResultField> resultFields() {
                return this.resultFields;
            }

            public Integer limit() {
                return this.limit;
            }

            public Integer offset() {
                return this.offset;
            }

            public java.util.List<Integer> statusId() {
                return this.statusId;
            }

            public ListForCase limit(Integer limit) {
                this.limit = limit;
                return this;
            }

            public ListForCase offset(Integer offset) {
                this.offset = offset;
                return this;
            }

            public ListForCase statusId(java.util.List<Integer> statusId) {
                this.statusId = statusId;
                return this;
            }
        }

        public class ListForRun
        extends Request<java.util.List<Result>> {
            private static final String REST_PATH = "get_results_for_run/";
            private final java.util.List<ResultField> resultFields;
            @JsonView(value={ListForRun.class})
            private Date createdAfter;
            @JsonView(value={ListForRun.class})
            private Date createdBefore;
            @JsonView(value={ListForRun.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> createdBy;
            @JsonView(value={ListForRun.class})
            private Integer limit;
            @JsonView(value={ListForRun.class})
            private Integer offset;
            @JsonView(value={ListForRun.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> statusId;

            private ListForRun(int runId, java.util.List<ResultField> resultFields) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + runId, new TypeReference<java.util.List<Result>>(){});
                this.resultFields = resultFields;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.resultFields;
            }

            public java.util.List<ResultField> resultFields() {
                return this.resultFields;
            }

            public Date createdAfter() {
                return this.createdAfter;
            }

            public Date createdBefore() {
                return this.createdBefore;
            }

            public java.util.List<Integer> createdBy() {
                return this.createdBy;
            }

            public Integer limit() {
                return this.limit;
            }

            public Integer offset() {
                return this.offset;
            }

            public java.util.List<Integer> statusId() {
                return this.statusId;
            }

            public ListForRun createdAfter(Date createdAfter) {
                this.createdAfter = createdAfter;
                return this;
            }

            public ListForRun createdBefore(Date createdBefore) {
                this.createdBefore = createdBefore;
                return this;
            }

            public ListForRun createdBy(java.util.List<Integer> createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            public ListForRun limit(Integer limit) {
                this.limit = limit;
                return this;
            }

            public ListForRun offset(Integer offset) {
                this.offset = offset;
                return this;
            }

            public ListForRun statusId(java.util.List<Integer> statusId) {
                this.statusId = statusId;
                return this;
            }
        }

        public class List
        extends Request<java.util.List<Result>> {
            private static final String REST_PATH = "get_results/";
            private final java.util.List<ResultField> resultFields;
            @JsonView(value={List.class})
            private Integer limit;
            @JsonView(value={List.class})
            private Integer offset;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> statusId;

            private List(int testId, java.util.List<ResultField> resultFields) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + testId, new TypeReference<java.util.List<Result>>(){});
                this.resultFields = resultFields;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.resultFields;
            }

            public java.util.List<ResultField> resultFields() {
                return this.resultFields;
            }

            public Integer limit() {
                return this.limit;
            }

            public Integer offset() {
                return this.offset;
            }

            public java.util.List<Integer> statusId() {
                return this.statusId;
            }

            public List limit(Integer limit) {
                this.limit = limit;
                return this;
            }

            public List offset(Integer offset) {
                this.offset = offset;
                return this;
            }

            public List statusId(java.util.List<Integer> statusId) {
                this.statusId = statusId;
                return this;
            }
        }
    }

    public class Plans {
        public Get get(int planId) {
            Preconditions.checkArgument((planId > 0 ? 1 : 0) != 0, (Object)"planId should be positive");
            return new Get(planId);
        }

        public List list(int projectId) {
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new List(projectId);
        }

        public Add add(int projectId, @NonNull Plan plan) {
            if (plan == null) {
                throw new NullPointerException("plan");
            }
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new Add(projectId, plan);
        }

        public Update update(@NonNull Plan plan) {
            if (plan == null) {
                throw new NullPointerException("plan");
            }
            return new Update(plan);
        }

        public Close close(int planId) {
            Preconditions.checkArgument((planId > 0 ? 1 : 0) != 0, (Object)"planId should be positive");
            return new Close(planId);
        }

        public Delete delete(int planId) {
            Preconditions.checkArgument((planId > 0 ? 1 : 0) != 0, (Object)"planId should be positive");
            return new Delete(planId);
        }

        public AddEntry addEntry(int planId, @NonNull Plan.Entry entry) {
            if (entry == null) {
                throw new NullPointerException("entry");
            }
            Preconditions.checkArgument((planId > 0 ? 1 : 0) != 0, (Object)"planId should be positive");
            return new AddEntry(planId, entry);
        }

        public UpdateEntry updateEntry(int planId, @NonNull Plan.Entry entry) {
            if (entry == null) {
                throw new NullPointerException("entry");
            }
            Preconditions.checkArgument((planId > 0 ? 1 : 0) != 0, (Object)"planId should be positive");
            return new UpdateEntry(planId, entry);
        }

        public DeleteEntry deleteEntry(int planId, int entryId) {
            Preconditions.checkArgument((planId > 0 ? 1 : 0) != 0, (Object)"planId should be positive");
            Preconditions.checkArgument((entryId > 0 ? 1 : 0) != 0, (Object)"entryId should be positive");
            return new DeleteEntry(planId, entryId);
        }

        public class DeleteEntry
        extends Request<Void> {
            private static final String REST_PATH = "delete_plan_entry/%s/%s";

            private DeleteEntry(int planId, int entryId) {
                super(TestRail.this.config, Request.Method.POST, String.format(REST_PATH, planId, entryId), Void.class);
            }
        }

        public class Delete
        extends Request<Void> {
            private static final String REST_PATH = "delete_plan/";

            private Delete(int planId) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + planId, Void.class);
            }
        }

        public class Close
        extends Request<Plan> {
            private static final String REST_PATH = "close_plan/";

            private Close(int planId) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + planId, Plan.class);
            }
        }

        public class UpdateEntry
        extends Request<Plan.Entry> {
            private static final String REST_PATH = "update_plan_entry/%s/%s";
            private final Plan.Entry entry;

            private UpdateEntry(int planId, Plan.Entry entry) {
                super(TestRail.this.config, Request.Method.POST, String.format(REST_PATH, planId, entry.getId()), Plan.Entry.class);
                this.entry = entry;
            }

            @Override
            protected Object getContent() {
                return this.entry;
            }
        }

        public class Update
        extends Request<Plan> {
            private static final String REST_PATH = "update_plan/";
            private final Plan plan;

            private Update(Plan plan) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + plan.getId(), Plan.class);
                this.plan = plan;
            }

            @Override
            protected Object getContent() {
                return this.plan;
            }
        }

        public class AddEntry
        extends Request<Plan.Entry> {
            private static final String REST_PATH = "add_plan_entry/";
            private final Plan.Entry entry;

            private AddEntry(int planId, Plan.Entry entry) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + planId, Plan.Entry.class);
                this.entry = entry;
            }

            @Override
            protected Object getContent() {
                return this.entry;
            }
        }

        public class Add
        extends Request<Plan> {
            private static final String REST_PATH = "add_plan/";
            private final Plan plan;

            private Add(int projectId, Plan plan) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + projectId, Plan.class);
                this.plan = plan;
            }

            @Override
            protected Object getContent() {
                return this.plan;
            }
        }

        public class List
        extends Request<java.util.List<Plan>> {
            private static final String REST_PATH = "get_plans/";
            @JsonView(value={List.class})
            private Date createdAfter;
            @JsonView(value={List.class})
            private Date createdBefore;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> createdBy;
            @JsonView(value={List.class})
            @JsonSerialize(using=BooleanToIntSerializer.class)
            private Boolean isCompleted;
            @JsonView(value={List.class})
            private Integer limit;
            @JsonView(value={List.class})
            private Integer offset;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> milestoneId;

            private List(int projectId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + projectId, new TypeReference<java.util.List<Plan>>(){});
            }

            public Date createdAfter() {
                return this.createdAfter;
            }

            public Date createdBefore() {
                return this.createdBefore;
            }

            public java.util.List<Integer> createdBy() {
                return this.createdBy;
            }

            public Boolean isCompleted() {
                return this.isCompleted;
            }

            public Integer limit() {
                return this.limit;
            }

            public Integer offset() {
                return this.offset;
            }

            public java.util.List<Integer> milestoneId() {
                return this.milestoneId;
            }

            public List createdAfter(Date createdAfter) {
                this.createdAfter = createdAfter;
                return this;
            }

            public List createdBefore(Date createdBefore) {
                this.createdBefore = createdBefore;
                return this;
            }

            public List createdBy(java.util.List<Integer> createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            public List isCompleted(Boolean isCompleted) {
                this.isCompleted = isCompleted;
                return this;
            }

            public List limit(Integer limit) {
                this.limit = limit;
                return this;
            }

            public List offset(Integer offset) {
                this.offset = offset;
                return this;
            }

            public List milestoneId(java.util.List<Integer> milestoneId) {
                this.milestoneId = milestoneId;
                return this;
            }
        }

        public class Get
        extends Request<Plan> {
            private static final String REST_PATH = "get_plan/";

            private Get(int planId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + planId, Plan.class);
            }
        }
    }

    public class Priorities {
        public List list() {
            return new List();
        }

        public class List
        extends Request<java.util.List<Priority>> {
            private static final String REST_PATH = "get_priorities";

            private List() {
                super(TestRail.this.config, Request.Method.GET, REST_PATH, new TypeReference<java.util.List<Priority>>(){});
            }
        }
    }

    public class Milestones {
        public Get get(int milestoneId) {
            Preconditions.checkArgument((milestoneId > 0 ? 1 : 0) != 0, (Object)"milestoneId should be positive");
            return new Get(milestoneId);
        }

        public List list(int projectId) {
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new List(projectId);
        }

        public Add add(int projectId, @NonNull Milestone milestone) {
            if (milestone == null) {
                throw new NullPointerException("milestone");
            }
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new Add(projectId, milestone);
        }

        public Update update(@NonNull Milestone milestone) {
            if (milestone == null) {
                throw new NullPointerException("milestone");
            }
            return new Update(milestone);
        }

        public Delete delete(int milestoneId) {
            Preconditions.checkArgument((milestoneId > 0 ? 1 : 0) != 0, (Object)"milestoneId should be positive");
            return new Delete(milestoneId);
        }

        public class Delete
        extends Request<Void> {
            private static final String REST_PATH = "delete_milestone/";

            private Delete(int milestoneId) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + milestoneId, Void.class);
            }
        }

        public class Update
        extends Request<Milestone> {
            private static final String REST_PATH = "update_milestone/";
            private final Milestone milestone;

            private Update(Milestone milestone) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + milestone.getId(), Milestone.class);
                this.milestone = milestone;
            }

            @Override
            protected Object getContent() {
                return this.milestone;
            }
        }

        public class Add
        extends Request<Milestone> {
            private static final String REST_PATH = "add_milestone/";
            private final Milestone milestone;

            private Add(int projectId, Milestone milestone) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + projectId, Milestone.class);
                this.milestone = milestone;
            }

            @Override
            protected Object getContent() {
                return this.milestone;
            }
        }

        public class List
        extends Request<java.util.List<Milestone>> {
            private static final String REST_PATH = "get_milestones/";
            @JsonView(value={List.class})
            @JsonSerialize(using=BooleanToIntSerializer.class)
            private Boolean isCompleted;

            private List(int projectId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + projectId, new TypeReference<java.util.List<Milestone>>(){});
            }

            public Boolean isCompleted() {
                return this.isCompleted;
            }

            public List isCompleted(Boolean isCompleted) {
                this.isCompleted = isCompleted;
                return this;
            }
        }

        public class Get
        extends Request<Milestone> {
            private static final String REST_PATH = "get_milestone/";

            private Get(int milestoneId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + milestoneId, Milestone.class);
            }
        }
    }

    public class Configurations {
        public List list(int projectId) {
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new List(projectId);
        }

        public class List
        extends Request<java.util.List<Configuration>> {
            private static final String REST_PATH = "get_configs/";

            private List(int projectId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + projectId, new TypeReference<java.util.List<Configuration>>(){});
            }
        }
    }

    public class CaseTypes {
        public List list() {
            return new List();
        }

        public class List
        extends Request<java.util.List<CaseType>> {
            private static final String REST_PATH = "get_case_types";

            private List() {
                super(TestRail.this.config, Request.Method.GET, REST_PATH, new TypeReference<java.util.List<CaseType>>(){});
            }
        }
    }

    public class CaseFields {
        public List list() {
            return new List();
        }

        public class List
        extends Request<java.util.List<CaseField>> {
            private static final String REST_PATH = "get_case_fields";

            private List() {
                super(TestRail.this.config, Request.Method.GET, REST_PATH, new TypeReference<java.util.List<CaseField>>(){});
            }
        }
    }

    public class Cases {
        public Get get(int testCaseId, @NonNull java.util.List<CaseField> caseFields) {
            if (caseFields == null) {
                throw new NullPointerException("caseFields");
            }
            Preconditions.checkArgument((testCaseId > 0 ? 1 : 0) != 0, (Object)"testCaseId should be positive");
            return new Get(testCaseId, caseFields);
        }

        public List list(int projectId, @NonNull java.util.List<CaseField> caseFields) {
            if (caseFields == null) {
                throw new NullPointerException("caseFields");
            }
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new List(projectId, caseFields);
        }

        public List list(int projectId, int suiteId, @NonNull java.util.List<CaseField> caseFields) {
            if (caseFields == null) {
                throw new NullPointerException("caseFields");
            }
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            Preconditions.checkArgument((suiteId > 0 ? 1 : 0) != 0, (Object)"suiteId should be positive");
            return new List(projectId, suiteId, caseFields);
        }

        public Add add(int sectionId, @NonNull Case testCase, @NonNull java.util.List<CaseField> caseFields) {
            if (testCase == null) {
                throw new NullPointerException("testCase");
            }
            if (caseFields == null) {
                throw new NullPointerException("caseFields");
            }
            Preconditions.checkArgument((sectionId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new Add(sectionId, testCase, caseFields);
        }

        public Update update(@NonNull Case testCase, @NonNull java.util.List<CaseField> caseFields) {
            if (testCase == null) {
                throw new NullPointerException("testCase");
            }
            if (caseFields == null) {
                throw new NullPointerException("caseFields");
            }
            return new Update(testCase, caseFields);
        }

        public Delete delete(int testCaseId) {
            Preconditions.checkArgument((testCaseId > 0 ? 1 : 0) != 0, (Object)"testCaseId should be positive");
            return new Delete(testCaseId);
        }

        private Cases() {
        }

        public class Delete
        extends Request<Void> {
            private static final String REST_PATH = "delete_case/";

            private Delete(int testCaseId) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + testCaseId, Void.class);
            }
        }

        public class Update
        extends Request<Case> {
            private static final String REST_PATH = "update_case/";
            private final Case testCase;
            private final java.util.List<CaseField> caseFields;

            private Update(Case testCase, java.util.List<CaseField> caseFields) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + testCase.getId(), Case.class);
                this.testCase = testCase;
                this.caseFields = caseFields;
            }

            @Override
            protected Object getContent() {
                return this.testCase;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.caseFields;
            }
        }

        public class Add
        extends Request<Case> {
            private static final String REST_PATH = "add_case/";
            private final Case testCase;
            private final java.util.List<CaseField> caseFields;

            private Add(int sectionId, Case testCase, java.util.List<CaseField> caseFields) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + sectionId, Case.class);
                this.testCase = testCase;
                this.caseFields = caseFields;
            }

            @Override
            protected Object getContent() {
                return this.testCase;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.caseFields;
            }
        }

        public class List
        extends Request<java.util.List<Case>> {
            private static final String REST_PATH = "get_cases/%s&suite_id=%s";
            private final java.util.List<CaseField> caseFields;
            @JsonView(value={List.class})
            private Integer sectionId;
            @JsonView(value={List.class})
            private Date createdAfter;
            @JsonView(value={List.class})
            private Date createdBefore;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> createdBy;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> milestoneId;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> priorityId;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> typeId;
            @JsonView(value={List.class})
            private Date updatedAfter;
            @JsonView(value={List.class})
            private Date updatedBefore;
            @JsonView(value={List.class})
            @JsonSerialize(using=ListToCsvSerializer.class)
            private java.util.List<Integer> updatedBy;

            private List(int projectId, java.util.List<CaseField> caseFields) {
                super(TestRail.this.config, Request.Method.GET, String.format(REST_PATH, projectId, ""), new TypeReference<java.util.List<Case>>(){});
                this.caseFields = caseFields;
            }

            private List(int projectId, int suiteId, java.util.List<CaseField> caseFields) {
                super(TestRail.this.config, Request.Method.GET, String.format(REST_PATH, projectId, suiteId), new TypeReference<java.util.List<Case>>(){});
                this.caseFields = caseFields;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.caseFields;
            }

            public java.util.List<CaseField> caseFields() {
                return this.caseFields;
            }

            public Integer sectionId() {
                return this.sectionId;
            }

            public Date createdAfter() {
                return this.createdAfter;
            }

            public Date createdBefore() {
                return this.createdBefore;
            }

            public java.util.List<Integer> createdBy() {
                return this.createdBy;
            }

            public java.util.List<Integer> milestoneId() {
                return this.milestoneId;
            }

            public java.util.List<Integer> priorityId() {
                return this.priorityId;
            }

            public java.util.List<Integer> typeId() {
                return this.typeId;
            }

            public Date updatedAfter() {
                return this.updatedAfter;
            }

            public Date updatedBefore() {
                return this.updatedBefore;
            }

            public java.util.List<Integer> updatedBy() {
                return this.updatedBy;
            }

            public List sectionId(Integer sectionId) {
                this.sectionId = sectionId;
                return this;
            }

            public List createdAfter(Date createdAfter) {
                this.createdAfter = createdAfter;
                return this;
            }

            public List createdBefore(Date createdBefore) {
                this.createdBefore = createdBefore;
                return this;
            }

            public List createdBy(java.util.List<Integer> createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            public List milestoneId(java.util.List<Integer> milestoneId) {
                this.milestoneId = milestoneId;
                return this;
            }

            public List priorityId(java.util.List<Integer> priorityId) {
                this.priorityId = priorityId;
                return this;
            }

            public List typeId(java.util.List<Integer> typeId) {
                this.typeId = typeId;
                return this;
            }

            public List updatedAfter(Date updatedAfter) {
                this.updatedAfter = updatedAfter;
                return this;
            }

            public List updatedBefore(Date updatedBefore) {
                this.updatedBefore = updatedBefore;
                return this;
            }

            public List updatedBy(java.util.List<Integer> updatedBy) {
                this.updatedBy = updatedBy;
                return this;
            }
        }

        public class Get
        extends Request<Case> {
            private static final String REST_PATH = "get_case/";
            private final java.util.List<CaseField> caseFields;

            private Get(int testCaseId, java.util.List<CaseField> caseFields) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + testCaseId, Case.class);
                this.caseFields = caseFields;
            }

            @Override
            protected Object getSupplementForDeserialization() {
                return this.caseFields;
            }
        }
    }

    public class Projects {
        public Get get(int projectId) {
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new Get(projectId);
        }

        public List list() {
            return new List();
        }

        public Add add(@NonNull Project project) {
            if (project == null) {
                throw new NullPointerException("project");
            }
            return new Add(project);
        }

        public Update update(@NonNull Project project) {
            if (project == null) {
                throw new NullPointerException("project");
            }
            return new Update(project);
        }

        public Delete delete(int projectId) {
            Preconditions.checkArgument((projectId > 0 ? 1 : 0) != 0, (Object)"projectId should be positive");
            return new Delete(projectId);
        }

        private Projects() {
        }

        public class Delete
        extends Request<Void> {
            private static final String REST_PATH = "delete_project/";

            private Delete(int projectId) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + projectId, Void.class);
            }
        }

        public class Update
        extends Request<Project> {
            private static final String REST_PATH = "update_project/";
            private final Project project;

            private Update(Project project) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH + project.getId(), Project.class);
                if (project == null) {
                    throw new NullPointerException("project");
                }
                this.project = project;
            }

            @Override
            protected Object getContent() {
                return this.project;
            }
        }

        public class Add
        extends Request<Project> {
            private static final String REST_PATH = "add_project";
            private final Project project;

            private Add(Project project) {
                super(TestRail.this.config, Request.Method.POST, REST_PATH, Project.class);
                if (project == null) {
                    throw new NullPointerException("project");
                }
                this.project = project;
            }

            @Override
            protected Object getContent() {
                return this.project;
            }
        }

        public class List
        extends Request<java.util.List<Project>> {
            private static final String REST_PATH = "get_projects";
            @JsonView(value={List.class})
            @JsonSerialize(using=BooleanToIntSerializer.class)
            private Boolean isCompleted;

            private List() {
                super(TestRail.this.config, Request.Method.GET, REST_PATH, new TypeReference<java.util.List<Project>>(){});
            }

            public Boolean isCompleted() {
                return this.isCompleted;
            }

            public List isCompleted(Boolean isCompleted) {
                this.isCompleted = isCompleted;
                return this;
            }
        }

        public class Get
        extends Request<Project> {
            private static final String REST_PATH = "get_project/";

            private Get(int projectId) {
                super(TestRail.this.config, Request.Method.GET, REST_PATH + projectId, Project.class);
            }
        }
    }

    public static class Builder {
        private static final String DEFAULT_BASE_API_PATH = "index.php?/api/v2/";
        private final String endPoint;
        private final String username;
        private final String password;
        private String apiPath;
        private String applicationName;

        private Builder(String endPoint, String username, String password) {
            String sanitizedEndPoint = endPoint.trim();
            if (!sanitizedEndPoint.endsWith("/")) {
                sanitizedEndPoint = sanitizedEndPoint + "/";
            }
            this.endPoint = sanitizedEndPoint;
            this.username = username;
            this.password = password;
            this.apiPath = DEFAULT_BASE_API_PATH;
        }

        public Builder apiPath(@NonNull String apiPath) {
            if (apiPath == null) {
                throw new NullPointerException("apiPath");
            }
            String sanitizedApiPath = apiPath.trim();
            if (sanitizedApiPath.startsWith("/")) {
                sanitizedApiPath = sanitizedApiPath.substring(1);
            }
            if (!sanitizedApiPath.endsWith("/")) {
                sanitizedApiPath = sanitizedApiPath + "/";
            }
            this.apiPath = sanitizedApiPath;
            return this;
        }

        public Builder applicationName(@NonNull String applicationName) {
            if (applicationName == null) {
                throw new NullPointerException("applicationName");
            }
            this.applicationName = applicationName;
            return this;
        }

        public TestRail build() {
            return new TestRail(new TestRailConfig(this.endPoint + this.apiPath, this.username, this.password, this.applicationName));
        }
    }
}

