/*
 * Decompiled with CFR 0.152.
 */
package com.codepine.api.testrail.model;

import com.codepine.api.testrail.TestRail;
import com.codepine.api.testrail.internal.CsvToListDeserializer;
import com.codepine.api.testrail.internal.ListToCsvSerializer;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class Result {
    private static final String CUSTOM_FIELD_KEY_PREFIX = "custom_";
    private int id;
    private int testId;
    @JsonView(value={TestRail.Results.AddListForCases.class})
    private Integer caseId;
    @JsonView(value={TestRail.Results.Add.class, TestRail.Results.AddForCase.class, TestRail.Results.AddList.class, TestRail.Results.AddListForCases.class})
    private Integer statusId;
    private Date createdOn;
    private int createdBy;
    @JsonView(value={TestRail.Results.Add.class, TestRail.Results.AddForCase.class, TestRail.Results.AddList.class, TestRail.Results.AddListForCases.class})
    private Integer assignedtoId;
    @JsonView(value={TestRail.Results.Add.class, TestRail.Results.AddForCase.class, TestRail.Results.AddList.class, TestRail.Results.AddListForCases.class})
    private String comment;
    @JsonView(value={TestRail.Results.Add.class, TestRail.Results.AddForCase.class, TestRail.Results.AddList.class, TestRail.Results.AddListForCases.class})
    private String version;
    @JsonView(value={TestRail.Results.Add.class, TestRail.Results.AddForCase.class, TestRail.Results.AddList.class, TestRail.Results.AddListForCases.class})
    private String elapsed;
    @JsonView(value={TestRail.Results.Add.class, TestRail.Results.AddForCase.class, TestRail.Results.AddList.class, TestRail.Results.AddListForCases.class})
    @JsonSerialize(using=ListToCsvSerializer.class)
    @JsonDeserialize(using=CsvToListDeserializer.class)
    private java.util.List<String> defects;
    @JsonView(value={TestRail.Results.Add.class, TestRail.Results.AddForCase.class, TestRail.Results.AddList.class, TestRail.Results.AddListForCases.class})
    @JsonIgnore
    private Map<String, Object> customFields;

    public Result addDefect(@NonNull String defect) {
        if (defect == null) {
            throw new NullPointerException("defect");
        }
        Preconditions.checkArgument((!defect.isEmpty() ? 1 : 0) != 0, (Object)"defect cannot be empty");
        java.util.List<String> defects = this.getDefects();
        if (defects == null) {
            defects = new ArrayList<String>();
        }
        defects.add(defect);
        this.setDefects(defects);
        return this;
    }

    @JsonAnyGetter
    @JsonSerialize(keyUsing=CustomFieldSerializer.class)
    public Map<String, Object> getCustomFields() {
        return (Map)MoreObjects.firstNonNull(this.customFields, Collections.emptyMap());
    }

    public Result addCustomField(String key, Object value) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key.replaceFirst(CUSTOM_FIELD_KEY_PREFIX, ""), value);
        return this;
    }

    @JsonAnySetter
    private void addUnknownField(String key, Object value) {
        if (key.startsWith(CUSTOM_FIELD_KEY_PREFIX)) {
            this.addCustomField(key, value);
        }
    }

    public <T> T getCustomField(String key) {
        return (T)this.getCustomFields().get(key);
    }

    public int getId() {
        return this.id;
    }

    public int getTestId() {
        return this.testId;
    }

    public Integer getCaseId() {
        return this.caseId;
    }

    public Integer getStatusId() {
        return this.statusId;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public int getCreatedBy() {
        return this.createdBy;
    }

    public Integer getAssignedtoId() {
        return this.assignedtoId;
    }

    public String getComment() {
        return this.comment;
    }

    public String getVersion() {
        return this.version;
    }

    public String getElapsed() {
        return this.elapsed;
    }

    public java.util.List<String> getDefects() {
        return this.defects;
    }

    public Result setId(int id) {
        this.id = id;
        return this;
    }

    public Result setTestId(int testId) {
        this.testId = testId;
        return this;
    }

    public Result setCaseId(Integer caseId) {
        this.caseId = caseId;
        return this;
    }

    public Result setStatusId(Integer statusId) {
        this.statusId = statusId;
        return this;
    }

    public Result setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public Result setCreatedBy(int createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public Result setAssignedtoId(Integer assignedtoId) {
        this.assignedtoId = assignedtoId;
        return this;
    }

    public Result setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Result setVersion(String version) {
        this.version = version;
        return this;
    }

    public Result setElapsed(String elapsed) {
        this.elapsed = elapsed;
        return this;
    }

    public Result setDefects(java.util.List<String> defects) {
        this.defects = defects;
        return this;
    }

    public Result setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getTestId() != other.getTestId()) {
            return false;
        }
        Integer this$caseId = this.getCaseId();
        Integer other$caseId = other.getCaseId();
        if (this$caseId == null ? other$caseId != null : !((Object)this$caseId).equals(other$caseId)) {
            return false;
        }
        Integer this$statusId = this.getStatusId();
        Integer other$statusId = other.getStatusId();
        if (this$statusId == null ? other$statusId != null : !((Object)this$statusId).equals(other$statusId)) {
            return false;
        }
        Date this$createdOn = this.getCreatedOn();
        Date other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        if (this.getCreatedBy() != other.getCreatedBy()) {
            return false;
        }
        Integer this$assignedtoId = this.getAssignedtoId();
        Integer other$assignedtoId = other.getAssignedtoId();
        if (this$assignedtoId == null ? other$assignedtoId != null : !((Object)this$assignedtoId).equals(other$assignedtoId)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$elapsed = this.getElapsed();
        String other$elapsed = other.getElapsed();
        if (this$elapsed == null ? other$elapsed != null : !this$elapsed.equals(other$elapsed)) {
            return false;
        }
        java.util.List<String> this$defects = this.getDefects();
        java.util.List<String> other$defects = other.getDefects();
        if (this$defects == null ? other$defects != null : !((Object)this$defects).equals(other$defects)) {
            return false;
        }
        Map<String, Object> this$customFields = this.getCustomFields();
        Map<String, Object> other$customFields = other.getCustomFields();
        return !(this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getTestId();
        Integer $caseId = this.getCaseId();
        result = result * 59 + ($caseId == null ? 0 : ((Object)$caseId).hashCode());
        Integer $statusId = this.getStatusId();
        result = result * 59 + ($statusId == null ? 0 : ((Object)$statusId).hashCode());
        Date $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 0 : ((Object)$createdOn).hashCode());
        result = result * 59 + this.getCreatedBy();
        Integer $assignedtoId = this.getAssignedtoId();
        result = result * 59 + ($assignedtoId == null ? 0 : ((Object)$assignedtoId).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 0 : $comment.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 0 : $version.hashCode());
        String $elapsed = this.getElapsed();
        result = result * 59 + ($elapsed == null ? 0 : $elapsed.hashCode());
        java.util.List<String> $defects = this.getDefects();
        result = result * 59 + ($defects == null ? 0 : ((Object)$defects).hashCode());
        Map<String, Object> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 0 : ((Object)$customFields).hashCode());
        return result;
    }

    public String toString() {
        return "Result(id=" + this.getId() + ", testId=" + this.getTestId() + ", statusId=" + this.getStatusId() + ", createdOn=" + this.getCreatedOn() + ", createdBy=" + this.getCreatedBy() + ", assignedtoId=" + this.getAssignedtoId() + ", comment=" + this.getComment() + ", version=" + this.getVersion() + ", elapsed=" + this.getElapsed() + ", defects=" + this.getDefects() + ", customFields=" + this.getCustomFields() + ")";
    }

    public static class List {
        @JsonView(value={TestRail.Results.AddList.class, TestRail.Results.AddListForCases.class})
        private java.util.List<Result> results;

        public java.util.List<Result> getResults() {
            return this.results;
        }

        public List setResults(java.util.List<Result> results) {
            this.results = results;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            List other = (List)o;
            if (!other.canEqual(this)) {
                return false;
            }
            java.util.List<Result> this$results = this.getResults();
            java.util.List<Result> other$results = other.getResults();
            return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
        }

        protected boolean canEqual(Object other) {
            return other instanceof List;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            java.util.List<Result> $results = this.getResults();
            result = result * 59 + ($results == null ? 0 : ((Object)$results).hashCode());
            return result;
        }

        public String toString() {
            return "Result.List(results=" + this.getResults() + ")";
        }

        public List() {
        }

        @ConstructorProperties(value={"results"})
        public List(java.util.List<Result> results) {
            this.results = results;
        }
    }

    private static class CustomFieldSerializer
    extends StdKeySerializer {
        private CustomFieldSerializer() {
        }

        public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            super.serialize((Object)(Result.CUSTOM_FIELD_KEY_PREFIX + o), jsonGenerator, serializerProvider);
        }
    }
}

