/*
 * Decompiled with CFR 0.152.
 */
package com.github.bean;

public class Search {
    private final String search;
    private final String location;
    private final double latitude;
    private final double longitude;
    private final boolean fullTime;
    private final int page;

    private Search(String search, String location, double latitude, double longitude, boolean fullTime, int page) {
        this.search = search;
        this.location = location;
        this.latitude = latitude;
        this.longitude = longitude;
        this.fullTime = fullTime;
        this.page = page;
    }

    public String getSearch() {
        return this.search;
    }

    public String getLocation() {
        return this.location;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isFullTime() {
        return this.fullTime;
    }

    public int getPage() {
        return this.page;
    }

    public static class Builder {
        private String search;
        private String location;
        private double latitude;
        private double longitude;
        private boolean fullTime;
        private int page;

        public Builder setSearch(String search) {
            this.search = search;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLatitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder setLongitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder setFullTime(boolean fullTime) {
            this.fullTime = fullTime;
            return this;
        }

        public Builder setPage(int page) {
            this.page = page;
            return this;
        }

        public Search createSearch() {
            if (this.location != null && (this.latitude != 0.0 || this.longitude != 0.0)) {
                throw new IllegalStateException("If you set the location, you cannot set latitude and longitude");
            }
            if (this.page < 0) {
                throw new IllegalStateException("Invalid page number. It must be a positive integer.");
            }
            return new Search(this.search, this.location, this.latitude, this.longitude, this.fullTime, this.page);
        }
    }
}

