package com.codeupsoft.base.common;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;

/**
 * 启动类.
 *
 * @author Liu,Dongdong
 */
@Slf4j
@SuppressWarnings("all")
public class BaseApplication extends Profile {

  /**
   * 启动Spring Boot应用程序.
   *
   * <p>该方法用于启动Spring Boot应用程序，并在启动成功后打印系统信息，包括操作系统名称、版本、架构以及JDK版本等.
   *
   * @param applicationClass 应用程序主类的Class对象
   * @param args 命令行参数
   */
  public static void run(Class<?> applicationClass, String... args) {
    final ConfigurableApplicationContext context = SpringApplication.run(applicationClass, args);

    final StringBuilder builder = new StringBuilder(System.lineSeparator());
    builder.append("---------------------------------");
    builder.append(System.lineSeparator());
    builder.append("Application Started.").append(System.lineSeparator());
    builder
        .append("Os.name: ")
        .append(System.getProperty("os.name"))
        .append(" ")
        .append(System.getProperty("os.version"))
        .append(" ")
        .append(System.getProperty("os.arch"));
    builder.append(System.lineSeparator());
    builder
        .append(System.getProperty("java.vendor"))
        .append(" ")
        .append(System.getProperty("java.version"));
    builder.append(System.lineSeparator());
    builder.append("---------------------------------");
    builder.append(System.lineSeparator());
    log.info(builder.toString());
  }
}
