package com.codeupsoft.base.common.domain;

import java.io.Serial;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 选项类，用于表示键值对形式的选项数据.
 *
 * @author Liu,Dongdong
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Options implements Serializable {

  @Serial private static final long serialVersionUID = -4390250839189634104L;

  /** 选项显示名称. */
  private String label;

  /** 选项值. */
  private String value;

  /** 是否为默认选项. */
  private boolean isDefault;
}
