package com.codeupsoft.base.common.domain;

import java.util.List;
import lombok.Data;

/**
 * 分页结果封装类.
 *
 * @author Liu,Dongdong
 * @since 1.0.0
 */
@SuppressWarnings("unused")
@Data
public class PageResult<T> {

  /** 分页数据列表. */
  private List<T> rows;

  /** 总记录数. */
  private Long total;

  /** 总页数. */
  private Long totalPage;

  /** 当前页码. */
  private Long pageNum;

  /** 每页显示数量. */
  private Long pageSize;
}
