package com.codeupsoft.base.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 启用状态枚举类.
 *
 * @author Liu,Dongdong
 */
@AllArgsConstructor
@Getter
@SuppressWarnings("unused")
public enum IsEnabled implements BaseEnum<String> {
  TRUE("1", "是", true),
  FALSE("0", "否", false),
  ;

  private final String value;
  private final String description;
  private final boolean hasDefault;

  @Override
  public boolean isDefault() {
    return hasDefault;
  }
}
