package com.codeupsoft.base.common.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 统一响应结果封装类.
 *
 * @param <T> 数据类型
 * @author Liu,Dongdong
 * @since 1.0.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class R<T> implements Response<Integer, T> {

  /** 响应状态码. */
  private Integer code;

  /** 响应消息. */
  private String msg;

  /** 响应数据. */
  private T data;

  /**
   * 构建成功响应.
   *
   * @param data 响应数据
   * @param <T> 数据类型
   * @return R对象
   */
  public static <T> R<T> success(T data) {
    return new R<>(200, "操作成功", data);
  }

  /**
   * 构建成功响应(无数据).
   *
   * @return R对象
   */
  public static <T> R<T> success() {
    return success(null);
  }

  /**
   * 构建成功响应（自定义消息）.
   *
   * @param message 成功消息
   * @param data 响应数据
   * @param <T> 数据类型
   * @return R对象
   */
  public static <T> R<T> success(String message, T data) {
    return new R<>(200, message, data);
  }

  /**
   * 构建错误响应(默认错误码500).
   *
   * @param message 错误信息
   * @return R对象
   */
  public static R<Void> error(String message) {
    return error(500, message);
  }

  /**
   * 构建错误响应.
   *
   * @param code 错误码
   * @param message 错误信息
   * @return R对象
   */
  public static R<Void> error(int code, String message) {
    return new R<>(code, message, null);
  }
}
