/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.base.dao.autoconfigure;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.codeupsoft.base.dao.handler.BaseDaoMetaObjectHandler;
import com.codeupsoft.base.dao.properties.BaseDaoProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={MybatisConfiguration.class})
@EnableConfigurationProperties(value={BaseDaoProperties.class})
@ConditionalOnProperty(prefix="codeupsoft.base.dao", name={"auto-configure"}, havingValue="true", matchIfMissing=true)
public class BaseDaoAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDaoAutoConfiguration.class);
    private final BaseDaoProperties baseDaoProperties;

    public BaseDaoAutoConfiguration(BaseDaoProperties baseDaoProperties) {
        this.baseDaoProperties = baseDaoProperties;
        log.debug("BaseDaoAutoConfiguration initialized");
    }

    @Bean
    @ConditionalOnProperty(prefix="codeupsoft.base.dao.interceptor", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (this.baseDaoProperties.getInterceptor().isOptimisticLockerEnabled()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
            log.debug("OptimisticLockerInnerInterceptor added");
        }
        if (this.baseDaoProperties.getInterceptor().isPaginationEnabled()) {
            PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
            paginationInnerInterceptor.setMaxLimit(this.baseDaoProperties.getInterceptor().getMaxPageLimit());
            interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
            log.debug("PaginationInnerInterceptor added, max limit {}", (Object)this.baseDaoProperties.getInterceptor().getMaxPageLimit());
        }
        if (this.baseDaoProperties.getInterceptor().isBlockAttackInnerEnabled()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor());
            log.debug("BlockAttackInnerInterceptor added");
        }
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="codeupsoft.base.dao", name={"base-fill-handler-enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={MetaObjectHandler.class})
    public BaseDaoMetaObjectHandler baseDaoMetaObjectHandler() {
        BaseDaoMetaObjectHandler baseDaoMetaObjectHandler = new BaseDaoMetaObjectHandler();
        log.debug("BaseDaoMetaObjectHandler initialized");
        return baseDaoMetaObjectHandler;
    }
}

