/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.base.dao.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class PageUtils {
    private static final Integer DEFAULT_PAGE_NUM = 1;
    private static final Integer DEFAULT_PAGE_SIZE = 10;
    private static final String DEFAULT_PAGE_NUM_KEY = "pageNum";
    private static final String DEFAULT_PAGE_SIZE_KEY = "pageSize";

    public static <T> IPage<T> getPageRequest() {
        return PageUtils.getPageRequest(DEFAULT_PAGE_NUM_KEY, DEFAULT_PAGE_SIZE_KEY);
    }

    public static <T> IPage<T> getPageRequest(String pageNumKey, String pageSizeKey) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (attributes != null);
        HttpServletRequest request = attributes.getRequest();
        String numStr = request.getParameter(pageNumKey);
        String sizeStr = request.getParameter(pageSizeKey);
        Integer pageNum = DEFAULT_PAGE_NUM;
        try {
            pageNum = Integer.parseInt(numStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer pageSize = DEFAULT_PAGE_SIZE;
        try {
            pageSize = Integer.parseInt(sizeStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Page((long)pageNum.intValue(), (long)pageSize.intValue());
    }

    @Generated
    private PageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

