/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.base.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.codeupsoft.base.common.domain.PageResult;
import com.codeupsoft.base.common.exception.CodeupSoftBaseException;
import com.codeupsoft.base.dao.utils.PageUtils;
import com.codeupsoft.base.service.utils.PageCoverUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import org.springframework.transaction.annotation.Transactional;

public class BaseService<M extends BaseMapper<T>, T>
extends ServiceImpl<M, T> {
    public PageResult<T> pageList(Wrapper<T> queryWrapper) {
        IPage iPage = this.baseMapper.selectPage(PageUtils.getPageRequest(), queryWrapper);
        return PageCoverUtils.coverTableData(iPage);
    }

    public T getByIdOrThrow(Serializable id, String message) {
        Object entity = super.getById(id);
        if (entity == null) {
            throw new CodeupSoftBaseException(message);
        }
        return (T)entity;
    }

    public Optional<T> getOptionalById(Serializable id) {
        return Optional.ofNullable(this.getById(id));
    }

    public T oneOrThrow(LambdaQueryWrapper<T> wrapper, String message) {
        Object entity = super.getOne(wrapper);
        if (entity == null) {
            throw new CodeupSoftBaseException(message);
        }
        return (T)entity;
    }

    public void updateByIdOrThrow(T entity, String message) {
        boolean ok = super.updateById(entity);
        if (!ok) {
            throw new CodeupSoftBaseException(message);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeByIdOrThrow(Serializable id, String message) {
        boolean ok = super.removeById(id);
        if (!ok) {
            throw new CodeupSoftBaseException(message);
        }
    }

    public void saveOrThrow(T entity, String message) {
        boolean ok = super.save(entity);
        if (!ok) {
            throw new CodeupSoftBaseException(message);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveBatchOrThrow(Collection<T> entities, String message) {
        boolean ok = super.saveBatch(entities);
        if (!ok) {
            throw new CodeupSoftBaseException(message);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBatchByIdOrThrow(Collection<T> entities, String message) {
        boolean ok = super.updateBatchById(entities);
        if (!ok) {
            throw new CodeupSoftBaseException(message);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeBatchByIdsOrThrow(Collection<? extends Serializable> ids, String message) {
        boolean ok = super.removeByIds(ids);
        if (!ok) {
            throw new CodeupSoftBaseException(message);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateBatchOrThrow(Collection<T> entities, String message) {
        boolean ok = super.saveOrUpdateBatch(entities);
        if (!ok) {
            throw new CodeupSoftBaseException(message);
        }
    }

    public PageResult<T> pageList(LambdaQueryWrapper<T> wrapper, SFunction<T, ?> orderColumn, boolean asc) {
        if (orderColumn != null) {
            if (asc) {
                wrapper.orderByAsc(orderColumn);
            } else {
                wrapper.orderByDesc(orderColumn);
            }
        }
        IPage page = this.baseMapper.selectPage(PageUtils.getPageRequest(), wrapper);
        return PageCoverUtils.coverTableData(page);
    }
}

