/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.base.service.utils;

import lombok.Generated;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;

public class SpringUtils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public static <T> T getBean(String name) {
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)applicationContext.getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)applicationContext.getBean(name, clazz);
    }

    public static boolean containsBean(String name) {
        return applicationContext.containsBean(name);
    }

    public static boolean isSingleton(String name) {
        return applicationContext.isSingleton(name);
    }

    public static void registerBean(String beanName, Object beanInstance) {
        ApplicationContext applicationContext = SpringUtils.applicationContext;
        if (!(applicationContext instanceof GenericApplicationContext)) {
            throw new IllegalStateException("ApplicationContext does not support dynamic bean registration.");
        }
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)applicationContext;
        genericApplicationContext.getBeanFactory().registerSingleton(beanName, beanInstance);
    }

    public static void removeBean(String beanName) {
        ConfigurableListableBeanFactory beanFactory;
        ApplicationContext applicationContext = SpringUtils.applicationContext;
        if (applicationContext instanceof GenericApplicationContext) {
            GenericApplicationContext genericApplicationContext = (GenericApplicationContext)applicationContext;
            beanFactory = genericApplicationContext.getBeanFactory();
            if (!(beanFactory instanceof DefaultListableBeanFactory)) {
                throw new IllegalStateException("BeanFactory does not support dynamic bean removal.");
            }
        } else {
            throw new IllegalStateException("ApplicationContext does not support dynamic bean removal.");
        }
        ((DefaultListableBeanFactory)beanFactory).removeBeanDefinition(beanName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtils.applicationContext = applicationContext;
    }

    @Generated
    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

