/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.service;

import com.codeupsoft.base.common.exception.CodeupSoftBaseException;
import com.codeupsoft.component.security.handler.SecurityAuthenticateAfterHandler;
import com.codeupsoft.component.security.handler.SecurityAuthenticateBeforeHandler;
import com.codeupsoft.component.security.service.SecurityUserDetailService;
import com.codeupsoft.component.security.service.model.LoginUser;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class SecurityAuthenticateService {
    private final ApplicationContext applicationContext;

    public LoginUser authenticate(Map<String, Object> requestParams) {
        SecurityUserDetailService bean;
        try {
            bean = (SecurityUserDetailService)this.applicationContext.getBean(SecurityUserDetailService.class);
        }
        catch (BeansException e) {
            throw new RuntimeException("SecurityUserDetailService not found");
        }
        this.applicationContext.getBeansOfType(SecurityAuthenticateBeforeHandler.class).forEach((k, v) -> v.handler(requestParams));
        String username = (String)requestParams.getOrDefault("username", "");
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new CodeupSoftBaseException("username is null");
        }
        String password = (String)requestParams.getOrDefault("password", "");
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new CodeupSoftBaseException("password is null");
        }
        LoginUser loginUser = bean.loadUser(username, password);
        this.applicationContext.getBeansOfType(SecurityAuthenticateAfterHandler.class).forEach((k, v) -> v.handler(loginUser));
        return loginUser;
    }

    @Generated
    public SecurityAuthenticateService(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

